/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInClasses;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCourses;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCoursesSpecialSeason;
import org.fenixedu.academic.domain.EnrolmentPeriodInSpecialSeasonEvaluations;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.student.StudentPortalBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsApplication;
import org.joda.time.YearMonthDay;

@StrutsApplication(bundle="TitlesResources", path="student", titleKey="private.student", accessGroup="role(STUDENT)", hint="Student")
@Mapping(module="student", path="/showStudentPortal")
@Forwards(value={@Forward(name="studentPortal", path="/student/main_bd.jsp")})
public class ShowStudentPortalDA
extends Action {
    private static int NUMBER_OF_DAYS_BEFORE_PERIOD_TO_WARN = 100;
    private static int NUMBER_OF_DAYS_AFTER_PERIOD_TO_WARN = 5;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<StudentPortalBean> studentPortalBeans = new ArrayList<StudentPortalBean>();
        ArrayList<String> genericDegreeWarnings = new ArrayList<String>();
        Student student = AccessControl.getPerson().getStudent();
        if (student != null) {
            for (Registration registration : student.getActiveRegistrationsIn(ExecutionSemester.readActualExecutionSemester())) {
                DegreeCurricularPlan degreeCurricularPlan = registration.getActiveDegreeCurricularPlan();
                if (!registration.getAttendingExecutionCoursesForCurrentExecutionPeriod().isEmpty()) {
                    studentPortalBeans.add(new StudentPortalBean(registration.getDegree(), student, registration.getAttendingExecutionCoursesForCurrentExecutionPeriod(), degreeCurricularPlan));
                }
                if (this.hasSpecialSeasonEnrolments(student)) {
                    genericDegreeWarnings.addAll(this.getEnrolmentPeriodCoursesAfterSpecialSeason(degreeCurricularPlan));
                } else {
                    genericDegreeWarnings.addAll(this.getEnrolmentPeriodCourses(degreeCurricularPlan));
                }
                genericDegreeWarnings.addAll(this.getEnrolmentPeriodInSpecialSeasonEvaluations(degreeCurricularPlan));
                genericDegreeWarnings.addAll(this.getEnrolmentPeriodClasses(degreeCurricularPlan));
            }
        }
        request.setAttribute("genericDegreeWarnings", genericDegreeWarnings);
        request.setAttribute("studentPortalBeans", studentPortalBeans);
        request.setAttribute("executionSemester", (Object)ExecutionSemester.readActualExecutionSemester().getQualifiedName());
        return mapping.findForward("studentPortal");
    }

    private List<String> getEnrolmentPeriodCourses(DegreeCurricularPlan degreeCurricularPlan) {
        ArrayList<String> warnings = new ArrayList<String>();
        for (EnrolmentPeriod enrolmentPeriod : degreeCurricularPlan.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCourses) || !this.isBetweenWarnPeriod(enrolmentPeriod)) continue;
            warnings.add(BundleUtil.getString((String)"resources.StudentResources", (String)"message.out.degree.enrolment.period", (String[])new String[]{degreeCurricularPlan.getDegree().getSigla(), YearMonthDay.fromDateFields((Date)enrolmentPeriod.getStartDate()).toString(), YearMonthDay.fromDateFields((Date)enrolmentPeriod.getEndDate()).toString()}));
        }
        return warnings;
    }

    private List<String> getEnrolmentPeriodCoursesAfterSpecialSeason(DegreeCurricularPlan degreeCurricularPlan) {
        ArrayList<String> warnings = new ArrayList<String>();
        for (EnrolmentPeriod enrolmentPeriod : degreeCurricularPlan.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInCurricularCoursesSpecialSeason) || !this.isBetweenWarnPeriod(enrolmentPeriod)) continue;
            warnings.add(BundleUtil.getString((String)"resources.StudentResources", (String)"message.out.degree.enrolment.period.after.special.season", (String[])new String[]{degreeCurricularPlan.getDegree().getSigla(), YearMonthDay.fromDateFields((Date)enrolmentPeriod.getStartDate()).toString(), YearMonthDay.fromDateFields((Date)enrolmentPeriod.getEndDate()).toString()}));
        }
        return warnings;
    }

    private boolean hasSpecialSeasonEnrolments(Student student) {
        ExecutionSemester actualSemester = ExecutionSemester.readActualExecutionSemester();
        ExecutionSemester previousSemester = actualSemester.getPreviousExecutionPeriod();
        ExecutionSemester previousPreviousSemester = previousSemester.getPreviousExecutionPeriod();
        if (actualSemester.isFirstOfYear()) {
            return student.hasSpecialSeasonEnrolments(previousSemester) || student.hasSpecialSeasonEnrolments(previousPreviousSemester);
        }
        return student.hasSpecialSeasonEnrolments(actualSemester) || student.hasSpecialSeasonEnrolments(previousSemester);
    }

    private List<String> getEnrolmentPeriodInSpecialSeasonEvaluations(DegreeCurricularPlan degreeCurricularPlan) {
        HashMap<String, TreeSet<EnrolmentPeriod>> enrolmentPeriodsByDate = new HashMap<String, TreeSet<EnrolmentPeriod>>();
        ArrayList<String> warnings = new ArrayList<String>();
        for (EnrolmentPeriod enrolmentPeriod : degreeCurricularPlan.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInSpecialSeasonEvaluations) || !this.isBetweenWarnPeriod(enrolmentPeriod)) continue;
            String dateKey = YearMonthDay.fromDateFields((Date)enrolmentPeriod.getStartDate()).toString() + YearMonthDay.fromDateFields((Date)enrolmentPeriod.getEndDate()).toString();
            if (enrolmentPeriodsByDate.get(dateKey) == null) {
                enrolmentPeriodsByDate.put(dateKey, new TreeSet<EnrolmentPeriod>(EnrolmentPeriod.COMPARATOR_BY_EXECUTION_SEMESTER));
            }
            ((TreeSet)enrolmentPeriodsByDate.get(dateKey)).add(enrolmentPeriod);
        }
        for (TreeSet periods : enrolmentPeriodsByDate.values()) {
            EnrolmentPeriod enrolmentPeriod;
            if (periods.size() == 1) {
                enrolmentPeriod = (EnrolmentPeriod)((Object)periods.first());
                warnings.add(BundleUtil.getString((String)"resources.StudentResources", (String)"message.out.degree.enrolment.period.in.special.season.evaluations", (String[])new String[]{degreeCurricularPlan.getDegree().getSigla(), enrolmentPeriod.getExecutionPeriod().getSemester().toString(), enrolmentPeriod.getExecutionPeriod().getYear(), YearMonthDay.fromDateFields((Date)enrolmentPeriod.getStartDate()).toString(), YearMonthDay.fromDateFields((Date)enrolmentPeriod.getEndDate()).toString()}));
                continue;
            }
            enrolmentPeriod = (EnrolmentPeriod)((Object)periods.first());
            warnings.add(BundleUtil.getString((String)"resources.StudentResources", (String)"message.out.degree.enrolment.period.in.special.season.evaluations.simple", (String[])new String[]{degreeCurricularPlan.getDegree().getSigla(), YearMonthDay.fromDateFields((Date)enrolmentPeriod.getStartDate()).toString(), YearMonthDay.fromDateFields((Date)enrolmentPeriod.getEndDate()).toString()}));
        }
        return warnings;
    }

    private List<String> getEnrolmentPeriodClasses(DegreeCurricularPlan degreeCurricularPlan) {
        ArrayList<String> warnings = new ArrayList<String>();
        for (EnrolmentPeriod enrolmentPeriod : degreeCurricularPlan.getEnrolmentPeriodsSet()) {
            if (!(enrolmentPeriod instanceof EnrolmentPeriodInClasses) || !this.isBetweenWarnPeriod(enrolmentPeriod)) continue;
            warnings.add(BundleUtil.getString((String)"resources.StudentResources", (String)"message.out.classes.enrolment.period", (String[])new String[]{degreeCurricularPlan.getDegree().getSigla(), YearMonthDay.fromDateFields((Date)enrolmentPeriod.getStartDate()).toString(), YearMonthDay.fromDateFields((Date)enrolmentPeriod.getEndDate()).toString()}));
        }
        return warnings;
    }

    private boolean isBetweenWarnPeriod(EnrolmentPeriod enrolmentPeriod) {
        if (enrolmentPeriod == null) {
            return false;
        }
        YearMonthDay startWarnPeriod = YearMonthDay.fromDateFields((Date)enrolmentPeriod.getStartDate()).minusDays(NUMBER_OF_DAYS_BEFORE_PERIOD_TO_WARN);
        YearMonthDay endWarnPeriod = YearMonthDay.fromDateFields((Date)enrolmentPeriod.getEndDate()).plusDays(NUMBER_OF_DAYS_AFTER_PERIOD_TO_WARN);
        Date now = new Date();
        return startWarnPeriod.toDateTimeAtMidnight().toDate().before(now) && endWarnPeriod.toDateTimeAtMidnight().toDate().after(now);
    }
}

