/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager.writtenEvaluations;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

@StrutsFunctionality(app=RAMApplication.RAMEvaluationsApp.class, path="search-by-date", titleKey="link.written.evaluations.search.by.date")
@Mapping(module="resourceAllocationManager", path="/searchWrittenEvaluationsByDate", formBean="examSearchByDateForm")
@Forwards(value={@Forward(name="show", path="/resourceAllocationManager/writtenEvaluations/showWrittenEvaluationsByDate.jsp")})
public class SearchWrittenEvaluationsByDate
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("show");
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LocalTime end;
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        LocalDate day = this.getDate(dynaActionForm);
        LocalTime begin = this.getTimeDateFromForm(dynaActionForm, "beginningHour", "beginningMinute");
        if (begin == null) {
            begin = new LocalTime(0, 0, 0);
        }
        if ((end = this.getTimeDateFromForm(dynaActionForm, "endHour", "endMinute")) == null) {
            end = new LocalTime(23, 59, 59);
        }
        return this.search(mapping, request, day, begin, end, dynaActionForm);
    }

    public ActionForward returnToSearchPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LocalTime end;
        LocalTime begin;
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String date = request.getParameter("date");
        String selectedBegin = request.getParameter("selectedBegin");
        String selectedEnd = request.getParameter("selectedEnd");
        String year = date.substring(0, 4);
        String month = date.substring(5, 7);
        String day = date.substring(8, 10);
        dynaActionForm.set("year", (Object)year);
        dynaActionForm.set("month", (Object)month);
        dynaActionForm.set("day", (Object)day);
        if (selectedBegin != null && selectedBegin.length() > 0) {
            String hour = selectedBegin.substring(0, 2);
            String minute = selectedBegin.substring(3, 5);
            dynaActionForm.set("beginningHour", (Object)hour);
            dynaActionForm.set("beginningMinute", (Object)minute);
            begin = this.getTimeDateFromForm(hour, minute);
        } else {
            begin = new LocalTime(0, 0, 0);
        }
        if (selectedEnd != null && selectedEnd.length() > 0) {
            String hour = selectedEnd.substring(0, 2);
            String minute = selectedEnd.substring(3, 5);
            dynaActionForm.set("endHour", (Object)selectedEnd.substring(0, 2));
            dynaActionForm.set("endMinute", (Object)selectedEnd.substring(3, 5));
            end = this.getTimeDateFromForm(hour, minute);
        } else {
            end = new LocalTime(23, 59, 59);
        }
        LocalDate localDate = new LocalDate(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
        return this.search(mapping, request, localDate, begin, end, dynaActionForm);
    }

    public static boolean isEvalBetweenDates(WrittenEvaluation eval, LocalTime begin, LocalTime end) {
        HourMinuteSecond bhms = eval.getBeginningDateHourMinuteSecond();
        HourMinuteSecond ehms = eval.getEndDateHourMinuteSecond();
        return bhms.toLocalTime().isBefore((ReadablePartial)end) && ehms.toLocalTime().isAfter((ReadablePartial)begin);
    }

    public ActionForward search(ActionMapping mapping, HttpServletRequest request, LocalDate day, LocalTime begin, LocalTime end, DynaActionForm dynaActionForm) throws Exception {
        Integer totalOfStudents = 0;
        HashSet<WrittenEvaluation> writtenEvaluations = new HashSet<WrittenEvaluation>();
        for (ExecutionCourse executionCourse : this.getExecutionCoursesActiveIn(day)) {
            for (Evaluation evaluation : executionCourse.getAssociatedEvaluationsSet()) {
                WrittenEvaluation writtenEvaluation;
                LocalDate evaluationDate;
                if (!(evaluation instanceof WrittenEvaluation) || (evaluationDate = (writtenEvaluation = (WrittenEvaluation)((Object)evaluation)).getDayDateYearMonthDay().toLocalDate()) == null || !evaluationDate.equals((Object)day) || !SearchWrittenEvaluationsByDate.isEvalBetweenDates(writtenEvaluation, begin, end)) continue;
                if (!writtenEvaluations.contains((Object)writtenEvaluation)) {
                    totalOfStudents = totalOfStudents + writtenEvaluation.getCountStudentsEnroledAttendingExecutionCourses();
                }
                writtenEvaluations.add(writtenEvaluation);
            }
        }
        request.setAttribute("availableRoomIndicationMsg", (Object)BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"info.total.students.vs.available.seats", (String[])new String[]{totalOfStudents.toString(), SpaceUtils.countAllAvailableSeatsForExams().toString()}));
        request.setAttribute("writtenEvaluations", writtenEvaluations);
        return mapping.findForward("show");
    }

    private Collection<ExecutionCourse> getExecutionCoursesActiveIn(LocalDate day) {
        DateTime date = day.toDateTimeAtStartOfDay();
        HashSet<ExecutionCourse> courses = new HashSet<ExecutionCourse>();
        for (ExecutionInterval interval : Bennu.getInstance().getExecutionIntervalsSet()) {
            if (!(interval instanceof ExecutionSemester) || !interval.getAcademicInterval().contains((ReadableInstant)date)) continue;
            ExecutionSemester semester = (ExecutionSemester)((Object)interval);
            courses.addAll(semester.getAssociatedExecutionCoursesSet());
        }
        return courses;
    }

    private LocalDate getDate(DynaActionForm dynaActionForm) throws ParseException {
        String yearString = dynaActionForm.getString("year");
        String monthString = dynaActionForm.getString("month");
        String dayString = dynaActionForm.getString("day");
        return new LocalDate(Integer.parseInt(yearString), Integer.parseInt(monthString), Integer.parseInt(dayString));
    }

    private LocalTime getTimeDateFromForm(DynaActionForm dynaActionForm, String hourField, String minuteField) throws ParseException {
        String hourString = dynaActionForm.getString(hourField);
        String minuteString = dynaActionForm.getString(minuteField);
        return hourString == null || hourString.isEmpty() || minuteString == null || minuteString.isEmpty() ? null : this.getTimeDateFromForm(hourString, minuteString);
    }

    private LocalTime getTimeDateFromForm(String hourString, String minuteString) throws ParseException {
        return new LocalTime(Integer.parseInt(hourString), Integer.parseInt(minuteString), 0);
    }
}

