/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.space.EventSpaceOccupation;
import org.fenixedu.academic.domain.space.LessonInstanceSpaceOccupation;
import org.fenixedu.academic.domain.space.LessonSpaceOccupation;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.dto.resourceAllocationManager.OccupationType;
import org.fenixedu.academic.dto.resourceAllocationManager.SearchOccupationEventsBean;
import org.fenixedu.academic.dto.resourceAllocationManager.SpaceOccupationEventBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.SearchOccupationsDA$callable$run;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=RAMApplication.RAMEvaluationsApp.class, path="search-occupations", titleKey="title.search.occupations")
@Mapping(module="resourceAllocationManager", path="/searchOccupations", parameter="method")
@Forwards(value={@Forward(name="prepareSearchEvents", path="/resourceAllocationManager/searchSpaceOccupations.jsp")})
public class SearchOccupationsDA
extends FenixDispatchAction {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward prepareSearchEvents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SearchOccupationEventsBean bean = new SearchOccupationEventsBean();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("prepareSearchEvents");
    }

    public ActionForward searchSpaceEvents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SearchOccupationEventsBean bean = (SearchOccupationEventsBean)this.getRenderedObject();
        if (bean.getStart().isAfter((ReadablePartial)bean.getEnd())) {
            request.setAttribute("startAfterEnd", (Object)true);
        } else {
            Collection<SpaceOccupationEventBean> results = SearchOccupationsDA.run(bean);
            request.setAttribute("results", results);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("prepareSearchEvents");
    }

    public static Collection<SpaceOccupationEventBean> run(SearchOccupationEventsBean bean) {
        return SearchOccupationsDA.run(bean.getBuilding(), bean.getStart().toDateTimeAtStartOfDay(), bean.getEnd().toDateTimeAtStartOfDay(), bean.getTypes());
    }

    private static OccupationType getType(Occupation occupation) {
        if (occupation instanceof LessonSpaceOccupation || occupation instanceof LessonInstanceSpaceOccupation) {
            return OccupationType.LESSON;
        }
        if (occupation instanceof WrittenEvaluationSpaceOccupation) {
            return OccupationType.EVALUATION;
        }
        if (occupation.getClass().equals(Occupation.class)) {
            return OccupationType.GENERIC;
        }
        return null;
    }

    private static Set<Space> getAllChildren(Space space) {
        HashSet<Space> children = new HashSet<Space>();
        for (Space child : space.getChildren()) {
            if (SpaceUtils.isRoom(child) || SpaceUtils.isRoomSubdivision(child)) {
                children.add(child);
            }
            children.addAll(SearchOccupationsDA.getAllChildren(child));
        }
        return children;
    }

    public static Collection<SpaceOccupationEventBean> run(Space space, DateTime dateTime, DateTime dateTime2, List<OccupationType> list) {
        return (Collection)advice$run.perform((Callable)new SearchOccupationsDA$callable$run(space, dateTime, dateTime2, list));
    }

    static /* synthetic */ Collection<SpaceOccupationEventBean> advised$run(Space building, DateTime start, DateTime end, List<OccupationType> types) {
        HashSet<SpaceOccupationEventBean> beans = new HashSet<SpaceOccupationEventBean>();
        end = end.plusDays(1);
        Interval searchInterval = new Interval((ReadableInstant)start, (ReadableInstant)end);
        for (Space space : SearchOccupationsDA.getAllChildren(building)) {
            Map map = SearchOccupationsDA.getEventSpaceOccupations(space, searchInterval).asMap();
            Set spaceOccupations = map.keySet();
            if (spaceOccupations.isEmpty()) continue;
            for (Occupation occupation : spaceOccupations) {
                OccupationType occupationType = SearchOccupationsDA.getType(occupation);
                if (!types.contains((Object)occupationType)) continue;
                if (occupation instanceof WrittenEvaluationSpaceOccupation) {
                    WrittenEvaluationSpaceOccupation evalOccupation = (WrittenEvaluationSpaceOccupation)occupation;
                    for (WrittenEvaluation eval : evalOccupation.getWrittenEvaluationsSet()) {
                        Interval durationInterval = eval.getDurationInterval();
                        if (!searchInterval.overlaps((ReadableInterval)durationInterval)) continue;
                        String desc = eval instanceof WrittenTest ? String.format("(%s) %s - %s", eval.getEvaluationType(), eval.getName(), ((WrittenTest)((Object)eval)).getDescription()) : String.format("(%s) %s", eval.getEvaluationType(), eval.getName());
                        beans.add(new SpaceOccupationEventBean(space, durationInterval, desc, occupationType));
                    }
                    continue;
                }
                String desc = SearchOccupationsDA.getPresentationString(occupation);
                for (Interval interval : (Collection)map.get(occupation)) {
                    beans.add(new SpaceOccupationEventBean(space, interval, desc, occupationType));
                }
            }
        }
        return beans;
    }

    private static String getPresentationString(Occupation occupation) {
        if (occupation.getClass().equals(Occupation.class)) {
            return occupation.getSubject();
        }
        if (occupation instanceof EventSpaceOccupation) {
            return ((EventSpaceOccupation)occupation).getPresentationString();
        }
        return "";
    }

    private static Multimap<Occupation, Interval> getEventSpaceOccupations(Space space, Interval searchInterval) {
        HashMultimap result = HashMultimap.create();
        for (Occupation occupation : space.getOccupationSet()) {
            for (Interval occupationInterval : occupation.getIntervals()) {
                if (!occupationInterval.overlaps((ReadableInterval)searchInterval)) continue;
                result.put((Object)occupation, (Object)occupationInterval);
            }
        }
        return result;
    }
}

