/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publico.candidacies.degreeCandidacyForGraduatedPerson;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonIndividualProcess;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonIndividualProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonProcess;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.publico.PublicApplication;
import org.fenixedu.academic.ui.struts.action.publico.candidacies.RefactoredIndividualCandidacyProcessPublicDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StrutsFunctionality(app=PublicApplication.PublicCandidaciesApp.class, path="graduated-person", titleKey="title.application.name.degreeCandidacyForGraduatedPerson")
@Mapping(path="/candidacies/caseHandlingDegreeCandidacyForGraduatedPersonIndividualProcess", module="publico")
@Forwards(value={@Forward(name="open-candidacy-process-closed", path="/publico/candidacy/candidacyProcessClosed.jsp"), @Forward(name="show-pre-creation-candidacy-form", path="/publico/candidacy/preCreationCandidacyForm.jsp"), @Forward(name="show-email-message-sent", path="/publico/candidacy/showEmailSent.jsp"), @Forward(name="show-application-submission-conditions", path="/publico/candidacy/applicationSubmissionConditions.jsp"), @Forward(name="open-candidacy-processes-not-found", path="/publico/candidacy/individualCandidacyNotFound.jsp"), @Forward(name="show-candidacy-creation-page", path="/publico/candidacy/degreeForGraduatedPerson/createCandidacyPartOne.jsp"), @Forward(name="candidacy-continue-creation", path="/publico/candidacy/degreeForGraduatedPerson/createCandidacyPartTwo.jsp"), @Forward(name="inform-submited-candidacy", path="/publico/candidacy/candidacySubmited.jsp"), @Forward(name="show-candidacy-details", path="/publico/candidacy/degreeForGraduatedPerson/viewCandidacy.jsp"), @Forward(name="edit-candidacy", path="/publico/candidacy/degreeForGraduatedPerson/editCandidacy.jsp"), @Forward(name="edit-candidacy-habilitations", path="/publico/candidacy/degreeForGraduatedPerson/editCandidacyHabilitations.jsp"), @Forward(name="edit-candidacy-documents", path="/publico/candidacy/degreeForGraduatedPerson/editCandidacyDocuments.jsp"), @Forward(name="upload-photo", path="/publico/candidacy/degreeForGraduatedPerson/uploadPhoto.jsp")})
public class DegreeCandidacyForGraduatedPersonIndividualProcessRefactoredDA
extends RefactoredIndividualCandidacyProcessPublicDA {
    private static final Logger logger = LoggerFactory.getLogger(DegreeCandidacyForGraduatedPersonIndividualProcessRefactoredDA.class);

    protected Class<? extends CandidacyProcess> getParentProcessType() {
        return DegreeCandidacyForGraduatedPersonProcess.class;
    }

    @Override
    protected void setStartInformation(ActionForm form, HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    protected Class getProcessType() {
        return DegreeCandidacyForGraduatedPersonIndividualProcess.class;
    }

    @Override
    protected String getCandidacyNameKey() {
        return "title.application.name.degreeCandidacyForGraduatedPerson";
    }

    @Override
    public ActionForward viewCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCandidacyForGraduatedPersonIndividualProcess individualCandidacyProcess = (DegreeCandidacyForGraduatedPersonIndividualProcess)((Object)request.getAttribute("individualCandidacyProcess"));
        DegreeCandidacyForGraduatedPersonIndividualProcessBean bean = new DegreeCandidacyForGraduatedPersonIndividualProcessBean(individualCandidacyProcess);
        bean.setPersonBean(new PersonBean(individualCandidacyProcess.getPersonalDetails()));
        request.setAttribute("individualCandidacyProcessBean", (Object)bean);
        return mapping.findForward("show-candidacy-details");
    }

    public ActionForward prepareCandidacyCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        CandidacyProcess candidacyProcess = this.getCurrentOpenParentProcess();
        String hash = request.getParameter("hash");
        DegreeOfficePublicCandidacyHashCode candidacyHashCode = (DegreeOfficePublicCandidacyHashCode)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(hash));
        if (candidacyHashCode == null) {
            return mapping.findForward("open-candidacy-processes-not-found");
        }
        if (candidacyHashCode.getIndividualCandidacyProcess() != null && candidacyHashCode.getIndividualCandidacyProcess().getCandidacyProcess() == candidacyProcess) {
            request.setAttribute("individualCandidacyProcess", (Object)candidacyHashCode.getIndividualCandidacyProcess());
            return this.viewCandidacy(mapping, form, request, response);
        }
        if (candidacyHashCode.getIndividualCandidacyProcess() != null && candidacyHashCode.getIndividualCandidacyProcess().getCandidacyProcess() != candidacyProcess) {
            return mapping.findForward("open-candidacy-processes-not-found");
        }
        DegreeCandidacyForGraduatedPersonIndividualProcessBean bean = new DegreeCandidacyForGraduatedPersonIndividualProcessBean();
        bean.setPrecedentDegreeInformation(new PrecedentDegreeInformationBean());
        bean.setPersonBean(new PersonBean());
        bean.setCandidacyProcess(candidacyProcess);
        bean.setPublicCandidacyHashCode(candidacyHashCode);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        bean.getPersonBean().setEmail(candidacyHashCode.getEmail());
        return mapping.findForward("show-candidacy-creation-page");
    }

    private ActionForward forwardTo(ActionMapping mapping, HttpServletRequest request) {
        if (this.getFromRequest(request, "userAction").equals("createCandidacy")) {
            return mapping.findForward("candidacy-continue-creation");
        }
        if (this.getFromRequest(request, "userAction").equals("editCandidacyQualifications")) {
            return mapping.findForward("edit-candidacy-habilitations");
        }
        return null;
    }

    @Override
    public ActionForward addConcludedHabilitationsEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCandidacyForGraduatedPersonIndividualProcessBean bean = (DegreeCandidacyForGraduatedPersonIndividualProcessBean)this.getIndividualCandidacyProcessBean();
        bean.addConcludedFormationBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        this.invalidateDocumentFileRelatedViewStates();
        return this.forwardTo(mapping, request);
    }

    @Override
    public ActionForward removeConcludedHabilitationsEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCandidacyForGraduatedPersonIndividualProcessBean bean = (DegreeCandidacyForGraduatedPersonIndividualProcessBean)this.getIndividualCandidacyProcessBean();
        Integer index = this.getIntegerFromRequest(request, "removeIndex");
        bean.removeFormationConcludedBean(index);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        this.invalidateDocumentFileRelatedViewStates();
        return this.forwardTo(mapping, request);
    }

    public ActionForward submitCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, FenixServiceException {
        try {
            ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
            if (actionForwardError != null) {
                return actionForwardError;
            }
            DegreeCandidacyForGraduatedPersonIndividualProcessBean bean = (DegreeCandidacyForGraduatedPersonIndividualProcessBean)this.getIndividualCandidacyProcessBean();
            bean.setInternalPersonCandidacy(Boolean.TRUE);
            boolean isValid = this.hasInvalidViewState();
            if (!isValid) {
                this.invalidateDocumentFileRelatedViewStates();
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("candidacy-continue-creation");
            }
            ArrayList<Degree> degreeList = new ArrayList<Degree>();
            degreeList.add(bean.getSelectedDegree());
            if (this.candidacyIndividualProcessExistsForThisEmail(bean.getPersonBean().getEmail(), degreeList)) {
                this.addActionMessage("error", request, "error.candidacy.hash.code.already.bounded");
                this.invalidateDocumentFileRelatedViewStates();
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("candidacy-continue-creation");
            }
            if (!bean.getHonorAgreement().booleanValue()) {
                this.addActionMessage("error", request, "error.must.agree.on.declaration.of.honor");
                this.invalidateDocumentFileRelatedViewStates();
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("candidacy-continue-creation");
            }
            DegreeCandidacyForGraduatedPersonIndividualProcess process2 = (DegreeCandidacyForGraduatedPersonIndividualProcess)((Object)this.createNewPublicProcess(bean));
            request.setAttribute("process", (Object)process2);
            request.setAttribute("mappingPath", (Object)mapping.getPath());
            request.setAttribute("individualCandidacyProcess", (Object)process2);
            request.setAttribute("endSubmissionDate", (Object)this.getFormattedApplicationSubmissionEndDate());
            return mapping.findForward("inform-submited-candidacy");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            logger.error(e.getMessage(), (Throwable)((Object)e));
            this.getIndividualCandidacyProcessBean().getPersonBean().setPerson(null);
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("candidacy-continue-creation");
        }
    }

    public ActionForward editCandidacyProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DegreeCandidacyForGraduatedPersonIndividualProcessBean bean = (DegreeCandidacyForGraduatedPersonIndividualProcessBean)this.getIndividualCandidacyProcessBean();
        try {
            ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
            if (actionForwardError != null) {
                return actionForwardError;
            }
            if (!this.isApplicationSubmissionPeriodValid()) {
                return this.beginCandidacyProcessIntro(mapping, form, request, response);
            }
            this.executeActivity((Process)((Object)bean.getIndividualCandidacyProcess()), "EditPublicCandidacyPersonalInformation", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("edit-candidacy");
        }
        request.setAttribute("individualCandidacyProcess", (Object)bean.getIndividualCandidacyProcess());
        return this.backToViewCandidacyInternal(mapping, form, request, response);
    }

    public ActionForward editCandidacyQualifications(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        DegreeCandidacyForGraduatedPersonIndividualProcessBean bean = (DegreeCandidacyForGraduatedPersonIndividualProcessBean)this.getIndividualCandidacyProcessBean();
        try {
            boolean isValid = this.hasInvalidViewState();
            if (!isValid) {
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("edit-candidacy-habilitations");
            }
            this.executeActivity((Process)((Object)bean.getIndividualCandidacyProcess()), "EditPublicCandidacyHabilitations", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("edit-candidacy-habilitations");
        }
        request.setAttribute("individualCandidacyProcess", (Object)bean.getIndividualCandidacyProcess());
        return this.backToViewCandidacyInternal(mapping, form, request, response);
    }

    @Override
    protected String getCandidacyInformationLinkDefaultLanguage() {
        String message = this.getStringFromDefaultBundle("link.candidacy.information.default.degreeCandidacyForGraduatedPerson");
        return MessageFormat.format(message, Installation.getInstance().getInstituitionURL());
    }

    @Override
    protected String getCandidacyInformationLinkEnglish() {
        String message = this.getStringFromDefaultBundle("link.candidacy.information.english.degreeCandidacyForGraduatedPerson");
        return MessageFormat.format(message, Installation.getInstance().getInstituitionURL());
    }
}

