/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.payments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.PaymentsManagementDTO;
import org.fenixedu.academic.dto.accounting.SelectableEntryBean;
import org.fenixedu.academic.service.services.accounting.CreatePaymentsForEvents;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.DateTime;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/payments", module="academicAdministration", formBeanClass=FenixActionForm.class, functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="showOperations", path="/academicAdminOffice/payments/showOperations.jsp"), @Forward(name="showEvents", path="/academicAdminOffice/payments/showEvents.jsp"), @Forward(name="showEventsWithPayments", path="/academicAdminOffice/payments/showEventsWithPayments.jsp"), @Forward(name="showPaymentsForEvent", path="/academicAdminOffice/payments/showPaymentsForEvent.jsp"), @Forward(name="preparePayment", path="/academicAdminOffice/payments/preparePayment.jsp"), @Forward(name="preparePrintGuide", path="/academicAdministration/guides.do?method=preparePrintGuide"), @Forward(name="showReceipt", path="/academicAdministration/receipts.do?method=prepareShowReceipt"), @Forward(name="showEventsWithPaymentCodes", path="/academicAdminOffice/payments/showEventsWithPaymentCodes.jsp"), @Forward(name="showPaymentCodesForEvent", path="/academicAdminOffice/payments/showPaymentCodesForEvent.jsp")})
public class PaymentsManagementDispatchAction
extends FenixDispatchAction {
    protected PaymentsManagementDTO searchNotPayedEventsForPerson(HttpServletRequest request, Person person) {
        PaymentsManagementDTO paymentsManagementDTO = new PaymentsManagementDTO(person);
        for (Event event : person.getNotPayedEvents()) {
            paymentsManagementDTO.addEntryDTOs(event.calculateEntries());
        }
        return paymentsManagementDTO;
    }

    public ActionForward showEvents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            request.setAttribute("paymentsManagementDTO", (Object)this.searchNotPayedEventsForPerson(request, this.getPerson(request)));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            return this.showOperations(mapping, form, request, response);
        }
        return mapping.findForward("showEvents");
    }

    protected List<SelectableEntryBean> getSelectableEntryBeans(Set<Entry> entries, Collection<Entry> entriesToSelect) {
        ArrayList<SelectableEntryBean> selectableEntryBeans = new ArrayList<SelectableEntryBean>();
        for (Entry entry : entries) {
            selectableEntryBeans.add(new SelectableEntryBean(entriesToSelect.contains((Object)entry), entry));
        }
        return selectableEntryBeans;
    }

    public ActionForward preparePayment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentsManagementDTO paymentsManagementDTO = (PaymentsManagementDTO)RenderUtils.getViewState((String)"paymentsManagementDTO").getMetaObject().getObject();
        paymentsManagementDTO.setPaymentDate(new DateTime());
        request.setAttribute("paymentsManagementDTO", (Object)paymentsManagementDTO);
        if (paymentsManagementDTO.getSelectedEntries().isEmpty()) {
            this.addActionMessage("context", request, "error.payments.payment.entries.selection.is.required");
            return mapping.findForward("showEvents");
        }
        return mapping.findForward("preparePayment");
    }

    public ActionForward preparePaymentUsingContributorPartyPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentsManagementDTO paymentsManagementDTO = (PaymentsManagementDTO)this.getObjectFromViewState("paymentsManagementDTO-edit");
        RenderUtils.invalidateViewState((String)"paymentsManagementDTO-edit");
        paymentsManagementDTO.setContributorParty(null);
        paymentsManagementDTO.setContributorNumber(null);
        paymentsManagementDTO.setContributorName(null);
        request.setAttribute("paymentsManagementDTO", (Object)paymentsManagementDTO);
        return mapping.findForward("preparePayment");
    }

    public ActionForward doPayment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentsManagementDTO paymentsManagementDTO = (PaymentsManagementDTO)RenderUtils.getViewState((String)"paymentsManagementDTO-edit").getMetaObject().getObject();
        if (paymentsManagementDTO.getSelectedEntries().isEmpty()) {
            this.addActionMessage("context", request, "error.payments.payment.entries.selection.is.required");
            request.setAttribute("paymentsManagementDTO", (Object)paymentsManagementDTO);
            return mapping.findForward("preparePayment");
        }
        paymentsManagementDTO.getPerson().getReceiptsSet().size();
        try {
            Receipt receipt = CreatePaymentsForEvents.run(PaymentsManagementDispatchAction.getUserView(request).getPerson().getUser(), paymentsManagementDTO.getSelectedEntries(), PaymentMode.CASH, paymentsManagementDTO.isDifferedPayment(), paymentsManagementDTO.getPaymentDate(), paymentsManagementDTO.getPerson(), paymentsManagementDTO.getContributorName(), paymentsManagementDTO.getContributorNumber(), paymentsManagementDTO.getContributorAddress());
            request.setAttribute("personId", (Object)paymentsManagementDTO.getPerson().getExternalId());
            request.setAttribute("receiptID", (Object)receipt.getExternalId());
            return mapping.findForward("showReceipt");
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
            request.setAttribute("paymentsManagementDTO", (Object)paymentsManagementDTO);
            return mapping.findForward("preparePayment");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
            request.setAttribute("paymentsManagementDTO", (Object)paymentsManagementDTO);
            return mapping.findForward("preparePayment");
        }
    }

    protected Person getPerson(HttpServletRequest request) {
        return (Person)((Object)this.getDomainObject(request, "personId"));
    }

    public ActionForward preparePaymentInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("paymentsManagementDTO", RenderUtils.getViewState((String)"paymentsManagementDTO-edit").getMetaObject().getObject());
        return mapping.findForward("preparePayment");
    }

    public ActionForward prepareShowEventsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("paymentsManagementDTO", RenderUtils.getViewState((String)"paymentsManagementDTO").getMetaObject().getObject());
        return mapping.findForward("showEvents");
    }

    public ActionForward backToShowOperations(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.setContextInformation(request);
        return this.findMainForward(mapping);
    }

    protected void setContextInformation(HttpServletRequest request) {
        request.setAttribute("person", (Object)this.getPerson(request));
    }

    protected ActionForward findMainForward(ActionMapping mapping) {
        return mapping.findForward("showOperations");
    }

    public ActionForward showOperations(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("person", (Object)this.getPerson(request));
        return mapping.findForward("showOperations");
    }

    public ActionForward showEventsWithPayments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("person", (Object)this.getPerson(request));
        return mapping.findForward("showEventsWithPayments");
    }

    public ActionForward showPaymentsForEvent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("person", (Object)this.getPerson(request));
        request.setAttribute("event", (Object)this.getEvent(request));
        return mapping.findForward("showPaymentsForEvent");
    }

    protected Event getEvent(HttpServletRequest request) {
        return (Event)((Object)this.getDomainObject(request, "eventId"));
    }

    public ActionForward preparePrintGuide(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("preparePrintGuide");
    }

    public ActionForward showEventsWithPaymentCodes(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = this.getPerson(request);
        request.setAttribute("person", (Object)person);
        request.setAttribute("eventsWithPaymentCodes", this.searchOpenEventsWithPaymentCodes(request, person));
        return mapping.findForward("showEventsWithPaymentCodes");
    }

    public ActionForward showPaymentCodesForEvent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Event event = this.getEvent(request);
        request.setAttribute("event", (Object)event);
        request.setAttribute("accountingEventPaymentCodes", event.getNonProcessedPaymentCodes());
        return mapping.findForward("showPaymentCodesForEvent");
    }

    private Collection<Event> searchOpenEventsWithPaymentCodes(HttpServletRequest request, Person person) {
        HashSet<Event> events = new HashSet<Event>();
        for (Event event : person.getNotPayedEvents()) {
            if (!event.isOpen() || !event.hasNonProcessedPaymentCodes()) continue;
            events.add(event);
        }
        return events;
    }
}

