/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.interfaces.HasExecutionDegree;
import org.fenixedu.academic.domain.interfaces.HasExecutionSemester;

public class ExecutionCourseBean
implements Serializable,
HasExecutionSemester,
HasExecutionDegree {
    private ExecutionDegree executionDegree;
    private Degree degree;
    private CurricularYear curricularYear;
    private ExecutionCourse sourceExecutionCourse;
    private ExecutionCourse destinationExecutionCourse;
    private ExecutionSemester executionSemester;
    private Boolean chooseNotLinked;

    @Override
    public ExecutionSemester getExecutionPeriod() {
        return this.getExecutionSemester();
    }

    @Override
    public ExecutionDegree getExecutionDegree() {
        return this.executionDegree;
    }

    public void setExecutionDegree(ExecutionDegree input) {
        if (input != null && this.getDegree() != null && this.getDegree() != input.getDegree()) {
            throw new IllegalStateException();
        }
        this.executionDegree = input;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree input) {
        if (input != null && this.getExecutionDegree() != null && this.getExecutionDegree().getDegree() != input) {
            throw new IllegalStateException();
        }
        this.degree = input;
    }

    public CurricularYear getCurricularYear() {
        return this.curricularYear;
    }

    public void setCurricularYear(CurricularYear curricularYear) {
        this.curricularYear = curricularYear;
    }

    public ExecutionSemester getExecutionSemester() {
        return this.executionSemester;
    }

    public void setExecutionSemester(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public ExecutionCourse getSourceExecutionCourse() {
        return this.sourceExecutionCourse;
    }

    public void setSourceExecutionCourse(ExecutionCourse sourceExecutionCourse) {
        this.sourceExecutionCourse = sourceExecutionCourse;
    }

    public ExecutionCourse getDestinationExecutionCourse() {
        return this.destinationExecutionCourse;
    }

    public void setDestinationExecutionCourse(ExecutionCourse destinationExecutionCourse) {
        this.destinationExecutionCourse = destinationExecutionCourse;
    }

    public Boolean getChooseNotLinked() {
        return this.chooseNotLinked;
    }

    public void setChooseNotLinked(Boolean chooseNotLinked) {
        this.chooseNotLinked = chooseNotLinked;
    }

    public ExecutionCourseBean() {
    }

    public ExecutionCourseBean(ExecutionCourse executionCourse) {
        this.setSourceExecutionCourse(executionCourse);
    }

    public Collection<ExecutionCourse> getExecutionCourses() {
        List<Object> result = new ArrayList();
        if (this.chooseNotLinked.booleanValue()) {
            result = this.getExecutionSemester().getExecutionCoursesWithNoCurricularCourses();
        } else {
            for (CurricularCourse curricularCourse : this.getDegreeCurricularPlan().getCurricularCourses(this.getExecutionSemester())) {
                if (!curricularCourse.hasScopeInGivenSemesterAndCurricularYearInDCP(this.getCurricularYear(), this.getDegreeCurricularPlan(), this.getExecutionSemester())) continue;
                result.addAll(curricularCourse.getExecutionCoursesByExecutionPeriod(this.getExecutionSemester()));
            }
        }
        TreeSet<ExecutionCourse> finalResult = new TreeSet<ExecutionCourse>(ExecutionCourse.EXECUTION_COURSE_NAME_COMPARATOR);
        finalResult.addAll(result);
        return finalResult;
    }

    private DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan();
    }

    public String getSourcePresentationName() {
        StringBuilder result = new StringBuilder();
        if (this.getSourceExecutionCourse() != null) {
            result.append(this.getSourceExecutionCourse().getNameI18N().getContent());
            HashSet plans = this.getDegree() != null ? Sets.intersection((Set)this.getDegree().getDegreeCurricularPlansSet(), (Set)Sets.newHashSet(this.getSourceExecutionCourse().getAssociatedDegreeCurricularPlans())) : Sets.newHashSet(this.getSourceExecutionCourse().getAssociatedDegreeCurricularPlans());
            result.append(ExecutionCourseBean.getDegreeCurricularPlansPresentationString(plans));
        }
        return result.toString();
    }

    public String getDestinationPresentationName() {
        StringBuilder result = new StringBuilder();
        if (this.getDestinationExecutionCourse() != null) {
            result.append(this.getDestinationExecutionCourse().getNameI18N().getContent());
            HashSet plans = this.getDegree() != null ? Sets.intersection((Set)this.getDegree().getDegreeCurricularPlansSet(), (Set)Sets.newHashSet(this.getDestinationExecutionCourse().getAssociatedDegreeCurricularPlans())) : Sets.newHashSet(this.getDestinationExecutionCourse().getAssociatedDegreeCurricularPlans());
            result.append(ExecutionCourseBean.getDegreeCurricularPlansPresentationString(plans));
        }
        return result.toString();
    }

    private static String getDegreeCurricularPlansPresentationString(Set<DegreeCurricularPlan> input) {
        StringBuilder result = new StringBuilder(" [ ");
        Iterator<DegreeCurricularPlan> iterator = input.iterator();
        while (iterator.hasNext()) {
            DegreeCurricularPlan iter = iterator.next();
            result.append(iter.getName());
            if (!iterator.hasNext()) continue;
            result.append(" , ");
        }
        result.append(" ]");
        return result.toString();
    }
}

