/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.student;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.student.OptionalCurricularCoursesLocationBean;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class CurriculumGroupsProviderForEnrolmentsLocationManagement
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        OptionalCurricularCoursesLocationBean.EnrolmentLocationBean bean = (OptionalCurricularCoursesLocationBean.EnrolmentLocationBean)source;
        TreeSet<DegreeModule> result = new TreeSet<DegreeModule>(DegreeModule.COMPARATOR_BY_NAME);
        Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, Authenticate.getUser()).collect(Collectors.toSet());
        for (Registration registration : bean.getStudent().getRegistrationsSet()) {
            if (!registration.isBolonha() || !programs.contains(registration.getDegree())) continue;
            StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
            for (CycleCurriculumGroup cycle : studentCurricularPlan.getCycleCurriculumGroups()) {
                if (cycle.getConclusionProcess() != null) continue;
                DegreeCurricularPlan degreeCurricularPlan = cycle.getDegreeCurricularPlanOfDegreeModule();
                List<DegreeModule> modules = degreeCurricularPlan.getDcpDegreeModules(OptionalCurricularCourse.class, ExecutionYear.readCurrentExecutionYear());
                Iterator<DegreeModule> degreeModulesIter = modules.iterator();
                while (degreeModulesIter.hasNext()) {
                    CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModulesIter.next());
                    if (!studentCurricularPlan.isApproved(curricularCourse) && !studentCurricularPlan.getCurricularCoursePossibleGroupsWithoutNoCourseGroupCurriculumGroups(curricularCourse).isEmpty()) continue;
                    degreeModulesIter.remove();
                }
                result.addAll(modules);
            }
        }
        return result;
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

