/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetManagementBaseBean;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class DegreeCurricularPlansForDegree
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        MarkSheetManagementBaseBean markSheetManagementBean = (MarkSheetManagementBaseBean)source;
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        if (markSheetManagementBean.getDegree() != null && markSheetManagementBean.getExecutionPeriod() != null) {
            Set availableDegrees = AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.MANAGE_MARKSHEETS, Authenticate.getUser()).collect(Collectors.toSet());
            for (DegreeCurricularPlan dcp : markSheetManagementBean.getDegree().getDegreeCurricularPlansSet()) {
                if (!availableDegrees.contains(dcp.getDegree()) || !this.hasExecutionDegreeForYear(markSheetManagementBean, dcp) && !this.canSubmitImprovementMarksheets(markSheetManagementBean, dcp)) continue;
                result.add(dcp);
            }
        }
        Collections.sort(result, DegreeCurricularPlan.COMPARATOR_BY_NAME);
        return result;
    }

    private boolean canSubmitImprovementMarksheets(MarkSheetManagementBaseBean markSheetManagementBean, DegreeCurricularPlan degreeCurricularPlan) {
        return degreeCurricularPlan.canSubmitImprovementMarkSheets(markSheetManagementBean.getExecutionPeriod().getExecutionYear());
    }

    private boolean hasExecutionDegreeForYear(MarkSheetManagementBaseBean markSheetManagementBean, DegreeCurricularPlan degreeCurricularPlan) {
        return degreeCurricularPlan.hasAnyExecutionDegreeFor(markSheetManagementBean.getExecutionYear());
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

