/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib.sop.v3.renderers;

import com.google.common.base.Strings;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoLessonInstance;
import org.fenixedu.academic.dto.InfoLessonInstanceAggregation;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlot;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlotContentRendererShift;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.LocalDate;

public class ShiftEnrollmentTimeTableLessonContentRenderer
extends LessonSlotContentRendererShift {
    private String studentID;
    private String application;
    private String action;
    private String classID;
    private String executionCourseID;
    private String executionSemesterID;

    public ShiftEnrollmentTimeTableLessonContentRenderer(String studentID, String application, String classID, String executionCourseID, String executionSemesterID, String action) {
        this.setStudentID(studentID);
        this.setApplication(application);
        this.setClassID(classID);
        this.setExecutionCourseID(executionCourseID);
        this.setExecutionSemesterID(executionSemesterID);
        this.setAction(action);
    }

    @Override
    public StringBuilder render(String context, LessonSlot lessonSlot) {
        StringBuilder strBuffer = super.render(context, lessonSlot);
        InfoShowOccupation showOccupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (showOccupation instanceof InfoLesson) {
            InfoLesson lesson = (InfoLesson)showOccupation;
            InfoExecutionCourse infoExecutionCourse = lesson.getInfoShift().getInfoDisciplinaExecucao();
            String siteUrl = infoExecutionCourse.getExecutionCourse().getSiteUrl();
            strBuffer.append("<span class=\"float-left\">");
            if (Strings.isNullOrEmpty((String)siteUrl)) {
                strBuffer.append(infoExecutionCourse.getSigla());
            } else {
                strBuffer.append("<!-- NO_CHECKSUM -->");
                strBuffer.append("<a href=\"").append(context);
                strBuffer.append(siteUrl);
                strBuffer.append("\">");
                strBuffer.append(infoExecutionCourse.getSigla()).append("</a>");
            }
            strBuffer.append("&nbsp;").append("&nbsp;(").append(lesson.getInfoShift().getShiftTypesCodePrettyPrint()).append(")&nbsp;");
            Space allocatableSpace = lesson.getAllocatableSpace();
            if (allocatableSpace != null) {
                strBuffer.append(allocatableSpace.getName());
            }
            strBuffer.append("</span>");
        } else if (showOccupation instanceof InfoLessonInstance) {
            InfoLessonInstance lesson = (InfoLessonInstance)showOccupation;
            InfoExecutionCourse infoExecutionCourse = lesson.getInfoShift().getInfoDisciplinaExecucao();
            String siteUrl = infoExecutionCourse.getExecutionCourse().getSiteUrl();
            strBuffer.append("<span class=\"float-left\">");
            if (Strings.isNullOrEmpty((String)siteUrl)) {
                strBuffer.append(infoExecutionCourse.getSigla());
            } else {
                strBuffer.append("<!-- NO_CHECKSUM -->");
                strBuffer.append("<a href=\"").append(context);
                strBuffer.append(siteUrl);
                strBuffer.append("\">");
                strBuffer.append(infoExecutionCourse.getSigla()).append("</a>");
            }
            strBuffer.append("&nbsp;").append("&nbsp;(").append(lesson.getShiftTypeCodesPrettyPrint()).append(")&nbsp;");
            if (lesson.getInfoRoomOccupation() != null) {
                strBuffer.append(lesson.getInfoRoomOccupation().getInfoRoom().getNome());
            }
            strBuffer.append("</span>");
        } else if (showOccupation instanceof InfoLessonInstanceAggregation) {
            InfoLessonInstanceAggregation infoLessonInstanceAggregation = (InfoLessonInstanceAggregation)showOccupation;
            ExecutionCourse executionCourse = infoLessonInstanceAggregation.getShift().getExecutionCourse();
            String siteUrl = executionCourse.getSiteUrl();
            strBuffer.append("<span class=\"float-left\">");
            if (Strings.isNullOrEmpty((String)siteUrl)) {
                strBuffer.append(executionCourse.getSigla());
            } else {
                strBuffer.append("<!-- NO_CHECKSUM -->");
                strBuffer.append("<a href=\"").append(context);
                strBuffer.append(siteUrl);
                strBuffer.append("\">");
                strBuffer.append(executionCourse.getSigla()).append("</a>");
            }
            strBuffer.append("&nbsp;").append("&nbsp;(").append(infoLessonInstanceAggregation.getShift().getShiftTypesCodePrettyPrint()).append(")&nbsp;");
            Space allocatableSpace = infoLessonInstanceAggregation.getAllocatableSpace();
            if (allocatableSpace != null) {
                strBuffer.append(allocatableSpace.getName());
            }
            strBuffer.append("</span>");
        }
        return strBuffer;
    }

    @Override
    public String renderSecondLine(String context, LessonSlot lessonSlot) {
        InfoLessonInstanceAggregation infoLessonInstanceAggregation;
        StringBuilder builder = new StringBuilder();
        InfoShowOccupation showOccupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (showOccupation instanceof InfoLessonInstanceAggregation && !(infoLessonInstanceAggregation = (InfoLessonInstanceAggregation)showOccupation).availableInAllWeeks()) {
            builder.append("<span>");
            builder.append(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.weeks", (String[])new String[0]));
            builder.append(": &nbsp;&nbsp;");
            builder.append(infoLessonInstanceAggregation.prettyPrintWeeks());
            builder.append("&nbsp;");
            builder.append("</span>");
        }
        builder.append(super.renderSecondLine(context, lessonSlot));
        return builder.toString();
    }

    @Override
    public String renderTitleText(LessonSlot lessonSlot) {
        StringBuilder builder = new StringBuilder(super.renderTitleText(lessonSlot));
        InfoShowOccupation occupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (occupation instanceof InfoLessonInstanceAggregation) {
            InfoLessonInstanceAggregation aggregation = (InfoLessonInstanceAggregation)occupation;
            for (LocalDate localDate : aggregation.getDates()) {
                builder.append('\n');
                builder.append(localDate.toString("yyyy-MM-dd"));
            }
        }
        return builder.toString();
    }

    @Override
    public StringBuilder lastRender(LessonSlot lessonSlot, String context) {
        StringBuilder strBuffer = new StringBuilder();
        InfoShowOccupation showOccupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (showOccupation instanceof InfoLesson) {
            InfoLesson lesson = (InfoLesson)showOccupation;
            strBuffer.append((CharSequence)this.getURL(lesson.getInfoShift().getShift(), context));
            strBuffer.append("<img src=\"").append(context).append("/images/").append(this.getImage()).append("\"/>").append("</a>");
        } else if (showOccupation instanceof InfoLessonInstanceAggregation) {
            InfoLessonInstanceAggregation infoLessonInstanceAggregation = (InfoLessonInstanceAggregation)showOccupation;
            strBuffer.append((CharSequence)this.getURL(infoLessonInstanceAggregation.getShift(), context));
            strBuffer.append("<img src=\"").append(context).append("/images/").append(this.getImage()).append("\"/>").append("</a>");
        }
        return strBuffer;
    }

    private Object getImage() {
        StringBuilder strBuffer = new StringBuilder();
        if (this.getAction().equalsIgnoreCase("add")) {
            strBuffer.append("add1.gif\" title=\"Adicionar\"");
        } else if (this.getAction().equalsIgnoreCase("remove")) {
            strBuffer.append("remove1.gif\" title=\"Remover\"");
        } else if (this.getAction().equalsIgnoreCase("removeram")) {
            strBuffer.append("remove1.gif\" title=\"Remover\"");
        } else if (this.getAction().equalsIgnoreCase("addram")) {
            strBuffer.append("add1.gif\" title=\"Adicionar\"");
        }
        return strBuffer;
    }

    private StringBuilder getURL(Shift shift, String context) {
        StringBuilder strBuffer = new StringBuilder();
        if (this.getAction().equalsIgnoreCase("add")) {
            strBuffer.append("<a href=\"" + context + "/student/enrollStudentInShifts.do?registrationOID=");
        } else if (this.getAction().equalsIgnoreCase("remove")) {
            strBuffer.append("<a href=\"" + context + "/student/studentShiftEnrollmentManager.do?method=unEnroleStudentFromShift&registrationOID=");
        } else if (this.getAction().equalsIgnoreCase("addram")) {
            strBuffer.append("<a href=\"" + context + "/resourceAllocationManager/enrollStudentInShifts.do?registrationOID=");
        } else if (this.getAction().equalsIgnoreCase("removeram")) {
            strBuffer.append("<a href=\"" + context + "/resourceAllocationManager/studentShiftEnrollmentManager.do?method=unEnroleStudentFromShift&registrationOID=");
        }
        strBuffer.append(this.getStudentID()).append("&shiftId=").append(shift.getExternalId());
        strBuffer.append("&classId=").append(this.getClassID()).append("&executionCourseID=").append(this.getExecutionCourseID()).append("&executionSemesterID=").append(this.getExecutionSemesterID()).append("\">");
        return strBuffer;
    }

    public String getStudentID() {
        return this.studentID;
    }

    public void setStudentID(String studentID) {
        this.studentID = studentID;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getClassID() {
        return this.classID;
    }

    public void setClassID(String classID) {
        this.classID = classID;
    }

    public String getExecutionCourseID() {
        return this.executionCourseID;
    }

    public void setExecutionCourseID(String executionCourseID) {
        this.executionCourseID = executionCourseID;
    }

    public String getExecutionSemesterID() {
        return this.executionSemesterID;
    }

    public void setExecutionSemesterID(String executionSemesterID) {
        this.executionSemesterID = executionSemesterID;
    }
}

