/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.phd.thesis;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class PhdThesisJuryElementsDocument
extends FenixReport {
    private static final long serialVersionUID = 1L;
    private final PhdThesisProcess process;

    public PhdThesisJuryElementsDocument(PhdThesisProcess process2) {
        this.process = process2;
        this.fillReport();
    }

    @Override
    protected void fillReport() {
        this.addJuryElementsInformation();
        AdministrativeOffice adminOffice = this.process.getIndividualProgramProcess().getPhdProgram().getAdministrativeOffice();
        this.addParameter("presidentTitle", this.process.getPresidentTitle().getContent(this.getLanguage()));
        this.addParameter("administrativeOfficeCoordinator", adminOffice.getCoordinator().getProfile().getDisplayName());
        this.addParameter("administrativeOfficeName", adminOffice.getName().getContent());
        this.addParameter("ratificationEntityMessage", this.process.getPhdJuryElementsRatificationEntity().getRatificationEntityMessage(this.process, this.getLocale()));
    }

    private void addJuryElementsInformation() {
        ArrayList<ThesisJuryElementInfo> elements = new ArrayList<ThesisJuryElementInfo>();
        for (ThesisJuryElement element : this.process.getOrderedThesisJuryElements()) {
            elements.add(new ThesisJuryElementInfo(element));
        }
        this.addDataSourceElements(elements);
    }

    @Override
    public String getReportFileName() {
        return "JuryElements-" + new DateTime().toString("yyyyMMddHHmmss");
    }

    public static class ThesisJuryElementInfo {
        private final String description;

        public ThesisJuryElementInfo(ThesisJuryElement element) {
            this.description = this.buildDescription(element);
        }

        private String buildDescription(ThesisJuryElement element) {
            StringBuilder builder = new StringBuilder();
            builder.append(!StringUtils.isEmpty((String)element.getTitle()) ? element.getTitle() : "").append(" ");
            builder.append(element.getName()).append(", ");
            builder.append(element.getCategory());
            if (!StringUtils.isEmpty((String)element.getWorkLocation())) {
                builder.append(" ").append(BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.thesis.jury.elements.document.keyword.of", (String[])new String[0])).append(" ").append(element.getWorkLocation());
            }
            if (!StringUtils.isEmpty((String)element.getInstitution())) {
                builder.append(" ").append(BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.thesis.jury.elements.document.keyword.of", (String[])new String[0])).append(" ").append(element.getInstitution());
            }
            if (element.getExpert().booleanValue()) {
                builder.append(" ").append(BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.thesis.jury.elements.document.expert", (String[])new String[0]));
            }
            builder.append(";");
            if (element.isAssistantGuiding()) {
                builder.append(" (").append(BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.thesis.jury.elements.document.assistantGuiding", (String[])new String[0])).append(")");
            } else if (element.isMainGuiding()) {
                builder.append(" (").append(BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.thesis.jury.elements.document.guiding", (String[])new String[0])).append(")");
            } else if (element.getReporter().booleanValue()) {
                builder.append(" - ").append(BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.thesis.jury.elements.document.reporter", (String[])new String[0]));
            }
            return builder.toString();
        }

        public String getDescription() {
            return this.description;
        }
    }
}

