/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.registrationStates;

import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.ConcludedState_Base;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.util.workflow.IState;
import org.fenixedu.academic.domain.util.workflow.StateBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.UserLoginPeriod;
import org.joda.time.DateTime;

public class ConcludedState
extends ConcludedState_Base {
    protected ConcludedState(Registration registration, Person person, DateTime dateTime) {
        if (registration.isBolonha() && !registration.hasConcluded()) {
            throw new DomainException("error.registration.is.not.concluded", new String[0]);
        }
        this.init(registration, person, dateTime);
        UserLoginPeriod.createOpenPeriod((User)registration.getPerson().getUser());
    }

    public void delete() {
        this.checkRulesToDelete();
        super.delete();
    }

    private void checkRulesToDelete() {
        Person person = AccessControl.getPerson();
        if (AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.REPEAT_CONCLUSION_PROCESS, (AcademicProgram)((Object)this.getRegistration().getDegree()), person.getUser())) {
            return;
        }
        if (!this.getRegistration().getSucessfullyFinishedDocumentRequests(DocumentRequestType.DEGREE_FINALIZATION_CERTIFICATE).isEmpty()) {
            throw new DomainException("cannot.delete.concluded.state.of.registration.with.concluded.degree.finalization.request", new String[0]);
        }
        if (!this.getRegistration().getSucessfullyFinishedDocumentRequests(DocumentRequestType.DIPLOMA_REQUEST).isEmpty()) {
            throw new DomainException("cannot.delete.concluded.state.of.registration.with.concluded.diploma.request", new String[0]);
        }
    }

    public void checkConditionsToForward(StateBean bean) {
        throw new DomainException("error.impossible.to.forward.from.concluded", new String[0]);
    }

    public IState nextState(StateBean bean) {
        throw new DomainException("error.impossible.to.forward.from.concluded", new String[0]);
    }

    public RegistrationStateType getStateType() {
        return RegistrationStateType.CONCLUDED;
    }
}

