/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.util.Collections;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.reports.RegistrationReportFile_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class RegistrationReportFile
extends RegistrationReportFile_Base {
    public String getJobName() {
        return "Listagem de matr\u00ed\u00adculas";
    }

    protected String getPrefix() {
        return "matriculas";
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        spreadsheet.setHeader("n\u00famero aluno");
        this.setDegreeHeaders(spreadsheet);
        spreadsheet.setHeader("c\u00f3digo regime de ingresso na matr\u00edcula");
        spreadsheet.setHeader("regime de ingresso na matr\u00edcula");
        spreadsheet.setHeader("ano l\u00e9ctivo de in\u00edcio da matr\u00edcula");
        spreadsheet.setHeader("c\u00f3digo regime de ingresso na escola");
        spreadsheet.setHeader("regime de ingresso na escola");
        spreadsheet.setHeader("ano l\u00e9ctivo de ingresso na escola");
        spreadsheet.setHeader("tipo de aluno");
        spreadsheet.setHeader("ano curricular");
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!RegistrationReportFile.checkDegreeType((DegreeType)this.getDegreeType(), (Degree)degree) || !this.isActive(degree)) continue;
            for (Registration registration : degree.getRegistrationsSet()) {
                if (!registration.isRegistered(this.getExecutionYear())) continue;
                Spreadsheet.Row row = spreadsheet.addRow();
                row.setCell(registration.getNumber());
                this.setDegreeCells(row, degree);
                this.reportIngression(row, registration);
                Registration firstRegistration = this.findFirstRegistration(registration.getStudent());
                this.reportIngression(row, firstRegistration);
                if (registration.getRegistrationProtocol() != null) {
                    row.setCell(registration.getRegistrationProtocol().getCode());
                } else {
                    row.setCell("");
                }
                row.setCell(Integer.toString(registration.getCurricularYear(this.getExecutionYear())));
            }
        }
    }

    private Registration findFirstRegistration(Student student) {
        return Collections.min(student.getRegistrationsSet(), Registration.COMPARATOR_BY_START_DATE);
    }

    private void reportIngression(Spreadsheet.Row row, Registration registration) {
        IngressionType ingressionType = registration.getIngressionType();
        if (ingressionType != null) {
            row.setCell(ingressionType.getCode());
            row.setCell(ingressionType.getDescription().getContent());
        } else {
            row.setCell("");
            row.setCell("");
        }
        row.setCell(registration.getStartExecutionYear().getYear());
    }
}

