/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.over23;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.FormationBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcess;
import org.joda.time.LocalDate;

public class Over23IndividualCandidacyProcessBean
extends IndividualCandidacyProcessBean {
    private Degree degreeToAdd;
    private List<Degree> selectedDegrees;
    private String disabilities;
    private String education;
    private String languages;
    private String languagesRead;
    private String languagesWrite;
    private String languagesSpeak;
    private List<CandidacyProcessDocumentUploadBean> habilitationCertificateList;
    private List<CandidacyProcessDocumentUploadBean> reportOrWorkDocumentList;
    private CandidacyProcessDocumentUploadBean handicapProofDocument;
    private CandidacyProcessDocumentUploadBean curriculumVitaeDocument;

    public Over23IndividualCandidacyProcessBean() {
        this.setCandidacyDate(new LocalDate());
        this.setSelectedDegrees(Collections.EMPTY_LIST);
        this.setFormationConcludedBeanList(new ArrayList<FormationBean>());
        this.setFormationNonConcludedBeanList(new ArrayList<FormationBean>());
        this.initializeDocumentUploadBeans();
        this.honorAgreement = false;
    }

    public Over23IndividualCandidacyProcessBean(Over23IndividualCandidacyProcess process2) {
        this.setIndividualCandidacyProcess((IndividualCandidacyProcess)((Object)process2));
        this.setCandidacyDate(process2.getCandidacyDate());
        this.setSelectedDegrees(Collections.EMPTY_LIST);
        this.addDegrees(process2.getSelectedDegreesSortedByOrder());
        this.setDisabilities(process2.getDisabilities());
        this.setEducation(process2.getEducation());
        this.setLanguages(process2.getLanguages());
        this.initializeFormation(process2.getCandidacy().getFormationsSet());
        this.setLanguagesRead(process2.getLanguagesRead());
        this.setLanguagesWrite(process2.getLanguagesWrite());
        this.setLanguagesSpeak(process2.getLanguagesSpeak());
        this.setProcessChecked(process2.getProcessChecked());
        this.setPaymentChecked(process2.getPaymentChecked());
    }

    public Over23CandidacyProcess getCandidacyProcess() {
        return (Over23CandidacyProcess)((Object)super.getCandidacyProcess());
    }

    public Degree getDegreeToAdd() {
        return this.degreeToAdd;
    }

    public void setDegreeToAdd(Degree degreeToAdd) {
        this.degreeToAdd = degreeToAdd;
    }

    public boolean hasDegreeToAdd() {
        return this.getDegreeToAdd() != null;
    }

    public void removeDegreeToAdd() {
        this.degreeToAdd = null;
    }

    public List<Degree> getSelectedDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>();
        for (Degree degree : this.selectedDegrees) {
            result.add(degree);
        }
        return result;
    }

    public void setSelectedDegrees(List<Degree> degrees) {
        this.selectedDegrees = new ArrayList<Degree>();
        for (Degree degree : degrees) {
            this.selectedDegrees.add(degree);
        }
    }

    public void addDegree(Degree degree) {
        this.selectedDegrees.add(degree);
    }

    public void addDegrees(Collection<Degree> degrees) {
        for (Degree degree : degrees) {
            this.addDegree(degree);
        }
    }

    public void removeDegree(Degree degree) {
        Iterator<Degree> iter = this.selectedDegrees.iterator();
        while (iter.hasNext()) {
            if (iter.next() != degree) continue;
            iter.remove();
            break;
        }
    }

    public boolean containsDegree(Degree value) {
        for (Degree degree : this.getSelectedDegrees()) {
            if (degree != value) continue;
            return true;
        }
        return false;
    }

    public void removeSelectedDegrees() {
        this.selectedDegrees.clear();
    }

    public String getDisabilities() {
        return this.disabilities;
    }

    public void setDisabilities(String disabilities) {
        this.disabilities = disabilities;
    }

    public String getEducation() {
        return this.education;
    }

    public void setEducation(String education) {
        this.education = education;
    }

    public String getLanguages() {
        return this.languages;
    }

    public void setLanguages(String languages) {
        this.languages = languages;
    }

    public List<CandidacyProcessDocumentUploadBean> getHabilitationCertificateList() {
        return this.habilitationCertificateList;
    }

    public void setHabilitationCertificateList(List<CandidacyProcessDocumentUploadBean> habilitationCertificateList) {
        this.habilitationCertificateList = habilitationCertificateList;
    }

    public List<CandidacyProcessDocumentUploadBean> getReportOrWorkDocumentList() {
        return this.reportOrWorkDocumentList;
    }

    public void setReportOrWorkDocumentList(List<CandidacyProcessDocumentUploadBean> reportOrWorkDocumentList) {
        this.reportOrWorkDocumentList = reportOrWorkDocumentList;
    }

    public CandidacyProcessDocumentUploadBean getHandicapProofDocument() {
        return this.handicapProofDocument;
    }

    public void setHandicapProofDocument(CandidacyProcessDocumentUploadBean handicapProofDocument) {
        this.handicapProofDocument = handicapProofDocument;
    }

    public CandidacyProcessDocumentUploadBean getCurriculumVitaeDocument() {
        return this.curriculumVitaeDocument;
    }

    public void setCurriculumVitaeDocument(CandidacyProcessDocumentUploadBean curriculumVitaeDocument) {
        this.curriculumVitaeDocument = curriculumVitaeDocument;
    }

    public String getLanguagesRead() {
        return this.languagesRead;
    }

    public void setLanguagesRead(String value) {
        this.languagesRead = value;
    }

    public String getLanguagesWrite() {
        return this.languagesWrite;
    }

    public void setLanguagesWrite(String value) {
        this.languagesWrite = value;
    }

    public String getLanguagesSpeak() {
        return this.languagesSpeak;
    }

    public void setLanguagesSpeak(String value) {
        this.languagesSpeak = value;
    }

    public void addHabilitationCertificateDocument() {
        this.habilitationCertificateList.add(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT));
    }

    public void removeHabilitationCertificateDocument(int index) {
        this.habilitationCertificateList.remove(index);
    }

    public void addReportOrWorkDocument() {
        this.reportOrWorkDocumentList.add(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.REPORT_OR_WORK_DOCUMENT));
    }

    public void removeReportOrWorkDocument(int index) {
        this.reportOrWorkDocumentList.remove(index);
    }

    @Override
    protected void initializeDocumentUploadBeans() {
        this.setDocumentIdentificationDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION));
        this.setPaymentDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT));
        this.setVatCatCopyDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.VAT_CARD_DOCUMENT));
        this.habilitationCertificateList = new ArrayList<CandidacyProcessDocumentUploadBean>();
        this.addHabilitationCertificateDocument();
        this.reportOrWorkDocumentList = new ArrayList<CandidacyProcessDocumentUploadBean>();
        this.addReportOrWorkDocument();
        this.handicapProofDocument = new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.HANDICAP_PROOF_DOCUMENT);
        this.curriculumVitaeDocument = new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.CV_DOCUMENT);
        this.setPhotoDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.PHOTO));
    }

    @Override
    public boolean isOver23() {
        return true;
    }
}

