/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report.events;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.events.AnnualEvent;
import org.fenixedu.academic.domain.accounting.events.EnrolmentOutOfPeriodEvent;
import org.fenixedu.academic.domain.accounting.events.dfa.DfaRegistrationEvent;
import org.fenixedu.academic.domain.accounting.events.specializationDegree.SpecializationDegreeRegistrationEvent;
import org.fenixedu.academic.domain.accounting.report.events.Wrapper;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.student.EnrolmentModel;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.MultiLanguageString;

public class EventWrapper
implements Wrapper {
    private final Event event;

    public EventWrapper(Event event) {
        this.event = event;
    }

    @Override
    public String getStudentNumber() {
        if (this.event.getParty().isPerson() && this.event.getPerson().getStudent() != null) {
            return this.event.getPerson().getStudent().getNumber().toString();
        }
        return "--";
    }

    @Override
    public String getStudentName() {
        return this.event.getParty().getName();
    }

    @Override
    public String getStudentEmail() {
        return this.event.getParty().getDefaultEmailAddressValue();
    }

    @Override
    public String getRegistrationStartDate() {
        return "--";
    }

    @Override
    public String getExecutionYear() {
        ExecutionYear executionYear = this.getForExecutionYear();
        return executionYear.getName();
    }

    @Override
    public ExecutionYear getForExecutionYear() {
        ExecutionYear executionYear = null;
        executionYear = this.event.isDfaRegistrationEvent() ? ((DfaRegistrationEvent)((Object)this.event)).getExecutionYear() : (this.event.isEnrolmentOutOfPeriod() ? ((EnrolmentOutOfPeriodEvent)((Object)this.event)).getExecutionPeriod().getExecutionYear() : (this.event.isAnnual() ? ((AnnualEvent)((Object)this.event)).getExecutionYear() : ExecutionYear.readByDateTime(this.event.getWhenOccured())));
        return executionYear;
    }

    @Override
    public String getDegreeName() {
        if (this.hasRegistration()) {
            return this.getRegistration().getDegree().getNameI18N().getContent(MultiLanguageString.pt);
        }
        return "--";
    }

    @Override
    public String getDegreeType() {
        if (this.hasRegistration()) {
            return this.getRegistration().getDegreeType().getName().getContent();
        }
        return "--";
    }

    @Override
    public String getPhdProgramName() {
        return "--";
    }

    @Override
    public String getEnrolledECTS() {
        if (this.hasRegistration()) {
            return new BigDecimal(this.getRegistration().getLastStudentCurricularPlan().getEnrolmentsEctsCredits(this.getForExecutionYear())).toString();
        }
        return "--";
    }

    @Override
    public String getRegime() {
        if (this.hasRegistration()) {
            return this.getRegistration().getRegimeType(this.getForExecutionYear()).getLocalizedName();
        }
        return "--";
    }

    @Override
    public String getEnrolmentModel() {
        if (!this.hasRegistration()) {
            return "--";
        }
        EnrolmentModel enrolmentModelForExecutionYear = this.getRegistration().getEnrolmentModelForExecutionYear(this.getForExecutionYear());
        if (enrolmentModelForExecutionYear != null) {
            return enrolmentModelForExecutionYear.getLocalizedName();
        }
        return "--";
    }

    @Override
    public String getResidenceYear() {
        return "--";
    }

    @Override
    public String getResidenceMonth() {
        return "--";
    }

    @Override
    public String getStudiesType() {
        if (this.hasRegistration()) {
            return "Curso";
        }
        return "--";
    }

    private Registration getRegistration() {
        if (this.event.isDfaRegistrationEvent()) {
            return ((DfaRegistrationEvent)((Object)this.event)).getRegistration();
        }
        if (this.event.isEnrolmentOutOfPeriod()) {
            return ((EnrolmentOutOfPeriodEvent)((Object)this.event)).getStudentCurricularPlan().getRegistration();
        }
        if (this.event.isSpecializationDegreeRegistrationEvent()) {
            return ((SpecializationDegreeRegistrationEvent)((Object)this.event)).getRegistration();
        }
        return null;
    }

    private boolean hasRegistration() {
        return this.getRegistration() != null;
    }

    @Override
    public String getTotalDiscount() {
        return this.event.getTotalDiscount().toPlainString();
    }

    @Override
    public boolean isAfterOrEqualExecutionYear(ExecutionYear executionYear) {
        return !this.getForExecutionYear().isBefore(executionYear);
    }

    @Override
    public AdministrativeOffice getRelatedAcademicOffice() {
        Registration registration = this.getRegistration();
        if (registration == null) {
            return null;
        }
        return registration.getDegree().getAdministrativeOffice();
    }

    @Override
    public String getRelatedEventExternalId() {
        return "--";
    }

    @Override
    public String getDebtorFiscalId() {
        return "--";
    }

    @Override
    public String getDebtorName() {
        return "--";
    }
}

