/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.gratuity;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemption;
import org.fenixedu.academic.domain.accounting.events.gratuity.PercentageGratuityExemption;
import org.fenixedu.academic.domain.accounting.events.gratuity.ValueGratuityExemption;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.IGratuityPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class StandaloneEnrolmentGratuityPR
extends StandaloneEnrolmentGratuityPR_Base {
    protected StandaloneEnrolmentGratuityPR() {
    }

    public StandaloneEnrolmentGratuityPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, BigDecimal ectsForYear, BigDecimal gratuityFactor, BigDecimal ectsFactor) {
        this();
        this.init(startDate, endDate, serviceAgreementTemplate, ectsForYear, gratuityFactor, ectsFactor);
    }

    private void init(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, BigDecimal ectsForYear, BigDecimal gratuityFactor, BigDecimal ectsFactor) {
        this.checkParameters(ectsForYear, gratuityFactor, ectsFactor);
        this.checkGratuityPR(serviceAgreementTemplate);
        super.init(EntryType.STANDALONE_ENROLMENT_GRATUITY_FEE, EventType.STANDALONE_ENROLMENT_GRATUITY, startDate, endDate, serviceAgreementTemplate);
        super.setEctsForYear(ectsForYear);
        super.setGratuityFactor(gratuityFactor);
        super.setEctsFactor(ectsFactor);
    }

    private void checkParameters(BigDecimal ectsForYear, BigDecimal gratuityFactor, BigDecimal ectsFactor) {
        String[] args = new String[]{};
        if (ectsForYear == null) {
            throw new DomainException("error.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR.ectsForYear.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (gratuityFactor == null) {
            throw new DomainException("error.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR.gratuity.cannot.be.null", args1);
        }
        String[] args2 = new String[]{};
        if (ectsFactor == null) {
            throw new DomainException("error.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR.ectsFactor.cannot.be.null", args2);
        }
    }

    private void checkGratuityPR(ServiceAgreementTemplate serviceAgreementTemplate) {
        if (!serviceAgreementTemplate.hasActivePostingRuleFor(EventType.GRATUITY)) {
            throw new DomainException("error.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR.must.have.gratuityPR", new String[0]);
        }
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, this.calculateTotalAmountToPay(event, when), event.getPayedAmount(), event.calculateAmountToPay(when), event.getDescriptionForEntryType(this.getEntryType()), event.calculateAmountToPay(when)));
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        GratuityEvent gratuityEvent = (GratuityEvent)((Object)event);
        Money result = Money.ZERO;
        for (Map.Entry<DegreeCurricularPlan, BigDecimal> entry : this.groupEctsByDegreeCurricularPlan(gratuityEvent).entrySet()) {
            result = result.add(this.calculateAmountForDegreeCurricularPlan(entry.getKey(), entry.getValue(), gratuityEvent));
        }
        return result;
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        GratuityEvent gratuityEvent = (GratuityEvent)((Object)event);
        if (!gratuityEvent.hasGratuityExemption()) {
            return amountToPay;
        }
        GratuityExemption gratuityExemption = gratuityEvent.getGratuityExemption();
        if (gratuityExemption.isValueExemption()) {
            amountToPay = amountToPay.subtract(((ValueGratuityExemption)((Object)gratuityExemption)).getValue());
        } else {
            PercentageGratuityExemption percentageGratuityExemption = (PercentageGratuityExemption)((Object)gratuityExemption);
            BigDecimal percentage = percentageGratuityExemption.getPercentage();
            Money toRemove = amountToPay.multiply(percentage);
            amountToPay = amountToPay.subtract(toRemove);
        }
        return amountToPay.isNegative() ? Money.ZERO : amountToPay;
    }

    private Money calculateAmountForDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan, BigDecimal enroledEcts, GratuityEvent gratuityEvent) {
        IGratuityPR gratuityPR = (IGratuityPR)((Object)degreeCurricularPlan.getServiceAgreementTemplate().findPostingRuleBy(EventType.GRATUITY, gratuityEvent.getStartDate(), gratuityEvent.getEndDate()));
        Money degreeGratuityAmount = gratuityPR.getDefaultGratuityAmount(gratuityEvent.getExecutionYear());
        BigDecimal creditsProporcion = enroledEcts.divide(this.getEctsForYear());
        if (this.hasAnyActiveDegreeRegistration(gratuityEvent)) {
            return degreeGratuityAmount.multiply(creditsProporcion);
        }
        if (gratuityEvent.getDegree().isEmpty() || gratuityEvent.getDegree().isDEA()) {
            return degreeGratuityAmount.multiply(this.getGratuityFactor()).multiply(this.getEctsFactor().add(creditsProporcion));
        }
        return degreeGratuityAmount.multiply(creditsProporcion);
    }

    private boolean hasAnyActiveDegreeRegistration(GratuityEvent gratuityEvent) {
        Student student = gratuityEvent.getStudentCurricularPlan().getRegistration().getStudent();
        for (Registration registration : student.getRegistrationsSet()) {
            if (registration.getDegree().isEmpty() || !registration.isDegreeAdministrativeOffice() || !registration.hasAnyEnrolmentsIn(gratuityEvent.getExecutionYear())) continue;
            return true;
        }
        return false;
    }

    private Map<DegreeCurricularPlan, BigDecimal> groupEctsByDegreeCurricularPlan(GratuityEvent gratuityEvent) {
        HashMap<DegreeCurricularPlan, BigDecimal> result = new HashMap<DegreeCurricularPlan, BigDecimal>();
        for (Enrolment enrolment : this.getEnrolmentsToCalculateGratuity(gratuityEvent)) {
            this.addEctsToDegree(result, enrolment.getDegreeCurricularPlanOfDegreeModule(), enrolment.getEctsCreditsForCurriculum());
        }
        return result;
    }

    private Set<Enrolment> getEnrolmentsToCalculateGratuity(GratuityEvent gratuityEvent) {
        if (!gratuityEvent.getDegree().isEmpty()) {
            if (!gratuityEvent.getStudentCurricularPlan().hasStandaloneCurriculumGroup()) {
                return Collections.emptySet();
            }
            return gratuityEvent.getStudentCurricularPlan().getStandaloneCurriculumGroup().getEnrolmentsBy(gratuityEvent.getExecutionYear());
        }
        return gratuityEvent.getStudentCurricularPlan().getRoot().getEnrolmentsBy(gratuityEvent.getExecutionYear());
    }

    private void addEctsToDegree(Map<DegreeCurricularPlan, BigDecimal> result, DegreeCurricularPlan degree, BigDecimal ects) {
        if (result.containsKey((Object)degree)) {
            result.put(degree, result.get((Object)degree).add(ects));
        } else {
            result.put(degree, ects);
        }
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR.invalid.number.of.entryDTOs", new String[0]);
        }
        this.checkIfCanAddAmount(entryDTOs.iterator().next().getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, this.getEntryType(), entryDTOs.iterator().next().getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToPay, Event event, DateTime whenRegistered) {
        Money totalFinalAmount = event.getPayedAmount().add(amountToPay);
        if (totalFinalAmount.lessThan(this.calculateTotalAmountToPay(event, whenRegistered))) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR.amount.being.payed.must.be.equal.to.amount.in.debt", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    public String getFormulaDescription() {
        return MessageFormat.format(super.getFormulaDescription(), this.getGratuityFactor().toPlainString(), this.getEctsFactor().toPlainString(), this.getEctsForYear().toPlainString());
    }

    public StandaloneEnrolmentGratuityPR edit(BigDecimal ectsForYear, BigDecimal gratuityFactor, BigDecimal ectsFactor) {
        this.deactivate();
        return new StandaloneEnrolmentGratuityPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), ectsForYear, gratuityFactor, ectsFactor);
    }

    public void setEctsForYear(BigDecimal ectsForYear) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR.cannot.modify.ectsForYear", new String[0]);
    }

    public void setGratuityFactor(BigDecimal gratuityFactor) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR.cannot.modify.gratuityFactor", new String[0]);
    }

    public void setEctsFactor(BigDecimal ectsFactor) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR.cannot.modify.ectsFactor", new String[0]);
    }
}

