/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.PastAdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.postingRules.PastAdministrativeOfficeFeeAndInsurancePR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class PastAdministrativeOfficeFeeAndInsurancePR
extends PastAdministrativeOfficeFeeAndInsurancePR_Base {
    protected PastAdministrativeOfficeFeeAndInsurancePR() {
    }

    public PastAdministrativeOfficeFeeAndInsurancePR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate) {
        this();
        this.init(EntryType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE, EventType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE, startDate, endDate, serviceAgreementTemplate);
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        Money totalAmountToPay = this.calculateTotalAmountToPay(event, when);
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, totalAmountToPay, event.getPayedAmount(), event.calculateAmountToPay(when), event.getDescriptionForEntryType(this.getEntryType()), event.calculateAmountToPay(when)));
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        PastAdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent = (PastAdministrativeOfficeFeeAndInsuranceEvent)((Object)event);
        return administrativeOfficeFeeAndInsuranceEvent.getPastAdministrativeOfficeFeeAndInsuranceAmount();
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        PastAdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent = (PastAdministrativeOfficeFeeAndInsuranceEvent)((Object)event);
        if (applyDiscount && administrativeOfficeFeeAndInsuranceEvent.hasAdministrativeOfficeFeeAndInsuranceExemption()) {
            return Money.ZERO;
        }
        return amountToPay;
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.FixedAmountPR.invalid.number.of.entryDTOs", new String[0]);
        }
        EntryDTO entryDTO = entryDTOs.iterator().next();
        this.checkIfCanAddAmount(entryDTO.getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, entryDTO.getEntryType(), entryDTO.getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToPay, Event event, DateTime when) {
        if (amountToPay.lessThan(event.calculateAmountToPay(when))) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.PastAdministrativeOfficeFeeAndInsurancePR.amount.being.payed.must.match.amount.to.pay", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    public boolean isVisible() {
        return false;
    }
}

