/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeState;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan_Base;
import org.fenixedu.academic.domain.accounting.events.gratuity.exemption.penalty.InstallmentPenaltyExemption;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.accounting.paymentCodes.InstallmentPaymentCode;
import org.fenixedu.academic.domain.accounting.paymentPlans.CustomGratuityPaymentPlan;
import org.fenixedu.academic.domain.accounting.paymentPlans.GratuityPaymentPlan;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.GratuityWithPaymentPlanPR;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.serviceAgreements.DegreeCurricularPlanServiceAgreement;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.EntryWithInstallmentDTO;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class GratuityEventWithPaymentPlan
extends GratuityEventWithPaymentPlan_Base {
    protected GratuityEventWithPaymentPlan() {
    }

    public GratuityEventWithPaymentPlan(AdministrativeOffice administrativeOffice, Person person, StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        this();
        this.init(administrativeOffice, person, studentCurricularPlan, executionYear);
    }

    protected void init(AdministrativeOffice administrativeOffice, Person person, StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        super.init(administrativeOffice, person, studentCurricularPlan, executionYear);
        this.configuratePaymentPlan();
    }

    public void setGratuityPaymentPlan(PaymentPlan gratuityPaymentPlan) {
        throw new DomainException("error.GratuityEventWithPaymentPlan.do.not.use.this.method", new String[0]);
    }

    public void changeGratuityPaymentPlan(PaymentPlan paymentPlan) {
        if (paymentPlan instanceof GratuityPaymentPlan) {
            this.setGratuityPaymentPlan((GratuityPaymentPlan)((Object)paymentPlan));
        } else if (paymentPlan instanceof CustomGratuityPaymentPlan) {
            this.setGratuityPaymentPlan((CustomGratuityPaymentPlan)((Object)paymentPlan));
        } else {
            throw new DomainException("error.GratuityEventWithPaymentPlan.unexpected.payment.plan.type", new String[0]);
        }
    }

    public void setGratuityPaymentPlan(GratuityPaymentPlan paymentPlan) {
        if (paymentPlan != null) {
            this.ensureServiceAgreement();
            super.setGratuityPaymentPlan((PaymentPlan)((Object)paymentPlan));
        }
    }

    public void setGratuityPaymentPlan(CustomGratuityPaymentPlan paymentPlan) {
        if (paymentPlan != null) {
            this.ensureServiceAgreement();
            super.setGratuityPaymentPlan((PaymentPlan)((Object)paymentPlan));
        }
    }

    public void configuratePaymentPlan() {
        this.ensureServiceAgreement();
        if (this.getGratuityPaymentPlan() == null) {
            super.setGratuityPaymentPlan((PaymentPlan)((Object)this.getDegreeCurricularPlanServiceAgreement().getGratuityPaymentPlanFor(this.getStudentCurricularPlan(), this.getExecutionYear())));
        }
    }

    private void ensureServiceAgreement() {
        if (this.getDegreeCurricularPlanServiceAgreement() == null) {
            new DegreeCurricularPlanServiceAgreement(this.getPerson(), DegreeCurricularPlanServiceAgreementTemplate.readByDegreeCurricularPlan(this.getStudentCurricularPlan().getDegreeCurricularPlan()));
        }
    }

    public void configurateCustomPaymentPlan() {
        if (!this.hasCustomGratuityPaymentPlan()) {
            this.ensureServiceAgreement();
            super.setGratuityPaymentPlan((PaymentPlan)((Object)new CustomGratuityPaymentPlan(this.getExecutionYear(), this.getDegreeCurricularPlanServiceAgreement())));
        }
    }

    public void configurateDefaultPaymentPlan() {
        if (!this.hasDefaultGratuityPaymentPlan()) {
            this.ensureServiceAgreement();
            GratuityPaymentPlan paymentPlan = this.getDegreeCurricularPlanServiceAgreement().getDefaultGratuityPaymentPlan(this.getExecutionYear());
            if (paymentPlan == null) {
                throw new DomainException("error.GratuityEventWithPaymentPlan.cannot.set.null.payment.plan", new String[0]);
            }
            super.setGratuityPaymentPlan((PaymentPlan)((Object)paymentPlan));
        }
    }

    protected List<AccountingEventPaymentCode> createPaymentCodes() {
        return this.createMissingPaymentCodes();
    }

    private List<AccountingEventPaymentCode> createMissingPaymentCodes() {
        ArrayList<AccountingEventPaymentCode> result = new ArrayList<AccountingEventPaymentCode>();
        for (EntryDTO entryDTO : this.calculateEntries()) {
            if (this.hasAnyNonProcessedPaymentCodeFor(entryDTO)) continue;
            if (entryDTO instanceof EntryWithInstallmentDTO) {
                result.add((AccountingEventPaymentCode)((Object)this.createInstallmentPaymentCode((EntryWithInstallmentDTO)entryDTO, this.getPerson().getStudent())));
                continue;
            }
            result.add(this.createAccountingEventPaymentCode(entryDTO, this.getPerson().getStudent()));
        }
        return result;
    }

    private boolean hasAnyNonProcessedPaymentCodeFor(EntryDTO entryDTO) {
        for (AccountingEventPaymentCode paymentCode : this.getNonProcessedPaymentCodes()) {
            InstallmentPaymentCode installmentPaymentCode;
            if (!(paymentCode instanceof InstallmentPaymentCode ? entryDTO instanceof EntryWithInstallmentDTO && (installmentPaymentCode = (InstallmentPaymentCode)((Object)paymentCode)).getInstallment() == ((EntryWithInstallmentDTO)entryDTO).getInstallment() : !(entryDTO instanceof EntryWithInstallmentDTO))) continue;
            return true;
        }
        return false;
    }

    protected List<AccountingEventPaymentCode> updatePaymentCodes() {
        this.createMissingPaymentCodes();
        List entryDTOs = this.calculateEntries();
        ArrayList<AccountingEventPaymentCode> result = new ArrayList<AccountingEventPaymentCode>();
        for (AccountingEventPaymentCode paymentCode : this.getNonProcessedPaymentCodes()) {
            EntryDTO entryDTO = this.findEntryDTOForPaymentCode(entryDTOs, paymentCode);
            if (entryDTO == null) {
                paymentCode.cancel();
                continue;
            }
            if (paymentCode instanceof InstallmentPaymentCode) {
                InstallmentPaymentCode installmentPaymentCode = (InstallmentPaymentCode)((Object)paymentCode);
                paymentCode.update(new YearMonthDay(), this.calculateInstallmentPaymentCodeEndDate(installmentPaymentCode.getInstallment()), entryDTO.getAmountToPay(), entryDTO.getAmountToPay());
                result.add(paymentCode);
                continue;
            }
            paymentCode.update(new YearMonthDay(), this.calculateFullPaymentCodeEndDate(), entryDTO.getAmountToPay(), entryDTO.getAmountToPay());
            result.add(paymentCode);
        }
        return result;
    }

    private YearMonthDay calculateInstallmentPaymentCodeEndDate(Installment installment) {
        YearMonthDay today = new YearMonthDay();
        YearMonthDay installmentEndDate = new YearMonthDay((Object)installment.getEndDate((Event)((Object)this)));
        return today.isBefore((ReadablePartial)installmentEndDate) ? installmentEndDate : this.calculateNextEndDate(today);
    }

    private YearMonthDay calculateFullPaymentCodeEndDate() {
        YearMonthDay today = new YearMonthDay();
        LocalDate endDate = this.getFirstInstallment().getEndDate((Event)((Object)this));
        YearMonthDay totalEndDate = new YearMonthDay(this.getFirstInstallment().getEndDate((Event)((Object)this)).getYear(), this.getFirstInstallment().getEndDate((Event)((Object)this)).getMonthOfYear(), this.getFirstInstallment().getEndDate((Event)((Object)this)).getDayOfMonth());
        return today.isBefore((ReadablePartial)totalEndDate) ? totalEndDate : this.calculateNextEndDate(today);
    }

    private EntryDTO findEntryDTOForPaymentCode(List<EntryDTO> entryDTOs, AccountingEventPaymentCode paymentCode) {
        if (paymentCode instanceof InstallmentPaymentCode) {
            for (EntryDTO entryDTO : entryDTOs) {
                if (!(entryDTO instanceof EntryWithInstallmentDTO) || ((InstallmentPaymentCode)((Object)paymentCode)).getInstallment() != ((EntryWithInstallmentDTO)entryDTO).getInstallment()) continue;
                return entryDTO;
            }
        } else {
            for (EntryDTO entryDTO : entryDTOs) {
                if (entryDTO instanceof EntryWithInstallmentDTO) continue;
                return entryDTO;
            }
        }
        return null;
    }

    public void changeGratuityTotalPaymentCodeState(PaymentCodeState paymentCodeState) {
        for (AccountingEventPaymentCode accountingEventPaymentCode : this.getNonProcessedPaymentCodes()) {
            if (accountingEventPaymentCode instanceof InstallmentPaymentCode) continue;
            accountingEventPaymentCode.setState(paymentCodeState);
        }
    }

    public void changeInstallmentPaymentCodeState(Installment installment, PaymentCodeState paymentCodeState) {
        for (AccountingEventPaymentCode paymentCode : this.getNonProcessedPaymentCodes()) {
            if (!(paymentCode instanceof InstallmentPaymentCode) || ((InstallmentPaymentCode)((Object)paymentCode)).getInstallment() != installment) continue;
            paymentCode.setState(paymentCodeState);
        }
        this.changeGratuityTotalPaymentCodeState(PaymentCodeState.CANCELLED);
    }

    private AccountingEventPaymentCode createAccountingEventPaymentCode(EntryDTO entryDTO, Student student) {
        AccountingEventPaymentCode accountingEventPaymentCode = this.findEquivalentPaymentCodeInStudentCandidacy(entryDTO, AccountingEventPaymentCode.class, student);
        if (accountingEventPaymentCode != null) {
            accountingEventPaymentCode.setAccountingEvent((Event)((Object)this));
            return accountingEventPaymentCode;
        }
        return AccountingEventPaymentCode.create(PaymentCodeType.GRATUITY_FIRST_INSTALLMENT, new YearMonthDay(), this.calculateFullPaymentCodeEndDate(), (Event)((Object)this), entryDTO.getAmountToPay(), entryDTO.getAmountToPay(), student.getPerson());
    }

    private InstallmentPaymentCode createInstallmentPaymentCode(EntryWithInstallmentDTO entry, Student student) {
        AccountingEventPaymentCode accountingEventPaymentCode = this.findEquivalentPaymentCodeInStudentCandidacy(entry, InstallmentPaymentCode.class, student);
        if (accountingEventPaymentCode != null) {
            accountingEventPaymentCode.setAccountingEvent((Event)((Object)this));
            return (InstallmentPaymentCode)((Object)accountingEventPaymentCode);
        }
        return InstallmentPaymentCode.create(PaymentCodeType.GRATUITY_FIRST_INSTALLMENT, new YearMonthDay(), this.calculateInstallmentPaymentCodeEndDate(entry.getInstallment()), (Event)((Object)this), entry.getInstallment(), entry.getAmountToPay(), entry.getAmountToPay(), student);
    }

    private AccountingEventPaymentCode findEquivalentPaymentCodeInStudentCandidacy(EntryDTO entry, Class<? extends AccountingEventPaymentCode> whatForClazz, Student student) {
        DegreeCurricularPlan degreeCurricularPlan = this.getStudentCurricularPlan().getDegreeCurricularPlan();
        ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByAcademicInterval(this.getExecutionYear().getAcademicInterval());
        StudentCandidacy studentCandidacy = student.getPerson().getStudentCandidacyForExecutionDegree(executionDegree);
        if (studentCandidacy == null) {
            return null;
        }
        for (PaymentCode paymentCode : studentCandidacy.getAvailablePaymentCodesSet()) {
            AccountingEventPaymentCode accountingEventPaymentCode;
            if (!paymentCode.isNew() || !PaymentCodeType.GRATUITY_FIRST_INSTALLMENT.equals((Object)paymentCode.getType()) || !whatForClazz.equals(((Object)((Object)paymentCode)).getClass()) || (accountingEventPaymentCode = (AccountingEventPaymentCode)((Object)paymentCode)).getAccountingEvent() != null) continue;
            if (!(accountingEventPaymentCode instanceof InstallmentPaymentCode)) {
                return accountingEventPaymentCode;
            }
            InstallmentPaymentCode installmentPaymentCode = (InstallmentPaymentCode)((Object)accountingEventPaymentCode);
            EntryWithInstallmentDTO installmentEntryDTO = (EntryWithInstallmentDTO)entry;
            if (installmentPaymentCode.getInstallment() != installmentEntryDTO.getInstallment()) continue;
            return installmentPaymentCode;
        }
        return null;
    }

    private Installment getFirstInstallment() {
        return this.getGratuityPaymentPlan().getFirstInstallment();
    }

    private Installment getLastInstallment() {
        return this.getGratuityPaymentPlan().getLastInstallment();
    }

    public DegreeCurricularPlanServiceAgreement getDegreeCurricularPlanServiceAgreement() {
        return (DegreeCurricularPlanServiceAgreement)((Object)this.getPerson().getServiceAgreementFor((ServiceAgreementTemplate)((Object)this.getServiceAgreementTemplate())));
    }

    public boolean hasInstallments() {
        return true;
    }

    public InstallmentPaymentCode getInstallmentPaymentCodeFor(Installment installment) {
        for (AccountingEventPaymentCode paymentCode : this.calculatePaymentCodes()) {
            if (!(paymentCode instanceof InstallmentPaymentCode) || ((InstallmentPaymentCode)((Object)paymentCode)).getInstallment() != installment) continue;
            return (InstallmentPaymentCode)((Object)paymentCode);
        }
        return null;
    }

    public AccountingEventPaymentCode getTotalPaymentCode() {
        for (AccountingEventPaymentCode paymentCode : this.calculatePaymentCodes()) {
            if (paymentCode instanceof InstallmentPaymentCode) continue;
            return paymentCode;
        }
        return null;
    }

    protected Set<Entry> internalProcess(User responsibleUser, AccountingEventPaymentCode paymentCode, Money amountToPay, SibsTransactionDetailDTO transactionDetail) {
        return this.internalProcess(responsibleUser, Collections.singletonList(this.buildEntryDTOFrom(paymentCode, amountToPay)), transactionDetail);
    }

    private EntryDTO buildEntryDTOFrom(AccountingEventPaymentCode paymentCode, Money amountToPay) {
        if (paymentCode instanceof InstallmentPaymentCode) {
            return new EntryWithInstallmentDTO(EntryType.GRATUITY_FEE, (Event)((Object)this), amountToPay, ((InstallmentPaymentCode)((Object)paymentCode)).getInstallment());
        }
        return new EntryDTO(EntryType.GRATUITY_FEE, (Event)((Object)this), amountToPay);
    }

    private boolean installmentIsInDebtToday(Installment installment) {
        return this.installmentIsInDebt(installment) && new YearMonthDay().isAfter((ReadablePartial)installment.getEndDate());
    }

    private boolean installmentIsInDebt(Installment installment) {
        return this.getGratuityPaymentPlan().isInstallmentInDebt(installment, (Event)((Object)this), new DateTime(), this.calculateDiscountPercentage(this.getGratuityPaymentPlan().calculateOriginalTotalAmount()));
    }

    private boolean hasAnyInstallmentInDebtToday() {
        for (Installment installment : this.getInstallments()) {
            if (!this.installmentIsInDebtToday(installment)) continue;
            return true;
        }
        return false;
    }

    public boolean isInDebt() {
        return this.isOpen() && this.hasAnyInstallmentInDebtToday();
    }

    public InstallmentPenaltyExemption getInstallmentPenaltyExemptionFor(Installment installment) {
        for (Exemption exemption : this.getExemptionsSet()) {
            InstallmentPenaltyExemption installmentPenaltyExemption;
            if (!(exemption instanceof InstallmentPenaltyExemption) || (installmentPenaltyExemption = (InstallmentPenaltyExemption)((Object)exemption)).getInstallment() != installment) continue;
            return installmentPenaltyExemption;
        }
        return null;
    }

    public boolean hasPenaltyExemptionFor(Installment installment) {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!(exemption instanceof InstallmentPenaltyExemption) || ((InstallmentPenaltyExemption)((Object)exemption)).getInstallment() != installment) continue;
            return true;
        }
        return false;
    }

    public List<Installment> getInstallments() {
        return this.getGratuityPaymentPlan().getInstallmentsSortedByEndDate();
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    public List<InstallmentPenaltyExemption> getInstallmentPenaltyExemptions() {
        ArrayList<InstallmentPenaltyExemption> result = new ArrayList<InstallmentPenaltyExemption>();
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!(exemption instanceof InstallmentPenaltyExemption)) continue;
            result.add((InstallmentPenaltyExemption)((Object)exemption));
        }
        return result;
    }

    public boolean isOtherPartiesPaymentsSupported() {
        return true;
    }

    protected void disconnect() {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        if (this.hasCustomGratuityPaymentPlan()) {
            ((CustomGratuityPaymentPlan)((Object)super.getGratuityPaymentPlan())).delete();
        }
        super.setGratuityPaymentPlan(null);
        super.disconnect();
    }

    public boolean isGratuityEventWithPaymentPlan() {
        return true;
    }

    public boolean hasCustomGratuityPaymentPlan() {
        return this.getGratuityPaymentPlan() != null && this.getGratuityPaymentPlan().isCustomGratuityPaymentPlan();
    }

    public boolean hasDefaultGratuityPaymentPlan() {
        return this.getGratuityPaymentPlan() != null && this.getGratuityPaymentPlan().isDefault();
    }

    public Money getPayedAmountLessPenalty() {
        if (this.isCancelled()) {
            throw new DomainException("error.accounting.Event.cannot.calculatePayedAmount.on.invalid.events", new String[0]);
        }
        DateTime now = new DateTime();
        Money result = Money.ZERO;
        for (Installment installment : this.getGratuityPaymentPlan().getInstallmentsSet()) {
            if (this.getGratuityPaymentPlan().isInstallmentInDebt(installment, (Event)((Object)this), now, BigDecimal.ZERO)) continue;
            result = result.add(installment.getAmount());
        }
        if (result.isPositive()) {
            result = result.subtract(this.getTotalDiscount());
        }
        return result.isPositive() ? result.add(this.getPayedAmountLessInstallments()) : this.getPayedAmountLessInstallments();
    }

    private Money getPayedAmountLessInstallments() {
        Money payedAmount = Money.ZERO;
        for (AccountingTransaction transaction : this.getNonAdjustingTransactions()) {
            if (transaction.isInstallment()) continue;
            payedAmount = payedAmount.add(transaction.getToAccountEntry().getAmountWithAdjustment());
        }
        return payedAmount;
    }

    public GratuityWithPaymentPlanPR getPostingRule() {
        return (GratuityWithPaymentPlanPR)((Object)super.getPostingRule());
    }

    public Set<EntryType> getPossibleEntryTypesForDeposit() {
        return Collections.singleton(EntryType.GRATUITY_FEE);
    }

    public boolean isPaymentPlanChangeAllowed() {
        return true;
    }
}

