/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.QueueJob$callable$cancel;
import org.fenixedu.academic.domain.QueueJob$callable$resend;
import org.fenixedu.academic.domain.QueueJobResult;
import org.fenixedu.academic.domain.QueueJob_Base;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class QueueJob
extends QueueJob_Base {
    public static final Comparator<QueueJob> COMPARATORY_BY_REQUEST_DATE;
    public static final Advice advice$cancel;
    public static final Advice advice$resend;

    public QueueJob() {
        this.setRequestDate(new DateTime());
        this.setFailedCounter(new Integer(0));
        this.setRootDomainObject(Bennu.getInstance());
        this.setRootDomainObjectQueueUndone(Bennu.getInstance());
        this.setDone(Boolean.FALSE);
        this.setPerson(AccessControl.getPerson());
    }

    public abstract QueueJobResult execute() throws Exception;

    public String getDescription() {
        return "Tarefa";
    }

    public String getFilename() {
        return "ficheiro";
    }

    public boolean getIsNotDoneAndCancelled() {
        return this.getDone() == false && this.getRootDomainObjectQueueUndone() == null;
    }

    public boolean getIsNotDoneAndNotCancelled() {
        return this.getDone() == false && this.getRootDomainObjectQueueUndone() != null;
    }

    public static List<QueueJob> getLastJobsForClassOrSubClass(Class<? extends QueueJob> type, int maxSize) {
        return QueueJob.getAllJobsForClassOrSubClass(type, maxSize, COMPARATORY_BY_REQUEST_DATE);
    }

    public static List<QueueJob> getAllJobsForClassOrSubClass(Class<? extends QueueJob> type, int maxSize, Comparator<QueueJob> comparator) {
        ArrayList jobs = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Bennu.getInstance().getQueueJobSet(), type));
        Collections.sort(jobs, comparator);
        return jobs.size() > maxSize ? jobs.subList(0, maxSize) : jobs;
    }

    public static List<QueueJob> getUndoneJobsForClass(Class<? extends QueueJob> type) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Bennu.getInstance().getQueueJobUndoneSet(), type));
    }

    public Priority getPriority() {
        return Priority.NORMAL;
    }

    public void cancel() {
        Object object = advice$cancel.perform((Callable)new QueueJob$callable$cancel(this));
    }

    static /* synthetic */ void advised$cancel(QueueJob this_) {
        this_.setRootDomainObjectQueueUndone(null);
    }

    public void resend() {
        Object object = advice$resend.perform((Callable)new QueueJob$callable$resend(this));
    }

    static /* synthetic */ void advised$resend(QueueJob this_) {
        this_.setRootDomainObjectQueueUndone(Bennu.getInstance());
    }

    static {
        advice$cancel = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$resend = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATORY_BY_REQUEST_DATE = new Comparator<QueueJob>(){

            @Override
            public int compare(QueueJob o1, QueueJob o2) {
                return o2.getRequestDate().compareTo((ReadableInstant)o1.getRequestDate());
            }
        };
    }

    public static enum Priority {
        HIGH,
        NORMAL;

    }
}

