/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.administrativeOfficeServices;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOfficeType;
import org.fenixedu.academic.domain.phd.debts.ExternalScholarshipPhdGratuityContribuitionPR;
import org.fenixedu.academic.ui.struts.action.base.FenixAction;
import org.fenixedu.academic.ui.struts.action.student.administrativeOfficeServices.StudentAcademicOfficeServices;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=StudentAcademicOfficeServices.class, path="prices", titleKey="label.prices")
@Mapping(module="student", path="/prices")
@Forwards(value={@Forward(name="viewPrices", path="/student/administrativeOfficeServices/prices/viewPrices.jsp")})
public class StudentPricesAction
extends FenixAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("postingRulesByAdminOfficeType", this.getPostingRulesByAdminOfficeType());
        request.setAttribute("insurancePostingRule", (Object)this.getInsurancePR());
        return mapping.findForward("viewPrices");
    }

    private PostingRule getInsurancePR() {
        return Bennu.getInstance().getInstitutionUnit().getUnitServiceAgreementTemplate().findPostingRuleByEventType(EventType.INSURANCE);
    }

    private Map<AdministrativeOfficeType, List<PostingRule>> getPostingRulesByAdminOfficeType() {
        HashMap<AdministrativeOfficeType, List<PostingRule>> postingRulesByAdminOfficeType = new HashMap<AdministrativeOfficeType, List<PostingRule>>();
        for (AdministrativeOfficeType officeType : AdministrativeOfficeType.values()) {
            AdministrativeOffice office = AdministrativeOffice.readByAdministrativeOfficeType(officeType);
            if (office == null) continue;
            ArrayList<PostingRule> postingRules = new ArrayList<PostingRule>();
            for (PostingRule postingRule : office.getServiceAgreementTemplate().getActiveVisiblePostingRules()) {
                if (ExternalScholarshipPhdGratuityContribuitionPR.class.isAssignableFrom(((Object)((Object)postingRule)).getClass())) continue;
                postingRules.add(postingRule);
            }
            Collections.sort(postingRules, PostingRule.COMPARATOR_BY_EVENT_TYPE);
            postingRulesByAdminOfficeType.put(officeType, postingRules);
        }
        return postingRulesByAdminOfficeType;
    }
}

