/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.scientificCouncil.thesis;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.service.services.person.SearchPerson;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisPresentationState;
import org.fenixedu.academic.util.CollectionPager;

public class ManageSecondCycleThesisSearchBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
    private ThesisPresentationState presentationState = ThesisPresentationState.CONFIRMED;
    private String searchString;
    private transient ThesisPresentationStateCountMap thesisPresentationStateCountMap;

    public ManageSecondCycleThesisSearchBean() {
        this(null);
    }

    public ManageSecondCycleThesisSearchBean(ExecutionYear executionYear) {
        if (executionYear == null) {
            this.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
        } else {
            this.setExecutionYear(executionYear);
        }
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public ThesisPresentationState getPresentationState() {
        return this.presentationState;
    }

    public void setPresentationState(ThesisPresentationState presentationState) {
        this.presentationState = presentationState;
    }

    public ThesisPresentationStateCountMap getThesisPresentationStateCountMap() {
        return this.thesisPresentationStateCountMap;
    }

    public SortedSet<Person> findPersonBySearchString() {
        TreeSet<Person> result = new TreeSet<Person>(Person.COMPARATOR_BY_NAME_AND_ID);
        if (this.searchString != null && !this.searchString.isEmpty()) {
            result.addAll(this.searchName(this.searchString));
            result.addAll(this.searchUsername(this.searchString));
            result.addAll(this.searchStudentNumber(this.searchString));
        }
        return result;
    }

    private Collection<Person> searchName(String name) {
        SearchPerson.SearchParameters searchParameters = new SearchPerson.SearchParameters();
        searchParameters.setName(name);
        return this.search(searchParameters);
    }

    private Collection<Person> searchUsername(String username) {
        SearchPerson.SearchParameters searchParameters = new SearchPerson.SearchParameters();
        searchParameters.setUsername(username);
        return this.search(searchParameters);
    }

    private Collection<Person> searchStudentNumber(String number) {
        if (StringUtils.isNumeric((String)number)) {
            SearchPerson.SearchParameters searchParameters = new SearchPerson.SearchParameters();
            searchParameters.setStudentNumber(new Integer(number));
            return this.search(searchParameters);
        }
        return Collections.emptySet();
    }

    private Collection<Person> search(SearchPerson.SearchParameters searchParameters) {
        SearchPerson.SearchPersonPredicate searchPersonPredicate = new SearchPerson.SearchPersonPredicate(searchParameters);
        SearchPerson searchPerson = new SearchPerson();
        CollectionPager<Person> people = searchPerson.run(searchParameters, searchPersonPredicate);
        return people.getCollection();
    }

    public SortedSet<Enrolment> findEnrolments() {
        this.thesisPresentationStateCountMap = new ThesisPresentationStateCountMap();
        final TreeSet<Enrolment> result = new TreeSet<Enrolment>(Enrolment.COMPARATOR_BY_STUDENT_NUMBER);
        final HashSet curricularCourses = new HashSet();
        for (ExecutionDegree executionDegree : this.executionYear.getExecutionDegreesSet()) {
            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            degreeCurricularPlan.applyToCurricularCourses(this.executionYear, new Predicate(){

                public boolean evaluate(Object arg0) {
                    CurricularCourse curricularCourse = (CurricularCourse)((Object)arg0);
                    if (curricularCourse.isDissertation() && !curricularCourses.contains((Object)curricularCourse)) {
                        curricularCourses.add(curricularCourse);
                        for (CurriculumModule curriculumModule : curricularCourse.getCurriculumModulesSet()) {
                            Enrolment enrolment;
                            if (!curriculumModule.isEnrolment() || (enrolment = (Enrolment)((Object)curriculumModule)).getExecutionYear() != ManageSecondCycleThesisSearchBean.this.executionYear) continue;
                            ThesisPresentationState state = ThesisPresentationState.getThesisPresentationState(enrolment);
                            if (ManageSecondCycleThesisSearchBean.this.presentationState == null || state == ManageSecondCycleThesisSearchBean.this.presentationState) {
                                result.add(enrolment);
                            }
                            ManageSecondCycleThesisSearchBean.this.thesisPresentationStateCountMap.count(state);
                        }
                    }
                    return false;
                }
            });
        }
        return result;
    }

    public static class ThesisPresentationStateCountMap
    extends TreeMap<ThesisPresentationState, Counter> {
        private void count(ThesisPresentationState thesisPresentationState) {
            if (this.containsKey((Object)thesisPresentationState)) {
                ((Counter)this.get((Object)thesisPresentationState)).count++;
            } else {
                this.put(thesisPresentationState, new Counter());
            }
        }
    }

    public static class Counter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int count = 1;

        public int getCount() {
            return this.count;
        }
    }
}

