/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.residenceManagement;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.ResidenceManagementUnit;
import org.fenixedu.academic.domain.residence.ResidenceMonth;
import org.fenixedu.academic.dto.VariantBean;
import org.fenixedu.academic.dto.residenceManagement.ImportResidenceEventBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.accounting.CancelResidenceEvent;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.residenceManagement.CreateResidencePaymentCodes;
import org.fenixedu.academic.service.services.residenceManagement.PayResidenceEvent;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.residenceManagement.ResidenceManagerApplication;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.YearMonthDay;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ResidenceManagerApplication.class, path="event-management", titleKey="title.event.management")
@Mapping(path="/residenceEventManagement", module="residenceManagement")
@Forwards(value={@Forward(name="manageResidenceEvents", path="/residenceManagement/eventsManagement.jsp"), @Forward(name="viewPersonResidenceEvents", path="/residenceManagement/viewPersonResidenceEvents.jsp"), @Forward(name="insertPayingDate", path="/residenceManagement/insertPayingDate.jsp")})
public class ResidenceEventManagementDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward manageResidenceEvents(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ImportResidenceEventBean importResidenceEventBean = (ImportResidenceEventBean)this.getRenderedObject("searchEventMonth");
        if (importResidenceEventBean == null) {
            ResidenceMonth month = this.getResidenceMonth(request);
            importResidenceEventBean = month != null ? new ImportResidenceEventBean(month) : new ImportResidenceEventBean();
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("currentResidence", (Object)this.getManagementUnit(request));
        request.setAttribute("searchBean", (Object)importResidenceEventBean);
        return mapping.findForward("manageResidenceEvents");
    }

    private ResidenceManagementUnit getManagementUnit(HttpServletRequest request) {
        return Bennu.getInstance().getResidenceManagementUnit();
    }

    public ActionForward generatePaymentCodes(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResidenceMonth month = this.getResidenceMonth(request);
        CreateResidencePaymentCodes.run(month.getEventsSet());
        return this.manageResidenceEvents(mapping, actionForm, request, response);
    }

    private ResidenceMonth getResidenceMonth(HttpServletRequest request) {
        String oid = request.getParameter("monthOID");
        return oid == null ? null : (ResidenceMonth)FenixFramework.getDomainObject((String)oid);
    }

    public ActionForward viewPersonResidenceEvents(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ResidenceMonth month = this.getResidenceMonth(request);
        String personOID = request.getParameter("person");
        Person person = (Person)FenixFramework.getDomainObject((String)personOID);
        Set<Event> events = person.getNotPayedEventsPayableOn(null, ResidenceEvent.class, false);
        events.addAll(person.getNotPayedEventsPayableOn(null, ResidenceEvent.class, true));
        events.addAll(person.getPayedEvents(ResidenceEvent.class));
        request.setAttribute("month", (Object)month);
        request.setAttribute("person", (Object)person);
        request.setAttribute("residenceEvents", events);
        return mapping.findForward("viewPersonResidenceEvents");
    }

    public ActionForward cancelResidenceEvent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ResidenceEvent residenceEvent = (ResidenceEvent)FenixFramework.getDomainObject((String)request.getParameter("event"));
        try {
            CancelResidenceEvent.run(residenceEvent, AccessControl.getPerson());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getMessage(), new Object[0]);
        }
        return this.viewPersonResidenceEvents(mapping, actionForm, request, response);
    }

    public ActionForward preparePayResidenceEvent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ResidenceEvent residenceEvent = (ResidenceEvent)FenixFramework.getDomainObject((String)request.getParameter("event"));
        VariantBean bean = new VariantBean();
        bean.setYearMonthDay(new YearMonthDay());
        ResidenceMonth month = this.getResidenceMonth(request);
        request.setAttribute("month", (Object)month);
        request.setAttribute("residenceEvent", (Object)residenceEvent);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("insertPayingDate");
    }

    public ActionForward payResidenceEvent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ResidenceEvent residenceEvent = (ResidenceEvent)FenixFramework.getDomainObject((String)request.getParameter("event"));
        YearMonthDay date = (YearMonthDay)this.getRenderedObject("date");
        try {
            PayResidenceEvent.run(this.getLoggedPerson(request).getUser(), residenceEvent, date);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getMessage(), new Object[0]);
        }
        return this.viewPersonResidenceEvents(mapping, actionForm, request, response);
    }
}

