/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publico.candidacies;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCodeOperations;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessWithPrecedentDegreeInformationBean;
import org.fenixedu.academic.domain.candidacyProcess.degreeChange.DegreeChangeIndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.exceptions.HashCodeForEmailAndProcessAlreadyBounded;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.service.services.caseHandling.CreateNewProcess;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.candidacy.IndividualCandidacyProcessDA;
import org.fenixedu.academic.ui.struts.action.publico.KaptchaAction;
import org.fenixedu.academic.util.Pair;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RefactoredIndividualCandidacyProcessPublicDA
extends IndividualCandidacyProcessDA {
    private static final Logger logger = LoggerFactory.getLogger(RefactoredIndividualCandidacyProcessPublicDA.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("application.name", (Object)this.getStringFromDefaultBundle(this.getCandidacyNameKey()));
        request.setAttribute("mappingPath", (Object)mapping.getPath());
        request.setAttribute("isApplicationSubmissionPeriodValid", (Object)this.isApplicationSubmissionPeriodValid());
        request.setAttribute("application.information.link.default", (Object)this.getCandidacyInformationLinkDefaultLanguage());
        request.setAttribute("application.information.link.english", (Object)this.getCandidacyInformationLinkEnglish());
        this.setProcess(request);
        return super.execute(mapping, actionForm, request, response);
    }

    protected String getStringFromDefaultBundle(String key) {
        return BundleUtil.getString((String)"resources.CandidateResources", (String)key, (String[])new String[0]);
    }

    @Override
    protected void prepareInformationForBindPersonToCandidacyOperation(HttpServletRequest request, IndividualCandidacyProcess process2) {
    }

    protected ActionForward verifySubmissionPreconditions(ActionMapping mapping) {
        if (this.getCurrentOpenParentProcess() == null) {
            return mapping.findForward("open-candidacy-process-closed");
        }
        return null;
    }

    protected ActionForward verifyEditPreconditions(ActionMapping mapping) {
        if (this.getCurrentOpenParentProcess() == null) {
            return mapping.findForward("open-candidacy-process-closed");
        }
        return null;
    }

    public ActionForward beginCandidacyProcessIntro(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (this.isInEnglishLocale()) {
            return mapping.findForward("begin-candidacy-process-intro-en");
        }
        return mapping.findForward("begin-candidacy-process-intro");
    }

    @EntryPoint
    public ActionForward preparePreCreationOfCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute("candidacyPreCreationBean", (Object)new CandidacyPreCreationBean());
        return mapping.findForward("show-pre-creation-candidacy-form");
    }

    public ActionForward preparePreCreationOfCandidacyInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        return this.preparePreCreationOfCandidacy(mapping, form, request, response);
    }

    protected CandidacyProcess getCurrentOpenParentProcess() {
        HashSet degreeChangeCandidacyProcesses = Sets.newHashSet((Iterable)Iterables.filter((Iterable)Bennu.getInstance().getProcessesSet(), this.getParentProcessType()));
        for (Process candidacyProcess : degreeChangeCandidacyProcesses) {
            if (!(candidacyProcess instanceof CandidacyProcess) || !((CandidacyProcess)((Object)candidacyProcess)).hasOpenCandidacyPeriod()) continue;
            return (CandidacyProcess)((Object)candidacyProcess);
        }
        return null;
    }

    public ActionForward bindEmailWithHashCodeAndSendMailWithLink(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getObjectFromViewState("PublicAccessCandidacy.preCreationForm") == null) {
            return this.preparePreCreationOfCandidacy(mapping, form, request, response);
        }
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        if (!this.validateCaptcha(mapping, request)) {
            this.invalidateDocumentFileRelatedViewStates();
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("show-pre-creation-candidacy-form");
        }
        try {
            String email = (String)this.getObjectFromViewState("PublicAccessCandidacy.preCreationForm");
            DegreeOfficePublicCandidacyHashCode hash = DegreeOfficePublicCandidacyHashCodeOperations.getUnusedOrCreateNewHashCodeAndSendEmailForApplicationSubmissionToCandidate(this.getProcessType(), this.getCurrentOpenParentProcess(), email);
            String link = String.format(BundleUtil.getString((String)"resources.CandidateResources", (String)(this.getProcessType().getSimpleName() + ".const.public.application.submission.link"), (String[])new String[0]), hash.getValue(), I18N.getLocale().getLanguage());
            request.setAttribute("link", (Object)link);
            return mapping.findForward("show-email-message-sent");
        }
        catch (HashCodeForEmailAndProcessAlreadyBounded e) {
            this.addActionMessage(request, "error.candidacy.hash.code.already.bounded");
            return mapping.findForward("show-pre-creation-candidacy-form");
        }
    }

    public ActionForward showApplicationSubmissionConditions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        String hash = request.getParameter("hash");
        DegreeOfficePublicCandidacyHashCode candidacyHashCode = (DegreeOfficePublicCandidacyHashCode)((Object)DegreeOfficePublicCandidacyHashCode.getPublicCandidacyCodeByHash((String)hash));
        if (candidacyHashCode == null) {
            return mapping.findForward("open-candidacy-processes-not-found");
        }
        if (candidacyHashCode.getIndividualCandidacyProcess() != null) {
            request.setAttribute("individualCandidacyProcess", (Object)candidacyHashCode.getIndividualCandidacyProcess());
            return this.viewCandidacy(mapping, form, request, response);
        }
        request.setAttribute("hash", (Object)hash);
        return mapping.findForward("show-application-submission-conditions");
    }

    protected abstract String getCandidacyNameKey();

    protected abstract String getCandidacyInformationLinkDefaultLanguage();

    protected abstract String getCandidacyInformationLinkEnglish();

    public abstract ActionForward viewCandidacy(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4);

    protected boolean validateCaptcha(ActionMapping mapping, HttpServletRequest request) {
        String captchaResponse = request.getParameter("j_captcha_response");
        if (!KaptchaAction.validateResponse(request.getSession(), captchaResponse)) {
            this.addActionMessage("captcha.error", request, "captcha.wrong.word");
            return false;
        }
        return true;
    }

    private boolean isInEnglishLocale() {
        Locale locale = I18N.getLocale();
        return locale.getLanguage().equals(Locale.ENGLISH.getLanguage());
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionForward continueCandidacyCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Person person;
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        PersonBean personBean = bean.getPersonBean();
        if (this.existsIndividualCandidacyProcessForDocumentId(request, personBean.getIdDocumentType(), personBean.getDocumentIdNumber())) {
            this.addActionMessage("individualCandidacyMessages", request, "error.candidacy.for.person.already.exists");
            return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
        }
        HashSet<Person> persons = new HashSet<Person>(Person.readByDocumentIdNumber(personBean.getDocumentIdNumber()));
        if (persons.size() > 1) {
            this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.person.already.exist");
            return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
        }
        Person person2 = person = persons.size() == 1 ? (Person)((Object)persons.iterator().next()) : null;
        if (person != null) {
            if (!this.isPersonStudentAndNumberIsCorrect(person, bean.getPersonNumber())) {
                this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.userId");
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
            if (!person.getDateOfBirthYearMonthDay().equals((Object)personBean.getDateOfBirth())) {
                this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.birth");
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
            if (!(StringUtils.isEmpty((String)personBean.getSocialSecurityNumber()) || StringUtils.isEmpty((String)person.getSocialSecurityNumber()) || person.getSocialSecurityNumber().equals(personBean.getSocialSecurityNumber()))) {
                this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.contributorNumber");
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
            personBean.setPerson(person);
        } else {
            if (Person.readByContributorNumber((String)personBean.getSocialSecurityNumber()) != null) {
                this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.contributorNumber");
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
            if (!StringUtils.isEmpty((String)bean.getPersonNumber())) {
                this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.userId.missing");
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
            this.fillExternalPrecedentInformation(mapping, form, request, response);
        }
        IndividualCandidacyDocumentFile photoDocumentFile = this.createIndividualCandidacyDocumentFile(bean.getPhotoDocument(), bean.getPersonBean().getDocumentIdNumber());
        bean.getPhotoDocument().setDocumentFile(photoDocumentFile);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("candidacy-continue-creation");
    }

    public ActionForward continueCandidacyCreationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        this.invalidateDocumentFileRelatedViewStates();
        return mapping.findForward("candidacy-continue-creation");
    }

    protected boolean isPersonStudentAndNumberIsCorrect(Person person, String personNumber) {
        return person.getStudent() != null && person.getStudent().getNumber().toString().equals(personNumber) || person.getStudent() == null && StringUtils.isEmpty((String)personNumber);
    }

    public ActionForward executeCreateCandidacyPersonalInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        this.invalidateDocumentFileRelatedViewStates();
        return mapping.findForward("show-candidacy-creation-page");
    }

    protected boolean candidacyIndividualProcessExistsForThisEmail(String email) {
        return this.candidacyIndividualProcessExistsForThisEmail(email, new ArrayList<Degree>());
    }

    protected boolean candidacyIndividualProcessExistsForThisEmail(String email, List<Degree> degreeList) {
        return DegreeOfficePublicCandidacyHashCode.getPublicCandidacyHashCodeByEmailAndCandidacyProcessType(email, this.getProcessType(), this.getCurrentOpenParentProcess(), degreeList) != null;
    }

    protected IndividualCandidacyProcess createNewPublicProcess(IndividualCandidacyProcessBean bean) throws DomainException, FenixServiceException {
        return (IndividualCandidacyProcess)((Object)CreateNewProcess.run(this.getProcessType(), bean, this.buildActivitiesForApplicationSubmission(bean.getPublicCandidacyHashCode())));
    }

    private List<Pair<Class<?>, Object>> buildActivitiesForApplicationSubmission(DegreeOfficePublicCandidacyHashCode hashCode) {
        ArrayList result = new ArrayList();
        result.add(this.pair(DegreeChangeIndividualCandidacyProcess.SendEmailForApplicationSubmission.class, (Object)hashCode));
        return result;
    }

    private Pair<Class<?>, Object> pair(Class<?> class1, Object object) {
        return new Pair(class1, object);
    }

    public ActionForward fillInternalPrecedentInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        IndividualCandidacyProcessWithPrecedentDegreeInformationBean bean = (IndividualCandidacyProcessWithPrecedentDegreeInformationBean)this.getIndividualCandidacyProcessBean();
        StudentCurricularPlan studentCurricularPlan = bean.getLastPrecedentStudentCurricularPlan();
        if (studentCurricularPlan == null) {
            this.addActionMessage("candidacyMessages", request, "error.public.candidacies.message.no.student.curricular.plan", null);
        } else if (studentCurricularPlan.getRegistration().isTransited()) {
            this.addActionMessage("candidacyMessages", request, "error.public.candidacies.message.no.student.curricular.plan", null);
        } else {
            bean.setPrecedentDegreeType(IndividualCandidacyProcessWithPrecedentDegreeInformationBean.PrecedentDegreeType.INSTITUTION_DEGREE);
            bean.setPrecedentStudentCurricularPlan(studentCurricularPlan);
            this.createCandidacyPrecedentDegreeInformation(bean, bean.getPrecedentStudentCurricularPlan());
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return mapping.findForward("candidacy-continue-creation");
    }

    public ActionForward fillExternalPrecedentInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        IndividualCandidacyProcessWithPrecedentDegreeInformationBean bean = (IndividualCandidacyProcessWithPrecedentDegreeInformationBean)this.getIndividualCandidacyProcessBean();
        bean.setPrecedentDegreeType(IndividualCandidacyProcessWithPrecedentDegreeInformationBean.PrecedentDegreeType.EXTERNAL_DEGREE);
        bean.setPrecedentDegreeInformation(new PrecedentDegreeInformationBean());
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return mapping.findForward("candidacy-continue-creation");
    }

    public ActionForward prepareEditCandidacyProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("edit-candidacy");
    }

    public ActionForward editCandidacyProcessInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("edit-candidacy");
    }

    @Override
    protected void setStartInformation(ActionForm form, HttpServletRequest request, HttpServletResponse response) {
    }

    protected String getFormattedApplicationSubmissionEndDate() {
        DateTime end = this.getCurrentOpenParentProcess().getCandidacyEnd();
        if (this.isInEnglishLocale()) {
            return end.toString("dd', 'MMMM' of 'yyyy", I18N.getLocale());
        }
        return end.toString("dd' de 'MMMM' de 'yyyy", I18N.getLocale());
    }

    @Override
    protected boolean existsIndividualCandidacyProcessForDocumentId(HttpServletRequest request, IDDocumentType documentType, String identification) {
        return this.getCurrentOpenParentProcess().getOpenChildProcessByDocumentId(documentType, identification) != null;
    }

    protected boolean isApplicationSubmissionPeriodValid() {
        CandidacyProcess process2 = this.getCurrentOpenParentProcess();
        if (process2 == null) {
            return false;
        }
        DateTime now = new DateTime(System.currentTimeMillis());
        return now.isAfter((ReadableInstant)process2.getCandidacyStart()) && now.isBefore((ReadableInstant)process2.getCandidacyEnd());
    }

    public ActionForward backToViewCandidacyInternal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcess individualCandidacyProcess = (IndividualCandidacyProcess)((Object)request.getAttribute("individualCandidacyProcess"));
        return this.forward(request, mapping.getPath() + ".do?method=prepareCandidacyCreation&hash=" + individualCandidacyProcess.getCandidacyHashCode().getValue());
    }

    public ActionForward prepareEditCandidacyQualifications(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("edit-candidacy-habilitations");
    }

    private ActionForward forward(HttpServletRequest request, String windowLocation) {
        ActionForward actionForward = new ActionForward();
        actionForward.setName(windowLocation);
        actionForward.setPath(windowLocation);
        actionForward.setRedirect(true);
        return actionForward;
    }

    public ActionForward backToViewCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcess individualCandidacyProcess = (IndividualCandidacyProcess)((Object)this.getDomainObject(request, "individualCandidacyProcess"));
        return this.forward(request, this.getLinkFromPublicCandidacyHashCodeForInternalUse(mapping, request, (PublicCandidacyHashCode)((Object)individualCandidacyProcess.getCandidacyHashCode())));
    }

    protected String getLinkFromPublicCandidacyHashCodeForInternalUse(ActionMapping mapping, HttpServletRequest request, PublicCandidacyHashCode hashCode) {
        return mapping.getPath() + ".do?method=prepareCandidacyCreation&hash=" + hashCode.getValue();
    }

    public ActionForward prepareEditCandidacyDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CandidacyProcessDocumentUploadBean bean = new CandidacyProcessDocumentUploadBean();
        bean.setIndividualCandidacyProcess(this.getIndividualCandidacyProcessBean().getIndividualCandidacyProcess());
        request.setAttribute("candidacyDocumentUploadBean", (Object)bean);
        return mapping.findForward("edit-candidacy-documents");
    }

    public ActionForward prepareEditCandidacyDocumentsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CandidacyProcessDocumentUploadBean bean = new CandidacyProcessDocumentUploadBean();
        bean.setIndividualCandidacyProcess(this.getIndividualCandidacyProcessBean().getIndividualCandidacyProcess());
        request.setAttribute("candidacyDocumentUploadBean", (Object)bean);
        return mapping.findForward("edit-candidacy-documents");
    }

    public ActionForward editCandidacyDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException, IOException {
        CandidacyProcessDocumentUploadBean uploadBean = (CandidacyProcessDocumentUploadBean)this.getObjectFromViewState("individualCandidacyProcessBean.document.file");
        try {
            IndividualCandidacyDocumentFile documentFile = this.createIndividualCandidacyDocumentFile(uploadBean, uploadBean.getIndividualCandidacyProcess().getPersonalDetails().getDocumentIdNumber());
            uploadBean.setDocumentFile(documentFile);
            this.executeActivity((Process)((Object)uploadBean.getIndividualCandidacyProcess()), "EditPublicCandidacyDocumentFile", uploadBean);
            request.setAttribute("individualCandidacyProcess", (Object)uploadBean.getIndividualCandidacyProcess());
            return this.backToViewCandidacyInternal(mapping, form, request, response);
        }
        catch (DomainException e) {
            this.invalidateDocumentFileRelatedViewStates();
            CandidacyProcessDocumentUploadBean bean = new CandidacyProcessDocumentUploadBean();
            bean.setIndividualCandidacyProcess(uploadBean.getIndividualCandidacyProcess());
            request.setAttribute("candidacyDocumentUploadBean", (Object)bean);
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("edit-candidacy-documents");
        }
    }

    public ActionForward backCandidacyCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("show-candidacy-creation-page");
    }

    public ActionForward prepareRecoverAccessLink(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        request.setAttribute("candidacyPreCreationBean", (Object)new CandidacyPreCreationBean());
        return mapping.findForward("show-recover-access-link-form");
    }

    public ActionForward prepareRecoverAccessLinkInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyPreCreationBean", (Object)new CandidacyPreCreationBean());
        return mapping.findForward("show-recover-access-link-form");
    }

    public ActionForward sendAccessLinkEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String email = (String)this.getObjectFromViewState("PublicAccessCandidacy.preCreationForm");
        DegreeOfficePublicCandidacyHashCode hash = DegreeOfficePublicCandidacyHashCode.getPublicCandidacyHashCodeByEmailAndCandidacyProcessTypeOrNotAssociated(email, this.getProcessType(), this.getCurrentOpenParentProcess());
        if (hash != null) {
            hash.sendEmailFoAccessLinkRecovery();
        }
        return mapping.findForward("show-recovery-email-sent");
    }

    public ActionForward prepareUploadPhoto(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CandidacyProcessDocumentUploadBean bean = new CandidacyProcessDocumentUploadBean();
        bean.setIndividualCandidacyProcess(this.getIndividualCandidacyProcessBean().getIndividualCandidacyProcess());
        bean.setType(IndividualCandidacyDocumentFileType.PHOTO);
        request.setAttribute("candidacyDocumentUploadBean", (Object)bean);
        return mapping.findForward("upload-photo");
    }

    public ActionForward uploadPhotoInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CandidacyProcessDocumentUploadBean bean = new CandidacyProcessDocumentUploadBean();
        bean.setIndividualCandidacyProcess(this.getIndividualCandidacyProcessBean().getIndividualCandidacyProcess());
        request.setAttribute("candidacyDocumentUploadBean", (Object)bean);
        return mapping.findForward("upload-photo");
    }

    public ActionForward uploadPhoto(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException, IOException {
        CandidacyProcessDocumentUploadBean uploadBean = (CandidacyProcessDocumentUploadBean)this.getObjectFromViewState("individualCandidacyProcessBean.document.file");
        try {
            IndividualCandidacyDocumentFile documentFile = this.createIndividualCandidacyDocumentFile(uploadBean, uploadBean.getIndividualCandidacyProcess().getPersonalDetails().getDocumentIdNumber());
            uploadBean.setDocumentFile(documentFile);
            this.executeActivity((Process)((Object)uploadBean.getIndividualCandidacyProcess()), "EditPublicCandidacyDocumentFile", uploadBean);
            request.setAttribute("individualCandidacyProcess", (Object)uploadBean.getIndividualCandidacyProcess());
            return this.backToViewCandidacyInternal(mapping, form, request, response);
        }
        catch (DomainException e) {
            this.invalidateDocumentFileRelatedViewStates();
            CandidacyProcessDocumentUploadBean bean = new CandidacyProcessDocumentUploadBean();
            bean.setIndividualCandidacyProcess(uploadBean.getIndividualCandidacyProcess());
            request.setAttribute("candidacyDocumentUploadBean", (Object)bean);
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("upload-photo");
        }
    }

    public ActionForward candidaciesTypesInformationIntro(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = I18N.getLocale();
        String countryCode = RefactoredIndividualCandidacyProcessPublicDA.readCountryCode(locale);
        String institutionalURL = Installation.getInstance().getInstituitionURL();
        if ("PT".equals(countryCode)) {
            return this.redirect(institutionalURL + "pt/candidatos/candidaturas/", request);
        }
        return this.redirect(institutionalURL + "en/prospective-students/admissions/", request);
    }

    private static String readCountryCode(Locale locale) {
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String result = null;
        if (!StringUtils.isEmpty((String)country)) {
            result = country.toUpperCase();
        } else if (!StringUtils.isEmpty((String)language)) {
            result = language.toUpperCase();
        }
        if (!StringUtils.isEmpty((String)result)) {
            return result;
        }
        return "PT";
    }

    public static class CandidacyPreCreationBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String email;

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }
}

