/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.thesis.coordinator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.activities.SubmitJuryElementsDocuments;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.ui.struts.action.phd.PhdDocumentsZip;
import org.fenixedu.academic.ui.struts.action.phd.coordinator.PhdIndividualProgramProcessDA;
import org.fenixedu.academic.ui.struts.action.phd.thesis.CommonPhdThesisProcessDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.LocalDate;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/phdThesisProcess", module="coordinator", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="submitJuryElementsDocument", path="/phd/thesis/coordinator/submitJuryElementsDocument.jsp"), @Forward(name="manageThesisJuryElements", path="/phd/thesis/coordinator/manageThesisJuryElements.jsp"), @Forward(name="juryReporterFeedbackUpload", path="/phd/thesis/coordinator/juryReporterFeedbackUpload.jsp"), @Forward(name="manageThesisDocuments", path="/phd/thesis/coordinator/manageThesisDocuments.jsp"), @Forward(name="scheduleThesisMeeting", path="/phd/thesis/coordinator/scheduleThesisMeeting.jsp"), @Forward(name="editPhdProcessState", path="/phd/thesis/academicAdminOffice/editState.jsp")})
public class PhdThesisProcessDA
extends CommonPhdThesisProcessDA {
    private static final List<PhdIndividualProgramDocumentType> AVAILABLE_DOCUMENTS_TO_COORDINATOR = Arrays.asList(PhdIndividualProgramDocumentType.ASSISTENT_GUIDER_ACCEPTANCE_LETTER, PhdIndividualProgramDocumentType.CANDIDACY_FEEDBACK_DOCUMENT, PhdIndividualProgramDocumentType.CANDIDACY_FORM, PhdIndividualProgramDocumentType.CANDIDACY_RATIFICATION, PhdIndividualProgramDocumentType.CV, PhdIndividualProgramDocumentType.DEGREE_FINALIZATION_CERTIFICATE, PhdIndividualProgramDocumentType.DISSERTATION_OR_FINAL_WORK_DOCUMENT, PhdIndividualProgramDocumentType.FINAL_THESIS, PhdIndividualProgramDocumentType.GRE_LINGUISTICS_CERTIFICATE, PhdIndividualProgramDocumentType.GUIDER_ACCEPTANCE_LETTER, PhdIndividualProgramDocumentType.HABILITATION_CERTIFICATE_DOCUMENT, PhdIndividualProgramDocumentType.ID_DOCUMENT, PhdIndividualProgramDocumentType.JURY_PRESIDENT_ELEMENT, PhdIndividualProgramDocumentType.MAXIMUM_GRADE_GUIDER_PROPOSAL, PhdIndividualProgramDocumentType.MOTIVATION_LETTER, PhdIndividualProgramDocumentType.PROVISIONAL_THESIS, PhdIndividualProgramDocumentType.PUBLIC_PRESENTATION_SEMINAR_COMISSION, PhdIndividualProgramDocumentType.PUBLIC_PRESENTATION_SEMINAR_REPORT, PhdIndividualProgramDocumentType.RECOMMENDATION_LETTER, PhdIndividualProgramDocumentType.REGISTRATION_FORM, PhdIndividualProgramDocumentType.RESEARCH_PLAN, PhdIndividualProgramDocumentType.SOCIAL_SECURITY, PhdIndividualProgramDocumentType.STUDY_PLAN, PhdIndividualProgramDocumentType.THESIS_ABSTRACT, PhdIndividualProgramDocumentType.THESIS_REQUIREMENT, PhdIndividualProgramDocumentType.TOEFL_LINGUISTICS_CERTIFICATE, PhdIndividualProgramDocumentType.JURY_ELEMENTS, PhdIndividualProgramDocumentType.JURY_REPORT_FEEDBACK);

    public ActionForward prepareSubmitJuryElementsDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        bean.setWhenJuryDesignated(new LocalDate());
        bean.setGenerateAlert(true);
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.JURY_ELEMENTS));
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("submitJuryElementsDocument");
    }

    public ActionForward submitJuryElementsDocumentInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        return mapping.findForward("submitJuryElementsDocument");
    }

    public ActionForward submitJuryElementsDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            IViewState viewState = RenderUtils.getViewState((String)"thesisProcessBean.edit.documents");
            if (!viewState.isValid()) {
                return this.submitJuryElementsDocumentInvalid(mapping, actionForm, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), SubmitJuryElementsDocuments.class, (Object)this.getThesisProcessBean());
            this.addSuccessMessage(request, "message.thesis.jury.elements.added.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.submitJuryElementsDocumentInvalid(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward manageThesisJuryElements(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("manageThesisJuryElements");
    }

    @Override
    public ActionForward manageThesisDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ArrayList<PhdProgramProcessDocument> sharedDocuments = new ArrayList<PhdProgramProcessDocument>();
        PhdThesisProcess thesisProcess = this.getProcess(request);
        Set latestDocumentVersions = thesisProcess.getLatestDocumentVersions();
        for (PhdProgramProcessDocument phdProgramProcessDocument : latestDocumentVersions) {
            if (!AVAILABLE_DOCUMENTS_TO_COORDINATOR.contains((Object)phdProgramProcessDocument.getDocumentType())) continue;
            sharedDocuments.add(phdProgramProcessDocument);
        }
        request.setAttribute("sharedDocuments", sharedDocuments);
        return super.manageThesisDocuments(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward downloadThesisDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.writeFile(response, this.getThesisDocumentsFilename(request), PhdDocumentsZip.ZIP_MIME_TYPE, this.createThesisZip(request));
        return null;
    }

    protected byte[] createThesisZip(HttpServletRequest request) throws IOException {
        PhdThesisProcess thesisProcess = this.getProcess(request);
        ArrayList<PhdProgramProcessDocument> sharedDocuments = new ArrayList<PhdProgramProcessDocument>();
        Set latestDocumentVersions = thesisProcess.getLatestDocumentVersions();
        for (PhdProgramProcessDocument phdProgramProcessDocument : latestDocumentVersions) {
            if (!AVAILABLE_DOCUMENTS_TO_COORDINATOR.contains((Object)phdProgramProcessDocument.getDocumentType())) continue;
            sharedDocuments.add(phdProgramProcessDocument);
        }
        return PhdDocumentsZip.zip(sharedDocuments);
    }
}

