/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.library.theses;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.dto.thesis.ThesisSearchBean;
import org.fenixedu.academic.ui.struts.action.library.LibraryApplication;
import org.fenixedu.academic.ui.struts.action.library.theses.ThesisLibraryDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=LibraryApplication.class, path="thesis-validation", titleKey="thesis.validation.title.list", accessGroup="nobody")
@Mapping(module="library", path="/theses/search")
@Forwards(value={@Forward(name="search", path="/library/theses/search.jsp")})
public class SearchThesesDA
extends ThesisLibraryDA {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisSearchBean search = new ThesisSearchBean();
        this.performSearch(request, search);
        return mapping.findForward("search");
    }

    public ActionForward update(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String text = request.getParameter("text");
        String state = request.getParameter("state");
        String year = request.getParameter("year");
        ThesisSearchBean search = new ThesisSearchBean(text, state, year);
        this.performSearch(request, search);
        return mapping.findForward("search");
    }

    public ActionForward search(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisSearchBean search = (ThesisSearchBean)this.getRenderedObject("search");
        this.performSearch(request, search);
        return mapping.findForward("search");
    }

    private void performSearch(HttpServletRequest request, ThesisSearchBean search) {
        if (request.getAttribute("sortBy") != null) {
            request.setAttribute("sortBy", request.getAttribute("sortBy"));
        }
        request.setAttribute("searchFilter", (Object)search);
        request.setAttribute("searchArgs", (Object)this.buildSearchArgs(search));
        ArrayList<Thesis> theses = new ArrayList<Thesis>();
        for (Thesis thesis : Thesis.getEvaluatedThesis()) {
            if (!thesis.isFinalAndApprovedThesis() || !search.isMatch(thesis)) continue;
            theses.add(thesis);
        }
        ArrayList<Thesis> result = theses;
        request.setAttribute("thesesFound", (Object)result.size());
        request.setAttribute("theses", result);
    }
}

