/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.internationalRelatOffice.candidacy.erasmus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusCoordinatorBean;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusVacancyBean;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.SendReceptionEmailBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityCoordinator;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplate;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplateBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplateType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityQuota;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.candidacy.erasmus.ErasmusCandidacyProcessDA;
import org.fenixedu.academic.ui.struts.action.internationalRelatOffice.InternationalRelationsApplication;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=InternationalRelationsApplication.InternRelationsMobilityApp.class, path="incoming", titleKey="title.mobility.incoming")
@Mapping(path="/caseHandlingMobilityApplicationProcess", module="internationalRelatOffice", formBeanClass=ErasmusCandidacyProcessDA.ErasmusCandidacyProcessForm.class)
@Forwards(value={@Forward(name="intro", path="/candidacy/erasmus/mainCandidacyProcess.jsp"), @Forward(name="prepare-create-new-process", path="/candidacy/createCandidacyPeriod.jsp"), @Forward(name="prepare-edit-candidacy-period", path="/candidacy/editCandidacyPeriod.jsp"), @Forward(name="view-university-agreements", path="/candidacy/erasmus/viewErasmusVacancies.jsp"), @Forward(name="insert-university-agreement", path="/candidacy/erasmus/insertErasmusVacancy.jsp"), @Forward(name="view-erasmus-coordinators", path="/candidacy/erasmus/viewErasmusCoordinators.jsp"), @Forward(name="assign-coordinator", path="/candidacy/erasmus/assignCoordinator.jsp"), @Forward(name="send-reception-email-present-individual-processes", path="/candidacy/erasmus/reception/sendReceptionEmailPresentIndividualProcesses.jsp"), @Forward(name="send-reception-email-edit-individual-candidacies", path="/candidacy/erasmus/reception/sendReceptionEmailEditIndividualCandidacies.jsp"), @Forward(name="edit-reception-email-message", path="/candidacy/erasmus/reception/editReceptionEmailMessage.jsp"), @Forward(name="view-email-to-send", path="/candidacy/erasmus/reception/viewEmailToSend.jsp"), @Forward(name="email-sent-with-success", path="/candidacy/erasmus/reception/emailSentWithSuccess.jsp"), @Forward(name="manageEmailTemplates", path="/candidacy/erasmus/emailTemplates/manageEmailTemplates.jsp"), @Forward(name="previewEmailTemplate", path="/candidacy/erasmus/emailTemplates/previewEmailTemplate.jsp")})
public class ErasmusCandidacyProcessDA
extends org.fenixedu.academic.ui.struts.action.candidacy.erasmus.ErasmusCandidacyProcessDA {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setLocale(request, Locale.ENGLISH);
        I18N.setLocale((HttpSession)request.getSession(), (Locale)Locale.ENGLISH);
        return super.execute(mapping, actionForm, request, response);
    }

    @Override
    protected MobilityApplicationProcess getProcess(HttpServletRequest request) {
        return super.getProcess(request);
    }

    protected List<IndividualCandidacyProcess> getChildProcesses(CandidacyProcess process2, HttpServletRequest request) {
        Set processes = process2.getChildProcessesSet();
        ArrayList<IndividualCandidacyProcess> selectedDegreesIndividualCandidacyProcesses = new ArrayList<IndividualCandidacyProcess>();
        Degree selectedDegree = this.getChooseDegreeBean(request).getDegree();
        MobilityProgram selectedProgram = this.getChooseMobilityProgramBean(request).getMobilityProgram();
        for (IndividualCandidacyProcess child : processes) {
            if (selectedDegree != null && ((MobilityIndividualApplicationProcess)((Object)child)).getCandidacy().getSelectedDegree() != selectedDegree || selectedProgram != null && ((MobilityIndividualApplicationProcess)((Object)child)).getCandidacy().getMobilityStudentData().getSelectedOpening().getMobilityAgreement().getMobilityProgram() != selectedProgram) continue;
            selectedDegreesIndividualCandidacyProcesses.add(child);
        }
        return selectedDegreesIndividualCandidacyProcesses;
    }

    public ActionForward prepareExecuteViewMobilityQuota(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareExecuteViewMobilityQuota(mapping, form, request, response, null);
    }

    public ActionForward prepareExecuteViewMobilityQuota(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, MobilityProgram program) {
        ErasmusVacancyBean erasmusVacancyBean = new ErasmusVacancyBean(program);
        request.setAttribute("erasmusVacancyBean", (Object)erasmusVacancyBean);
        MobilityApplicationProcess process2 = this.getProcess(request);
        if (erasmusVacancyBean.getMobilityProgram() != null) {
            List<MobilityQuota> mobilityQuotasByProgram = process2.getApplicationPeriod().getMobilityQuotasByProgram(erasmusVacancyBean.getMobilityProgram());
            request.setAttribute("quotas", mobilityQuotasByProgram);
        }
        return mapping.findForward("view-university-agreements");
    }

    public ActionForward selectMobilityQuotaForQuotasManagementPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ErasmusVacancyBean erasmusVacancyBean = this.getErasmusVacancyBean();
        request.setAttribute("erasmusVacancyBean", (Object)erasmusVacancyBean);
        MobilityApplicationProcess process2 = this.getProcess(request);
        if (erasmusVacancyBean.getMobilityProgram() != null) {
            List<MobilityQuota> mobilityQuotasByProgram = process2.getApplicationPeriod().getMobilityQuotasByProgram(erasmusVacancyBean.getMobilityProgram());
            request.setAttribute("quotas", mobilityQuotasByProgram);
        }
        return mapping.findForward("view-university-agreements");
    }

    public ActionForward prepareExecuteInsertMobilityQuota(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MobilityProgram program = (MobilityProgram)this.getDomainObject(request, "mobilityProgramId");
        request.setAttribute("erasmusVacancyBean", (Object)new ErasmusVacancyBean(program));
        return mapping.findForward("insert-university-agreement");
    }

    public ActionForward prepareExecuteInsertMobilityQuotaInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("erasmusVacancyBean", (Object)this.getErasmusVacancyBean());
        return mapping.findForward("insert-university-agreement");
    }

    public ActionForward executeInsertMobilityQuota(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityApplicationProcess process2 = this.getProcess(request);
        ErasmusVacancyBean bean = this.getErasmusVacancyBean();
        for (Degree degree : bean.getDegrees()) {
            if (!process2.getCandidacyPeriod().existsFor(bean.getMobilityAgreement(), degree)) continue;
            this.addActionMessage(request, "error.erasmus.insert.vacancy.already.exists");
            return mapping.findForward("insert-university-agreement");
        }
        this.executeActivity((Process)((Object)this.getProcess(request)), "InsertMobilityQuota", bean);
        return this.prepareExecuteViewMobilityQuota(mapping, form, request, response, bean.getMobilityProgram());
    }

    public ActionForward selectCountryForVacancyInsertion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ErasmusVacancyBean bean = this.getErasmusVacancyBean();
        RenderUtils.invalidateViewState();
        request.setAttribute("erasmusVacancyBean", (Object)bean);
        return mapping.findForward("insert-university-agreement");
    }

    public ActionForward executeRemoveVacancy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityQuota quota = (MobilityQuota)((Object)this.getDomainObject(request, "vacancyExternalId"));
        if (!quota.getApplicationsSet().isEmpty()) {
            this.addActionMessage(request, "error.erasmus.vacancy.has.associated.candidacies");
            return this.prepareExecuteViewMobilityQuota(mapping, form, request, response);
        }
        this.executeActivity((Process)((Object)this.getProcess(request)), "RemoveMobilityQuota", new ErasmusVacancyBean(quota));
        return this.prepareExecuteViewMobilityQuota(mapping, form, request, response);
    }

    public ActionForward prepareExecuteViewErasmusCoordinators(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("view-erasmus-coordinators");
    }

    public ActionForward prepareExecuteAssignCoordinator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("erasmusCoordinatorBean", (Object)new ErasmusCoordinatorBean());
        return mapping.findForward("assign-coordinator");
    }

    public ActionForward executeAssignCoordinator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ErasmusCoordinatorBean bean = this.getErasmusCoordinatorBean();
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "AssignCoordinator", bean);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            return this.prepareExecuteAssignCoordinator(mapping, form, request, response);
        }
        return this.prepareExecuteViewErasmusCoordinators(mapping, form, request, response);
    }

    public ActionForward executeAssignCoordinatorInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareExecuteAssignCoordinator(mapping, form, request, response);
    }

    public ActionForward executeRemoveTeacherFromCoordinators(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MobilityCoordinator coordinator = this.getErasmusCoordinator(request);
        this.executeActivity((Process)((Object)this.getProcess(request)), "RemoveTeacherFromCoordinators", new ErasmusCoordinatorBean(coordinator));
        return this.prepareExecuteViewErasmusCoordinators(mapping, form, request, response);
    }

    public ActionForward executeRemoveTeacherFromCoordinatorsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareExecuteViewErasmusCoordinators(mapping, form, request, response);
    }

    public ActionForward searchTeacherByNumber(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ErasmusCoordinatorBean bean = this.getErasmusCoordinatorBean();
        Teacher teacher = Teacher.readByIstId(bean.getTeacherId());
        bean.setTeacher(teacher);
        request.setAttribute("erasmusCoordinatorBean", (Object)bean);
        return mapping.findForward("assign-coordinator");
    }

    public ActionForward executeSendEmailToMissingRequiredDocumentsProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.executeActivity((Process)((Object)this.getProcess(request)), "SendEmailToMissingRequiredDocumentsProcesses", null);
        request.setAttribute("sentEmail", (Object)true);
        return this.prepareExecuteViewChildProcessWithMissingRequiredDocumentFiles(mapping, form, request, response);
    }

    public ActionForward executeSendEmailToMissingShiftsProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SendEmailToMissingShiftsProcesses", null);
            request.setAttribute("sentEmail", (Object)true);
        }
        catch (DomainException e) {
            request.setAttribute("emailError", (Object)e.getLocalizedMessage());
        }
        return this.prepareExecuteViewChildProcessWithMissingShifts(mapping, form, request, response);
    }

    private MobilityCoordinator getErasmusCoordinator(HttpServletRequest request) {
        return (MobilityCoordinator)((Object)this.getDomainObject(request, "erasmusCoordinatorExternalId"));
    }

    private ErasmusCoordinatorBean getErasmusCoordinatorBean() {
        return (ErasmusCoordinatorBean)this.getRenderedObject("erasmus.coordinator.bean");
    }

    private ErasmusVacancyBean getErasmusVacancyBean() {
        return (ErasmusVacancyBean)this.getRenderedObject("erasmus.vacancy.bean");
    }

    @Override
    protected List<Activity> getAllowedActivities(CandidacyProcess process2) {
        List activities = process2.getAllowedActivities(Authenticate.getUser());
        ArrayList<Activity> resultActivities = new ArrayList<Activity>();
        for (Activity activity : activities) {
            if (!activity.isVisibleForGriOffice().booleanValue()) continue;
            resultActivities.add(activity);
        }
        return resultActivities;
    }

    public ActionForward prepareExecuteSendReceptionEmail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        SendReceptionEmailBean bean = this.getRenderedSendReceptionEmailBean();
        if (bean == null) {
            bean = new SendReceptionEmailBean(this.getProcess(request));
            bean.retrieveProcesses();
        }
        RenderUtils.invalidateViewState((String)"send.reception.email.bean");
        RenderUtils.invalidateViewState((String)"send.reception.email.bean.edit");
        request.setAttribute("sendReceptionEmailBean", (Object)bean);
        return mapping.findForward("send-reception-email-present-individual-processes");
    }

    public ActionForward prepareEditReceptionEmailMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SendReceptionEmailBean bean = this.getRenderedSendReceptionEmailBean();
        request.setAttribute("sendReceptionEmailBean", (Object)bean);
        return mapping.findForward("edit-reception-email-message");
    }

    public ActionForward editReceptionEmailMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.executeActivity((Process)((Object)this.getProcess(request)), "EditReceptionEmailMessage", this.getRenderedSendReceptionEmailBean());
        return this.prepareExecuteSendReceptionEmail(mapping, form, request, response);
    }

    public ActionForward editReceptionEmailMessageInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SendReceptionEmailBean bean = this.getRenderedSendReceptionEmailBean();
        request.setAttribute("sendReceptionEmailBean", (Object)bean);
        return mapping.findForward("edit-reception-email-message");
    }

    public ActionForward viewEmailToSend(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SendReceptionEmailBean bean = this.getRenderedSendReceptionEmailBean();
        request.setAttribute("sendReceptionEmailBean", (Object)bean);
        return mapping.findForward("view-email-to-send");
    }

    public ActionForward sendReceptionEmail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        SendReceptionEmailBean bean = this.getRenderedSendReceptionEmailBean();
        this.executeActivity((Process)((Object)this.getProcess(request)), "SendReceptionEmail", bean);
        return mapping.findForward("email-sent-with-success");
    }

    public ActionForward sendReceptionEmailSetFilter(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        SendReceptionEmailBean bean = this.getRenderedSendReceptionEmailBean();
        bean.retrieveProcesses();
        return this.prepareExecuteSendReceptionEmail(mapping, actionForm, request, response);
    }

    public ActionForward sendReceptionEmailEditIndividualCandidacies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        SendReceptionEmailBean bean = this.getRenderedSendReceptionEmailBean();
        RenderUtils.invalidateViewState((String)"send.reception.email.bean");
        RenderUtils.invalidateViewState((String)"send.reception.email.bean.edit");
        request.setAttribute("validIndividualProcesses", this.getProcess(request).getValidMobilityIndividualCandidacies(bean.getMobilityProgram()));
        request.setAttribute("sendReceptionEmailBean", (Object)bean);
        this.setSelectedIndividualProcesses((ErasmusCandidacyProcessDA.ErasmusCandidacyProcessForm)actionForm, bean);
        return mapping.findForward("send-reception-email-edit-individual-candidacies");
    }

    public ActionForward sendReceptionEmailSetSelectedIndividualProcesses(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        List<MobilityIndividualApplicationProcess> selectedIndividual;
        SendReceptionEmailBean bean = this.getRenderedSendReceptionEmailBean();
        if (bean == null) {
            bean = new SendReceptionEmailBean(this.getProcess(request));
        }
        if ((selectedIndividual = this.retrieveSelectedProcesses((ErasmusCandidacyProcessDA.ErasmusCandidacyProcessForm)actionForm)).isEmpty()) {
            bean.retrieveProcesses();
        } else {
            bean.setSubjectProcesses(selectedIndividual);
        }
        return this.prepareExecuteSendReceptionEmail(mapping, actionForm, request, response);
    }

    private void setSelectedIndividualProcesses(ErasmusCandidacyProcessDA.ErasmusCandidacyProcessForm actionForm, SendReceptionEmailBean bean) {
        ArrayList<String> externalIdList = new ArrayList<String>();
        for (MobilityIndividualApplicationProcess individualProcess : bean.getSubjectProcesses()) {
            externalIdList.add(individualProcess.getExternalId());
        }
        actionForm.setSelectedProcesses(externalIdList.toArray(new String[0]));
    }

    private List<MobilityIndividualApplicationProcess> retrieveSelectedProcesses(ErasmusCandidacyProcessDA.ErasmusCandidacyProcessForm actionForm) {
        ArrayList<MobilityIndividualApplicationProcess> processList = new ArrayList<MobilityIndividualApplicationProcess>();
        if (actionForm.getSelectedProcesses() != null) {
            for (String externalId : actionForm.getSelectedProcesses()) {
                processList.add((MobilityIndividualApplicationProcess)FenixFramework.getDomainObject((String)externalId));
            }
        }
        return processList;
    }

    private SendReceptionEmailBean getRenderedSendReceptionEmailBean() {
        return (SendReceptionEmailBean)this.getRenderedObject("send.reception.email.bean");
    }

    public ActionForward manageEmailTemplates(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityEmailTemplateBean bean = new MobilityEmailTemplateBean();
        MobilityApplicationProcess process2 = this.getProcess(request);
        Set<MobilityProgram> mobilityPrograms = process2.getCandidacyPeriod().getMobilityPrograms();
        String templateType = request.getParameter("template");
        if (templateType != null && templateType.equals("Reception")) {
            bean.setType(MobilityEmailTemplateType.IST_RECEPTION);
            MobilityEmailTemplate emailTemplate = process2.getCandidacyPeriod().getEmailTemplateFor(bean.getType());
            bean.setSubject(emailTemplate.getSubject());
            bean.setBody(emailTemplate.getBody());
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("mobilityEmailTemplateBean", (Object)bean);
        request.setAttribute("hasMobilityPrograms", (Object)(!mobilityPrograms.isEmpty() ? 1 : 0));
        request.setAttribute("mobilityPrograms", mobilityPrograms);
        return mapping.findForward("manageEmailTemplates");
    }

    public ActionForward manageEmailTemplatesPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityEmailTemplateBean bean = this.getMobilityEmailTemplateBean();
        MobilityApplicationProcess process2 = this.getProcess(request);
        MobilityApplicationPeriod candidacyPeriod = process2.getCandidacyPeriod();
        MobilityEmailTemplate emailTemplate = candidacyPeriod.getEmailTemplateFor(bean.getMobilityProgram(), bean.getType());
        if (emailTemplate != null) {
            bean.setSubject(emailTemplate.getSubject());
            bean.setBody(emailTemplate.getBody());
        } else {
            bean.setSubject("");
            bean.setBody("");
        }
        request.setAttribute("mobilityEmailTemplateBean", (Object)bean);
        request.setAttribute("hasMobilityPrograms", (Object)true);
        RenderUtils.invalidateViewState();
        return mapping.findForward("manageEmailTemplates");
    }

    public ActionForward manageEmailTemplatesInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityEmailTemplateBean bean = this.getMobilityEmailTemplateBean();
        request.setAttribute("mobilityEmailTemplateBean", (Object)bean);
        request.setAttribute("hasMobilityPrograms", (Object)true);
        RenderUtils.invalidateViewState();
        return mapping.findForward("manageEmailTemplates");
    }

    public ActionForward previewEmailTemplate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityEmailTemplateBean bean = this.getMobilityEmailTemplateBean();
        request.setAttribute("mobilityEmailTemplateBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("previewEmailTemplate");
    }

    public ActionForward editEmailTemplate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityEmailTemplateBean bean = this.getMobilityEmailTemplateBean();
        MobilityApplicationProcess process2 = this.getProcess(request);
        process2.getCandidacyPeriod().editEmailTemplates(bean);
        return this.manageEmailTemplates(mapping, actionForm, request, response);
    }

    private MobilityEmailTemplateBean getMobilityEmailTemplateBean() {
        return (MobilityEmailTemplateBean)this.getRenderedObject("mobilityEmailTemplateBean");
    }

    public static class ActiveErasmusIndividualCandidaciesForSendReceptionProvider
    implements DataProvider {
        public Converter getConverter() {
            return new DomainObjectKeyConverter();
        }

        public Object provide(Object source, Object currentValue) {
            SendReceptionEmailBean bean = (SendReceptionEmailBean)source;
            MobilityApplicationProcess candidacyProcess = bean.getMobilityApplicationProcess();
            return null;
        }
    }

    public static class UniversityUnitsProvider
    implements DataProvider {
        public Converter getConverter() {
            return new DomainObjectKeyConverter();
        }

        public Object provide(Object source, Object currentValue) {
            ErasmusVacancyBean bean = (ErasmusVacancyBean)source;
            CountryUnit selectedCountryUnit = CountryUnit.getCountryUnitByCountry(bean.getCountry());
            if (selectedCountryUnit == null) {
                return new ArrayList();
            }
            ArrayList associatedUniversityUnits = new ArrayList(selectedCountryUnit.getSubUnits(PartyTypeEnum.UNIVERSITY));
            Collections.sort(associatedUniversityUnits, new BeanComparator("nameI18n"));
            return associatedUniversityUnits;
        }
    }
}

