/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.directiveCouncil;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.executionCourse.ExecutionCourseWithNoEvaluationMethodSearchBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;

public abstract class EvaluationMethodControlDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward search(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExecutionCourseWithNoEvaluationMethodSearchBean executionCourseWithNoEvaluationMethodSearchBean = this.getSearchBean(request);
        request.setAttribute("executionCourseWithNoEvaluationMethodSearchBean", (Object)executionCourseWithNoEvaluationMethodSearchBean);
        request.setAttribute("executionCourses", (Object)executionCourseWithNoEvaluationMethodSearchBean.getSearchResult());
        return mapping.findForward("search");
    }

    public ActionForward exportToXLS(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.export(request, response, new MethodInvoker(){

            @Override
            public void export(Spreadsheet spreadsheet, OutputStream outputStream) throws IOException {
                spreadsheet.exportToXLSSheet(outputStream);
            }

            @Override
            public String getExtension() {
                return ".xls";
            }
        });
        return null;
    }

    public ActionForward exportToCSV(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.export(request, response, new MethodInvoker(){

            @Override
            public void export(Spreadsheet spreadsheet, OutputStream outputStream) throws IOException {
                spreadsheet.exportToCSV(outputStream, "\t");
            }

            @Override
            public String getExtension() {
                return ".csv";
            }
        });
        return null;
    }

    public ActionForward export(HttpServletRequest request, HttpServletResponse response, MethodInvoker methodInvoker) throws FenixServiceException {
        ExecutionCourseWithNoEvaluationMethodSearchBean executionCourseWithNoEvaluationMethodSearchBean = this.getSearchBean(request);
        try {
            String filename = "ControloMetodosAvaliacao:" + new DateTime().toString("yyyyMMddHHmm");
            response.setContentType("text/plain");
            response.setHeader("Content-disposition", "attachment; filename=" + filename + methodInvoker.getExtension());
            ServletOutputStream writer = response.getOutputStream();
            Spreadsheet spreadsheet = new Spreadsheet("ControloMetodosAvaliacao");
            for (ExecutionCourse executionCourse : executionCourseWithNoEvaluationMethodSearchBean.getSearchResult()) {
                Spreadsheet.Row row = spreadsheet.addRow();
                row.setCell(executionCourse.getNome());
                StringBuilder degrees = new StringBuilder();
                for (Degree degree : executionCourse.getDegreesSortedByDegreeName()) {
                    if (degrees.length() > 0) {
                        degrees.append(", ");
                    }
                    degrees.append(degree.getSigla());
                }
                row.setCell(degrees.toString());
                StringBuilder responsibleTeachers = new StringBuilder();
                StringBuilder otherTeachers = new StringBuilder();
                for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                    Person person = professorship.getPerson();
                    if (professorship.isResponsibleFor()) {
                        if (responsibleTeachers.length() > 0) {
                            responsibleTeachers.append(", ");
                        }
                        responsibleTeachers.append(person.getName());
                        responsibleTeachers.append(" (");
                        responsibleTeachers.append(person.getEmail());
                        responsibleTeachers.append(" )");
                        continue;
                    }
                    if (otherTeachers.length() > 0) {
                        otherTeachers.append(", ");
                    }
                    otherTeachers.append(person.getName());
                    otherTeachers.append(" (");
                    otherTeachers.append(person.getEmail());
                    otherTeachers.append(" )");
                }
                row.setCell(responsibleTeachers.toString());
                row.setCell(otherTeachers.toString());
                StringBuilder departments = new StringBuilder();
                for (Department department : executionCourse.getDepartments()) {
                    if (departments.length() > 0) {
                        departments.append(", ");
                    }
                    departments.append(department.getName());
                }
                row.setCell(departments.toString());
            }
            methodInvoker.export(spreadsheet, (OutputStream)writer);
            writer.flush();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new FenixServiceException();
        }
        return null;
    }

    private ExecutionCourseWithNoEvaluationMethodSearchBean getSearchBean(HttpServletRequest request) {
        ExecutionCourseWithNoEvaluationMethodSearchBean executionCourseWithNoEvaluationMethodSearchBean = this.getExecutionCourseWithNoEvaluationMethodSearchBean(request);
        if (executionCourseWithNoEvaluationMethodSearchBean == null) {
            executionCourseWithNoEvaluationMethodSearchBean = new ExecutionCourseWithNoEvaluationMethodSearchBean();
        }
        return executionCourseWithNoEvaluationMethodSearchBean;
    }

    private ExecutionCourseWithNoEvaluationMethodSearchBean getExecutionCourseWithNoEvaluationMethodSearchBean(HttpServletRequest request) {
        ExecutionCourseWithNoEvaluationMethodSearchBean executionCourseWithNoEvaluationMethodSearchBean = (ExecutionCourseWithNoEvaluationMethodSearchBean)this.getRenderedObject();
        return executionCourseWithNoEvaluationMethodSearchBean == null ? (ExecutionCourseWithNoEvaluationMethodSearchBean)request.getAttribute("executionCourseWithNoEvaluationMethodSearchBean") : executionCourseWithNoEvaluationMethodSearchBean;
    }

    private static abstract class MethodInvoker {
        private MethodInvoker() {
        }

        public abstract void export(Spreadsheet var1, OutputStream var2) throws IOException;

        public abstract String getExtension();
    }
}

