/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.alumni;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Formation;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.MobilePhone;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionUnit;
import org.fenixedu.academic.ui.struts.action.base.FenixAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsApplication;

@StrutsApplication(bundle="AlumniResources", path="alumni-section", titleKey="label.alumni.main.title", hint="Alumni", accessGroup="role(ALUMNI)")
@Mapping(module="alumni", path="/index")
@Forwards(value={@Forward(name="Success", path="/alumni/index.jsp")})
public class AlumniHomeDA
extends FenixAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getLoggedPerson(request);
        double formationsPercentage = this.getFormationsPercentage(person.getFormations());
        double jobsPercentage = this.getJobsPercentage(person.getJobsSet());
        if (!this.areContactsUpToDate(person)) {
            request.setAttribute("showContactsMessage", (Object)true);
        }
        int finalFormationsResult = (int)Math.round(formationsPercentage / 10.0) * 10;
        request.setAttribute("educationStatus", (Object)Integer.toString(finalFormationsResult));
        int finalJobsResult = (int)Math.round(jobsPercentage / 10.0) * 10;
        request.setAttribute("professionalStatus", (Object)Integer.toString(finalJobsResult));
        if (finalFormationsResult < 50 || finalJobsResult < 50) {
            request.setAttribute("displayWarning", (Object)true);
        }
        if (finalFormationsResult < 50 && finalFormationsResult != 0) {
            request.setAttribute("educationInsufficientData", (Object)true);
        } else if (finalFormationsResult > 0) {
            request.setAttribute("educationSufficientData", (Object)true);
        } else {
            request.setAttribute("educationNoData", (Object)true);
        }
        if (finalJobsResult < 50 && finalJobsResult != 0) {
            request.setAttribute("professionalInsufficientData", (Object)true);
        } else if (finalJobsResult > 0) {
            request.setAttribute("professionalSufficientData", (Object)true);
        } else {
            request.setAttribute("professionalNoData", (Object)true);
        }
        if (finalJobsResult == 100) {
            request.setAttribute("dontShowJobComplete", (Object)true);
        }
        if (finalFormationsResult == 100) {
            request.setAttribute("dontShowFormationComplete", (Object)true);
        }
        return mapping.findForward("Success");
    }

    private boolean areContactsUpToDate(Person person) {
        return person.areContactsRecent(EmailAddress.class, 365) && person.areContactsRecent(MobilePhone.class, 365);
    }

    private double getFormationsPercentage(List<Formation> formations) {
        double completionPercentage = 0.0;
        for (Formation formation : formations) {
            int numberOfHits = 0;
            int totalNumber = 9;
            if (formation.getFormationType() != null) {
                ++numberOfHits;
            }
            if (formation.getDegree() != null) {
                ++numberOfHits;
            }
            if (formation.getEducationArea() != null) {
                ++numberOfHits;
            }
            if (formation.getInstitutionType() != null) {
                ++numberOfHits;
            }
            if (formation.getInstitution() != null) {
                ++numberOfHits;
                AcademicalInstitutionType academicalInstitutionType = ((AcademicalInstitutionUnit)((Object)formation.getInstitution())).getInstitutionType();
                if (academicalInstitutionType == null) {
                    academicalInstitutionType = formation.getInstitutionType();
                }
                if (AcademicalInstitutionType.FOREIGN_INSTITUTION.equals((Object)academicalInstitutionType)) {
                    if (formation.getCountry() != null) {
                        ++numberOfHits;
                    }
                    ++totalNumber;
                }
                if (AcademicalInstitutionUnit.readOfficialParentUnitsByType(academicalInstitutionType).contains((Object)formation.getInstitution())) {
                    if (formation.getBaseInstitution() != null) {
                        ++numberOfHits;
                    }
                    ++totalNumber;
                }
            }
            if (formation.getBeginYear() != null) {
                ++numberOfHits;
            }
            if (formation.getYear() != null) {
                ++numberOfHits;
            }
            if (formation.getEctsCredits() != null) {
                ++numberOfHits;
            }
            if (formation.getFormationHours() != null) {
                ++numberOfHits;
            }
            completionPercentage += (double)numberOfHits / (double)totalNumber;
        }
        double totalCompletionPercentage = completionPercentage;
        if (!formations.isEmpty()) {
            totalCompletionPercentage = completionPercentage / (double)formations.size();
        }
        Math.ceil(totalCompletionPercentage *= 100.0);
        return totalCompletionPercentage;
    }

    private double getJobsPercentage(Collection<Job> jobs) {
        double completionPercentage = 0.0;
        int totalNumber = 11;
        for (Job job : jobs) {
            int numberOfHits = 0;
            if (!StringUtils.isEmpty((String)job.getEmployerName())) {
                ++numberOfHits;
            }
            if (!StringUtils.isEmpty((String)job.getCity())) {
                ++numberOfHits;
            }
            if (job.getCountry() != null) {
                ++numberOfHits;
            }
            if (job.getBusinessArea() != null) {
                ++numberOfHits;
            }
            if (job.getParentBusinessArea() != null) {
                ++numberOfHits;
            }
            if (!StringUtils.isEmpty((String)job.getPosition())) {
                ++numberOfHits;
            }
            if (job.getBeginDate() != null) {
                ++numberOfHits;
            }
            if (job.getEndDate() != null) {
                ++numberOfHits;
            }
            if (job.getJobApplicationType() != null) {
                ++numberOfHits;
            }
            if (job.getContractType() != null) {
                ++numberOfHits;
            }
            if (job.getSalary() != null) {
                ++numberOfHits;
            }
            completionPercentage += (double)numberOfHits / (double)totalNumber;
        }
        double totalCompletionPercentage = completionPercentage;
        if (!jobs.isEmpty()) {
            totalCompletionPercentage = completionPercentage / (double)jobs.size();
        }
        Math.ceil(totalCompletionPercentage *= 100.0);
        return totalCompletionPercentage;
    }
}

