/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.SeniorStatute;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.fenixedu.academic.dto.student.ManageStudentStatuteBean;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/studentStatutes", module="academicAdministration", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="manageStatutes", path="/academicAdminOffice/manageStatutes.jsp")})
public class StudentStatutesDA
extends FenixDispatchAction {
    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Student student = (Student)((Object)this.getDomainObject(request, "studentId"));
        request.setAttribute("student", (Object)student);
        request.setAttribute("manageStatuteBean", (Object)new CreateStudentStatuteFactory(student));
        request.setAttribute("schemaName", (Object)"student.createStatutes");
        return mapping.findForward("manageStatutes");
    }

    public ActionForward invalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Student student = (Student)FenixFramework.getDomainObject((String)request.getParameter("studentOID"));
        request.setAttribute("student", (Object)student);
        request.setAttribute("schemaName", (Object)request.getParameter("schemaName"));
        request.setAttribute("manageStatuteBean", this.getRenderedObject());
        return mapping.findForward("manageStatutes");
    }

    public ActionForward seniorStatutePostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        CreateStudentStatuteFactory oldManageStatuteBean = (CreateStudentStatuteFactory)this.getRenderedObject();
        Student student = oldManageStatuteBean.getStudent();
        StatuteType statuteType = oldManageStatuteBean.getStatuteType();
        CreateStudentStatuteFactory manageStatuteBean = new CreateStudentStatuteFactory(student);
        manageStatuteBean.setStatuteType(statuteType);
        RenderUtils.invalidateViewState();
        request.setAttribute("student", (Object)student);
        request.setAttribute("manageStatuteBean", (Object)manageStatuteBean);
        if (manageStatuteBean.getStatuteType().isSeniorStatute()) {
            request.setAttribute("schemaName", (Object)"student.createSeniorStatute");
        } else {
            request.setAttribute("schemaName", (Object)"student.createStatutes");
        }
        return mapping.findForward("manageStatutes");
    }

    public ActionForward addNewStatute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeFactoryMethod();
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
        }
        Student student = ((CreateStudentStatuteFactory)this.getRenderedObject()).getStudent();
        request.setAttribute("student", (Object)student);
        request.setAttribute("manageStatuteBean", (Object)new CreateStudentStatuteFactory(student));
        request.setAttribute("schemaName", (Object)"student.createStatutes");
        return mapping.findForward("manageStatutes");
    }

    public ActionForward deleteStatute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        StudentStatute studentStatute = (StudentStatute)((Object)this.getDomainObject(request, "statuteId"));
        Student student = studentStatute.getStudent();
        try {
            this.executeFactoryMethod(new DeleteStudentStatuteFactory(studentStatute));
        }
        catch (DomainException de) {
            this.addActionMessage(request, de.getMessage());
        }
        request.setAttribute("student", (Object)student);
        request.setAttribute("manageStatuteBean", (Object)new CreateStudentStatuteFactory(student));
        request.setAttribute("schemaName", (Object)"student.createStatutes");
        return mapping.findForward("manageStatutes");
    }

    public static class DeleteStudentStatuteFactory
    implements FactoryExecutor {
        StudentStatute studentStatute;

        public DeleteStudentStatuteFactory(StudentStatute studentStatute) {
            this.studentStatute = studentStatute;
        }

        @Override
        public Object execute() {
            this.studentStatute.delete();
            return true;
        }
    }

    public static class CreateStudentStatuteFactory
    extends ManageStudentStatuteBean
    implements FactoryExecutor {
        public CreateStudentStatuteFactory(Student student) {
            super(student);
        }

        @Override
        public Object execute() {
            if (this.getStatuteType().isSeniorStatute()) {
                return new SeniorStatute(this.getStudent(), this.getRegistration(), this.getStatuteType(), this.getBeginExecutionPeriod(), this.getEndExecutionPeriod(), this.getBeginDate(), this.getEndDate());
            }
            return new StudentStatute(this.getStudent(), this.getStatuteType(), this.getBeginExecutionPeriod(), this.getEndExecutionPeriod(), this.getBeginDate(), this.getEndDate());
        }
    }
}

