/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.dto.student.IStudentCurricularPlanBean;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ExecutionPeriodsForStudentCurricularPlanProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        StudentCurricularPlan studentCurricularPlan = ((IStudentCurricularPlanBean)source).getStudentCurricularPlan();
        List<ExecutionSemester> executionPeriodsInTimePeriod = ExecutionSemester.readExecutionPeriodsInTimePeriod(studentCurricularPlan.getStartDate(), this.getEndDate());
        Collections.sort(executionPeriodsInTimePeriod, new ReverseComparator(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR));
        return executionPeriodsInTimePeriod;
    }

    private Date getEndDate() {
        return ExecutionYear.readCurrentExecutionYear().getLastExecutionPeriod().getEndDate();
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

