/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.StudentOptionalEnrolmentBean;
import org.fenixedu.academic.ui.renderers.student.enrollment.bolonha.BolonhaStudentOptionalEnrollmentInputRenderer;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlActionLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlActionLinkController;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class DegreeCurricularPlanOptionalEnrolmentsRenderer
extends InputRenderer {
    private Integer initialWidth = 70;
    private Integer widthDecreasePerLevel = 3;
    private String tablesClasses = "showinfo3 mvert0";
    private String groupRowClasses = "bgcolor2";
    private String curricularCoursesToEnrol = "smalltxt, smalltxt aright, smalltxt aright, aright";
    private String methodName;

    public Integer getInitialWidth() {
        return this.initialWidth;
    }

    public void setInitialWidth(Integer initialWidth) {
        this.initialWidth = initialWidth;
    }

    public Integer getWidthDecreasePerLevel() {
        return this.widthDecreasePerLevel;
    }

    public void setWidthDecreasePerLevel(Integer widthDecreasePerLevel) {
        this.widthDecreasePerLevel = widthDecreasePerLevel;
    }

    public String getTablesClasses() {
        return this.tablesClasses;
    }

    public void setTablesClasses(String tablesClasses) {
        this.tablesClasses = tablesClasses;
    }

    public String getGroupRowClasses() {
        return this.groupRowClasses;
    }

    public void setGroupRowClasses(String groupRowClasses) {
        this.groupRowClasses = groupRowClasses;
    }

    private String[] getCurricularCourseClasses() {
        return this.curricularCoursesToEnrol.split(",");
    }

    public void setCurricularCourseClasses(String curricularCoursesToEnrol) {
        this.curricularCoursesToEnrol = curricularCoursesToEnrol;
    }

    private String getCurricularCourseNameClasses() {
        return this.getCurricularCourseClasses()[0];
    }

    private String getCurricularCourseYearClasses() {
        return this.getCurricularCourseClasses()[1];
    }

    private String getCurricularCourseEctsClasses() {
        return this.getCurricularCourseClasses()[2];
    }

    private String getCurricularCourseLinkClasses() {
        return this.getCurricularCourseClasses()[3];
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    protected Layout getLayout(Object object, Class type) {
        return new DegreeCurricularPlanOptionalEnrolmentsLayout();
    }

    private static class UpdateSelectedCurricularCourseController
    extends HtmlActionLinkController {
        private static final long serialVersionUID = 1L;
        private final CurricularCourse curricularCourse;

        public UpdateSelectedCurricularCourseController(CurricularCourse curricularCourse) {
            this.curricularCourse = curricularCourse;
        }

        protected boolean isToSkipUpdate() {
            return false;
        }

        public void linkPressed(IViewState viewState, HtmlActionLink link) {
            ((StudentOptionalEnrolmentBean)viewState.getMetaObject().getObject()).setSelectedCurricularCourse(this.curricularCourse);
        }
    }

    private class DegreeCurricularPlanOptionalEnrolmentsLayout
    extends Layout {
        private StudentOptionalEnrolmentBean studentOptionalEnrolmentBean = null;

        private DegreeCurricularPlanOptionalEnrolmentsLayout() {
        }

        public HtmlComponent createComponent(Object object, Class type) {
            this.studentOptionalEnrolmentBean = (StudentOptionalEnrolmentBean)object;
            HtmlBlockContainer container = new HtmlBlockContainer();
            if (this.studentOptionalEnrolmentBean == null) {
                return new HtmlText();
            }
            this.generateCourseGroup(container, (CourseGroup)((Object)this.studentOptionalEnrolmentBean.getDegreeCurricularPlan().getRoot()), 0);
            return container;
        }

        private void generateCourseGroup(HtmlBlockContainer blockContainer, CourseGroup courseGroup, int depth) {
            HtmlTable groupTable = new HtmlTable();
            blockContainer.addChild((HtmlComponent)groupTable);
            groupTable.setClasses(DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getTablesClasses());
            groupTable.setStyle("width: " + (DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getInitialWidth() - depth) + "em; margin-left: " + depth + "em;");
            HtmlTableRow htmlTableRow = groupTable.createRow();
            htmlTableRow.setClasses(DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getGroupRowClasses());
            htmlTableRow.createCell().setBody((HtmlComponent)new HtmlText(courseGroup.getName()));
            List<Context> childCourseGroupContexts = courseGroup.getValidChildContexts(CourseGroup.class, this.getExecutionSemester());
            List<Context> childCurricularCourseContexts = courseGroup.getValidChildContexts(CurricularCourse.class, this.getExecutionSemester());
            Collections.sort(childCourseGroupContexts);
            Collections.sort(childCurricularCourseContexts);
            this.generateCurricularCourses(blockContainer, childCurricularCourseContexts, depth + DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getWidthDecreasePerLevel());
            for (Context context : childCourseGroupContexts) {
                this.generateCourseGroup(blockContainer, (CourseGroup)((Object)context.getChildDegreeModule()), depth + DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getWidthDecreasePerLevel());
            }
        }

        private ExecutionSemester getExecutionSemester() {
            return this.studentOptionalEnrolmentBean.getExecutionPeriod();
        }

        private void generateCurricularCourses(HtmlBlockContainer blockContainer, List<Context> contexts, int depth) {
            HtmlTable table = new HtmlTable();
            blockContainer.addChild((HtmlComponent)table);
            table.setClasses(DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getTablesClasses());
            table.setStyle("width: " + (DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getInitialWidth() - depth) + "em; margin-left: " + depth + "em;");
            for (Context context : contexts) {
                CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
                if (curricularCourse.isOptionalCurricularCourse()) continue;
                HtmlTableRow htmlTableRow = table.createRow();
                HtmlTableCell cellName = htmlTableRow.createCell();
                cellName.setClasses(DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getCurricularCourseNameClasses());
                cellName.setBody((HtmlComponent)BolonhaStudentOptionalEnrollmentInputRenderer.generateCurricularCourseNameComponent(curricularCourse, this.studentOptionalEnrolmentBean.getExecutionPeriod()));
                HtmlTableCell yearCell = htmlTableRow.createCell();
                yearCell.setClasses(DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getCurricularCourseYearClasses());
                yearCell.setBody((HtmlComponent)new HtmlText(context.getCurricularPeriod().getFullLabel()));
                HtmlTableCell ectsCell = htmlTableRow.createCell();
                ectsCell.setClasses(DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getCurricularCourseEctsClasses());
                StringBuilder ects = new StringBuilder();
                ects.append(curricularCourse.getEctsCredits(this.getExecutionSemester())).append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"credits.abbreviation", (String[])new String[0]));
                ectsCell.setBody((HtmlComponent)new HtmlText(ects.toString()));
                HtmlTableCell linkTableCell = htmlTableRow.createCell();
                linkTableCell.setClasses(DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getCurricularCourseLinkClasses());
                HtmlActionLink actionLink = new HtmlActionLink();
                actionLink.setText(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"link.option.enrol.curricular.course", (String[])new String[0]));
                actionLink.setName("curricularCourseEnrolLink" + curricularCourse.getExternalId());
                actionLink.setOnClick(String.format("$(this).closest('form').find('input[name=\\'method\\']').attr('value', '%s');", DegreeCurricularPlanOptionalEnrolmentsRenderer.this.getMethodName()));
                actionLink.setController((HtmlController)new UpdateSelectedCurricularCourseController(curricularCourse));
                linkTableCell.setBody((HtmlComponent)actionLink);
            }
        }
    }
}

