/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components.util;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;

public class JsfRenderUtils {
    public static void addEventHandlingHiddenFieldsIfNotExists(FacesContext context, UIComponent component) throws IOException {
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        UIForm parentForm = JsfRenderUtils.findForm(component);
        String parentFormClientId = parentForm.getClientId(context);
        String eventSenderHiddenFieldFinalId = JsfRenderUtils.getEventSenderHiddenFieldId(parentFormClientId);
        String eventSenderHiddenFieldRenderedAttribute = JsfRenderUtils.getEventSenderHiddenFieldRenderedAttributeName(parentFormClientId);
        String eventArgumentHiddenFieldFinalId = JsfRenderUtils.getEventArgumentHiddenFieldId(parentFormClientId);
        String eventArgumentHiddenFieldRenderedAttribute = JsfRenderUtils.getEventArgumentHiddenFieldRenderedAttributeName(parentFormClientId);
        ResponseWriter writer = context.getResponseWriter();
        if (request.getAttribute(eventSenderHiddenFieldRenderedAttribute) == null) {
            JsfRenderUtils.renderEmptyHiddenField(eventSenderHiddenFieldFinalId, writer);
            request.setAttribute(eventSenderHiddenFieldRenderedAttribute, (Object)true);
        }
        if (request.getAttribute(eventArgumentHiddenFieldRenderedAttribute) == null) {
            JsfRenderUtils.renderEmptyHiddenField(eventArgumentHiddenFieldFinalId, writer);
            request.setAttribute(eventArgumentHiddenFieldRenderedAttribute, (Object)true);
        }
    }

    private static void renderEmptyHiddenField(String clientId, ResponseWriter writer) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("value", (Object)"", null);
        writer.endElement("input");
    }

    public static String getEventSenderHiddenFieldId(String formClientId) {
        String eventSenderHiddenFieldFinalId = formClientId + "__FENIX_EVENT_SENDER_HIDDEN_FIELD";
        return eventSenderHiddenFieldFinalId;
    }

    public static String getEventArgumentHiddenFieldId(String formClientId) {
        String eventArgumentHiddenFieldFinalId = formClientId + "__FENIX_EVENT_ARGUMENT_HIDDEN_FIELD";
        return eventArgumentHiddenFieldFinalId;
    }

    public static String getEventSenderHiddenFieldRenderedAttributeName(String formClientId) {
        String eventSenderHiddenFieldRenderedAttributeName = formClientId + "__FENIX_EVENT_SENDER_HIDDEN_FIELD_RENDERED";
        return eventSenderHiddenFieldRenderedAttributeName;
    }

    public static String getEventArgumentHiddenFieldRenderedAttributeName(String formClientId) {
        String eventArgumentHiddenFieldRenderedAttributeName = formClientId + "__FENIX_EVENT_ARGUMENT_HIDDEN_FIELD_RENDERED";
        return eventArgumentHiddenFieldRenderedAttributeName;
    }

    public static UIForm findForm(UIComponent component) {
        UIComponent formCandidate;
        for (formCandidate = component.getParent(); formCandidate != null && !(formCandidate instanceof UIForm); formCandidate = formCandidate.getParent()) {
        }
        return (UIForm)formCandidate;
    }

    public static String getSubmitJavaScript(FacesContext context, UIComponent component) {
        UIForm parentForm = JsfRenderUtils.findForm(component);
        String parentFormClientId = parentForm.getClientId(context);
        String componentClientId = component.getClientId(context);
        String eventSenderHiddenFieldId = JsfRenderUtils.getEventSenderHiddenFieldId(parentFormClientId);
        StringBuilder onClickEvent = new StringBuilder();
        onClickEvent.append("document.forms['").append(parentFormClientId).append("'].elements['");
        onClickEvent.append(eventSenderHiddenFieldId).append("'].value='").append(componentClientId);
        onClickEvent.append("';document.forms['").append(parentFormClientId).append("'].submit();");
        return onClickEvent.toString();
    }

    public static String getSubmitJavaScriptWithArgument(FacesContext context, UIComponent component, String eventArgument) {
        UIForm parentForm = JsfRenderUtils.findForm(component);
        String parentFormClientId = parentForm.getClientId(context);
        String componentClientId = component.getClientId(context);
        String eventSenderHiddenFieldId = JsfRenderUtils.getEventSenderHiddenFieldId(parentFormClientId);
        String eventArgumentHiddenFieldId = JsfRenderUtils.getEventArgumentHiddenFieldId(parentFormClientId);
        StringBuilder onClickEvent = new StringBuilder();
        onClickEvent.append("document.forms['").append(parentFormClientId).append("'].elements['");
        onClickEvent.append(eventSenderHiddenFieldId).append("'].value='").append(componentClientId).append("';");
        onClickEvent.append("document.forms['").append(parentFormClientId).append("'].elements['");
        onClickEvent.append(eventArgumentHiddenFieldId).append("'].value='").append(eventArgument).append("';");
        onClickEvent.append("document.forms['").append(parentFormClientId).append("'].submit();");
        return onClickEvent.toString();
    }

    public static String getSubmitJavaScriptWithParameters(FacesContext context, UIComponent component, List<UIParameter> uiParameterList) {
        UIForm parentForm = JsfRenderUtils.findForm(component);
        String parentFormClientId = parentForm.getClientId(context);
        String componentClientId = component.getClientId(context);
        String eventSenderHiddenFieldId = JsfRenderUtils.getEventSenderHiddenFieldId(parentFormClientId);
        StringBuilder setParametersJavaScript = new StringBuilder();
        for (int i = 0; i < uiParameterList.size(); ++i) {
            UIParameter parameter = uiParameterList.get(i);
            setParametersJavaScript.append("document.forms['").append(parentFormClientId).append("'].elements['").append(parameter.getName()).append("'].value='").append(parameter.getValue()).append("';");
        }
        StringBuilder onClickEvent = new StringBuilder();
        onClickEvent.append("document.forms['").append(parentFormClientId).append("'].elements['");
        onClickEvent.append(eventSenderHiddenFieldId).append("'].value='").append(componentClientId).append("';");
        onClickEvent.append(setParametersJavaScript.toString());
        onClickEvent.append("document.forms['").append(parentFormClientId).append("'].submit();");
        return onClickEvent.toString();
    }

    private static void addHiddenFieldForParameterIfNotExists(String parentFormClientId, HttpServletRequest request, ResponseWriter writer, String parameterName) throws IOException {
        String renderedAttribute = parentFormClientId + parameterName + "__FENIX_PARAMETER";
        if (request.getAttribute(renderedAttribute) == null) {
            JsfRenderUtils.renderEmptyHiddenField(parameterName, writer);
            request.setAttribute(renderedAttribute, (Object)true);
        }
    }

    public static void addHiddenFieldsForParametersIfNotExists(FacesContext context, UIComponent parentComponent, List<UIParameter> uiParameters) throws IOException {
        UIForm parentForm = JsfRenderUtils.findForm(parentComponent);
        String parentFormClientId = parentForm.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        for (int i = 0; i < uiParameters.size(); ++i) {
            UIParameter parameter = uiParameters.get(i);
            JsfRenderUtils.addHiddenFieldForParameterIfNotExists(parentFormClientId, request, writer, parameter.getName());
        }
    }

    public static String getClearEventSenderFieldJavaScript(FacesContext context, UIComponent component) {
        UIForm parentForm = JsfRenderUtils.findForm(component);
        String parentFormClientId = parentForm.getClientId(context);
        String eventSenderHiddenFieldId = JsfRenderUtils.getEventSenderHiddenFieldId(parentFormClientId);
        StringBuilder clearEventSenderFieldJavaScript = new StringBuilder();
        clearEventSenderFieldJavaScript.append("document.forms['").append(parentFormClientId).append("'].elements['").append(eventSenderHiddenFieldId).append("'].value='';");
        return clearEventSenderFieldJavaScript.toString();
    }
}

