/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.scientificCouncil.curricularPlans;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.CreateDegree$callable$run;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateDegree {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(String string, String string2, String string3, DegreeType degreeType, Double d, GradeScale gradeScale, String string4, AdministrativeOffice administrativeOffice) throws FenixServiceException {
        Object object = advice$run.perform((Callable)new CreateDegree$callable$run(string, string2, string3, degreeType, d, gradeScale, string4, administrativeOffice));
    }

    static /* synthetic */ void advised$run(String name, String nameEn, String acronym, DegreeType degreeType, Double ectsCredits, GradeScale gradeScale, String prevailingScientificArea, AdministrativeOffice administrativeOffice) throws FenixServiceException {
        AccessControl.check(RolePredicates.SCIENTIFIC_COUNCIL_PREDICATE);
        if (name == null || nameEn == null || acronym == null || degreeType == null || ectsCredits == null) {
            throw new InvalidArgumentsServiceException();
        }
        List<Degree> degrees = Degree.readNotEmptyDegrees();
        for (Degree degree : degrees) {
            if (degree.getSigla().equalsIgnoreCase(acronym)) {
                throw new FenixServiceException("error.existing.degree.acronym");
            }
            ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
            if (!degree.getNameFor(currentExecutionYear).getContent(MultiLanguageString.pt).equalsIgnoreCase(name) && !degree.getNameFor(currentExecutionYear).getContent(MultiLanguageString.en).equalsIgnoreCase(nameEn) || !degree.getDegreeType().equals(degreeType)) continue;
            throw new FenixServiceException("error.existing.degree.name.and.type");
        }
        Degree degree = new Degree(name, nameEn, acronym, degreeType, ectsCredits, gradeScale, prevailingScientificArea, administrativeOffice);
        Signal.emit((String)"academic.degree.create", (Object)new DomainObjectEvent((DomainObject)degree));
    }
}

