/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.teacher.executionCourse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionCourseLog;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.util.Month;
import org.fenixedu.academic.util.predicates.AndPredicate;
import org.fenixedu.academic.util.predicates.InlinePredicate;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class SearchExecutionCourseLogBean
implements Serializable {
    private ExecutionCourse executionCourse;
    private Boolean viewPhoto;
    private Collection<Month> months;
    private Collection<Professorship> professorships;
    private Collection<ExecutionCourseLog.ExecutionCourseLogTypes> executionCourseLogsTypes;
    private Collection<ExecutionCourseLog> executionCourseLogs;

    public String getEnumerationResourcesString(String name) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)name, (String[])new String[0]);
    }

    public String getApplicationResourcesString(String name) {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)name, (String[])new String[0]);
    }

    public SearchExecutionCourseLogBean(ExecutionCourse executionCourse) {
        this.setExecutionCourse(executionCourse);
        this.setViewPhoto(true);
        this.setProfessorships(this.getExecutionCourse().getProfessorshipsSet());
        this.setExecutionCourseLogTypes(ExecutionCourseLog.ExecutionCourseLogTypes.valuesAsList());
        this.setMonths(executionCourse.getExecutionPeriod().getSemesterMonths());
        this.executionCourseLogs = new ArrayList<ExecutionCourseLog>();
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourse;
    }

    public void setExecutionCourse(ExecutionCourse executionCourse) {
        this.executionCourse = executionCourse;
    }

    public Boolean getViewPhoto() {
        return this.viewPhoto;
    }

    public void setViewPhoto(Boolean viewPhoto) {
        this.viewPhoto = viewPhoto;
    }

    public Collection<ExecutionCourseLog.ExecutionCourseLogTypes> getExecutionCourseLogTypes() {
        return this.executionCourseLogsTypes;
    }

    public Collection<ExecutionCourseLog.ExecutionCourseLogTypes> getExecutionCourseLogTypesAll() {
        return ExecutionCourseLog.ExecutionCourseLogTypes.valuesAsList();
    }

    public void setExecutionCourseLogTypes(Collection<ExecutionCourseLog.ExecutionCourseLogTypes> executionCourseLogsTypes) {
        this.executionCourseLogsTypes = executionCourseLogsTypes;
    }

    public Collection<Professorship> getProfessorships() {
        ArrayList<Professorship> pfs = new ArrayList<Professorship>();
        for (Professorship professorship : this.professorships) {
            pfs.add(professorship);
        }
        return pfs;
    }

    public void setProfessorships(Collection<Professorship> professorships) {
        ArrayList<Professorship> pfs = new ArrayList<Professorship>();
        for (Professorship pf : professorships) {
            pfs.add(pf);
        }
        this.professorships = pfs;
    }

    public Collection<ExecutionCourseLog> getExecutionCourseLogs() {
        ArrayList<ExecutionCourseLog> eclogs = new ArrayList<ExecutionCourseLog>();
        for (ExecutionCourseLog executionCourseLog : this.executionCourseLogs) {
            eclogs.add(executionCourseLog);
        }
        return eclogs;
    }

    public void setExecutionCourseLogs(Collection<ExecutionCourseLog> executionCourseLogs) {
        ArrayList<ExecutionCourseLog> eclogs = new ArrayList<ExecutionCourseLog>();
        for (ExecutionCourseLog eclog : executionCourseLogs) {
            eclogs.add(eclog);
        }
        this.executionCourseLogs = eclogs;
    }

    public Collection<Month> getMonths() {
        ArrayList<Month> mon = new ArrayList<Month>();
        for (Month month : this.months) {
            mon.add(month);
        }
        return mon;
    }

    public void setMonths(Collection<Month> months) {
        ArrayList<Month> mon = new ArrayList<Month>();
        for (Month mth : months) {
            mon.add(mth);
        }
        this.months = mon;
    }

    public Predicate<ExecutionCourseLog> getFilters() {
        ArrayList filters = new ArrayList();
        if (this.getExecutionCourseLogTypes().size() < ExecutionCourseLog.ExecutionCourseLogTypes.values().length) {
            filters.add(new InlinePredicate<ExecutionCourseLog, Collection<ExecutionCourseLog.ExecutionCourseLogTypes>>(this.getExecutionCourseLogTypes()){

                @Override
                public boolean test(ExecutionCourseLog executionCourseLog) {
                    return ((Collection)this.getValue()).contains((Object)executionCourseLog.getExecutionCourseLogType());
                }
            });
        }
        if (this.months.size() < this.getExecutionCourse().getExecutionPeriod().getSemesterMonths().size()) {
            filters.add(new InlinePredicate<ExecutionCourseLog, Collection<Month>>(this.getMonths()){

                @Override
                public boolean test(ExecutionCourseLog executionCourseLog) {
                    for (Month month : (Collection)this.getValue()) {
                        if (month.getNumberOfMonth() != executionCourseLog.getWhenDateTime().getMonthOfYear()) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        if (this.professorships.size() < this.getExecutionCourse().getProfessorshipsSet().size()) {
            filters.add(new InlinePredicate<ExecutionCourseLog, Collection<Professorship>>(this.getProfessorships()){

                @Override
                public boolean test(ExecutionCourseLog executionCourseLog) {
                    for (Professorship pf : (Collection)this.getValue()) {
                        if (pf.getPerson().getOid() != executionCourseLog.getPerson().getOid()) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        return new AndPredicate<ExecutionCourseLog>(filters);
    }

    public String getLabel() {
        String logTypeValues = "";
        String professorshipNameValues = "";
        String monthsValues = "";
        for (ExecutionCourseLog.ExecutionCourseLogTypes logType : ExecutionCourseLog.ExecutionCourseLogTypes.values()) {
            if (!logTypeValues.isEmpty()) {
                logTypeValues = logTypeValues + ", ";
            }
            logTypeValues = logTypeValues + this.getEnumerationResourcesString(logType.getQualifiedName());
        }
        for (Professorship prof : this.professorships) {
            if (!professorshipNameValues.isEmpty()) {
                professorshipNameValues = professorshipNameValues + ", ";
            }
            professorshipNameValues = professorshipNameValues + prof.getPerson().getPresentationName();
        }
        for (Month month : this.months) {
            if (!monthsValues.isEmpty()) {
                monthsValues = monthsValues + ", ";
            }
            monthsValues = monthsValues + this.getEnumerationResourcesString(month.getName());
        }
        return String.format("%s : %s \n%s : %s \n%s : %s", this.getApplicationResourcesString("log.label.selectLogType"), logTypeValues, this.getApplicationResourcesString("log.label.selectProfessorship"), professorshipNameValues, this.getApplicationResourcesString("log.label.selectMonth"), monthsValues);
    }

    public String getSearchElementsAsParameters() {
        String parameters = "";
        parameters = parameters + "&amp;executionCourse=" + this.getExecutionCourse().getExternalId();
        if (this.viewPhoto.booleanValue()) {
            parameters = parameters + "&amp;viewPhoto=true";
        }
        if (this.getExecutionCourseLogTypes() != null && !this.getExecutionCourseLogTypes().isEmpty()) {
            parameters = parameters + "&amp;executionCourseLogTypes=";
            for (ExecutionCourseLog.ExecutionCourseLogTypes logType : this.getExecutionCourseLogTypes()) {
                parameters = parameters + logType.toString() + ":";
            }
        }
        if (this.getProfessorships() != null && !this.getProfessorships().isEmpty()) {
            parameters = parameters + "&amp;professorships=";
            for (Professorship professorship : this.getProfessorships()) {
                parameters = parameters + professorship.getExternalId() + ":";
            }
        }
        if (this.getMonths() != null && !this.getMonths().isEmpty()) {
            parameters = parameters + "&amp;months=";
            for (Month month : this.getMonths()) {
                parameters = parameters + month.getNumberOfMonth() + ":";
            }
        }
        return parameters;
    }
}

