/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student.enrollment.bolonha;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.dto.student.enrollment.bolonha.NoCourseGroupEnroledCurriculumModuleWrapper;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumEnrolmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumGroupBean;
import org.fenixedu.academic.util.predicates.InlinePredicate;
import org.fenixedu.bennu.core.security.Authenticate;

public class SpecialSeasonStudentCurriculumGroupBean
extends StudentCurriculumGroupBean {
    private static final long serialVersionUID = 8504847305104217989L;

    public SpecialSeasonStudentCurriculumGroupBean(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester) {
        super(curriculumGroup, executionSemester, null);
    }

    @Override
    protected List<IDegreeModuleToEvaluate> buildCourseGroupsToEnrol(CurriculumGroup group, ExecutionSemester executionSemester) {
        return Collections.emptyList();
    }

    @Override
    protected List<StudentCurriculumEnrolmentBean> buildCurricularCoursesEnroled(CurriculumGroup group, ExecutionSemester executionSemester) {
        ArrayList<StudentCurriculumEnrolmentBean> result = new ArrayList<StudentCurriculumEnrolmentBean>();
        for (CurriculumModule curriculumModule : group.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumModule)).isSpecialSeasonEnroled(executionSemester)) continue;
            result.add(new StudentCurriculumEnrolmentBean(enrolment));
        }
        return result;
    }

    @Override
    protected List<IDegreeModuleToEvaluate> buildCurricularCoursesToEnrol(CurriculumGroup group, ExecutionSemester executionSemester) {
        Collection<Enrolment> specialSeasonEnrolments = group.getSpecialSeasonEnrolments(executionSemester);
        InlinePredicate<Enrolment, Collection<Enrolment>> alreadyHasSpecialSeasonEnrolment = new InlinePredicate<Enrolment, Collection<Enrolment>>(specialSeasonEnrolments){

            @Override
            public boolean test(Enrolment enrolment) {
                for (Enrolment specialSeasonEnrolment : (Collection)this.getValue()) {
                    if (!specialSeasonEnrolment.getDegreeModule().equals((Object)enrolment.getDegreeModule())) continue;
                    return true;
                }
                return false;
            }
        };
        HashMap<CurricularCourse, Enrolment> enrolmentsMap = new HashMap<CurricularCourse, Enrolment>();
        boolean isServices = AcademicAuthorizationGroup.get(AcademicOperationType.STUDENT_ENROLMENTS).isMember(Authenticate.getUser());
        for (CurriculumModule curriculumModule : group.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || !this.considerThisEnrolmentGeneralRule(enrolment = (Enrolment)((Object)curriculumModule), executionSemester, (Predicate<Enrolment>)alreadyHasSpecialSeasonEnrolment) || !this.considerThisEnrolmentNormalEnrolments(enrolment) && !this.considerThisEnrolmentPropaedeuticEnrolments(enrolment, isServices) && !this.considerThisEnrolmentExtraCurricularEnrolments(enrolment, isServices) && !this.considerThisEnrolmentStandaloneEnrolments(enrolment, isServices)) continue;
            if (enrolmentsMap.get((Object)enrolment.getCurricularCourse()) != null) {
                Enrolment enrolmentMap = (Enrolment)enrolmentsMap.get((Object)enrolment.getCurricularCourse());
                if (!enrolment.getExecutionPeriod().isAfter(enrolmentMap.getExecutionPeriod())) continue;
                enrolmentsMap.put(enrolment.getCurricularCourse(), enrolment);
                continue;
            }
            enrolmentsMap.put(enrolment.getCurricularCourse(), enrolment);
        }
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>();
        for (Enrolment enrolment : enrolmentsMap.values()) {
            if (enrolment.parentCurriculumGroupIsNoCourseGroupCurriculumGroup()) {
                result.add(new NoCourseGroupEnroledCurriculumModuleWrapper((CurriculumModule)((Object)enrolment), enrolment.getExecutionPeriod()));
                continue;
            }
            result.add(new EnroledCurriculumModuleWrapper((CurriculumModule)((Object)enrolment), enrolment.getExecutionPeriod()));
        }
        return result;
    }

    @Override
    protected List<StudentCurriculumGroupBean> buildCurriculumGroupsEnroled(CurriculumGroup parentGroup, ExecutionSemester executionSemester, int[] curricularYears) {
        ArrayList<StudentCurriculumGroupBean> result = new ArrayList<StudentCurriculumGroupBean>();
        for (CurriculumGroup curriculumGroup : parentGroup.getCurriculumGroupsToEnrolmentProcess()) {
            result.add(new SpecialSeasonStudentCurriculumGroupBean(curriculumGroup, executionSemester));
        }
        if (!parentGroup.isNoCourseGroupCurriculumGroup()) {
            for (NoCourseGroupCurriculumGroup noCourseGroupCurriculumGroup : parentGroup.getNoCourseGroupCurriculumGroups()) {
                if (!noCourseGroupCurriculumGroup.isVisible()) continue;
                result.add(new SpecialSeasonStudentCurriculumGroupBean((CurriculumGroup)((Object)noCourseGroupCurriculumGroup), executionSemester));
            }
        }
        return result;
    }

    @Override
    public List<IDegreeModuleToEvaluate> getSortedDegreeModulesToEvaluate() {
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>(this.getCurricularCoursesToEnrol());
        Collections.sort(result, IDegreeModuleToEvaluate.COMPARATOR_BY_EXECUTION_PERIOD);
        return result;
    }

    @Override
    public boolean isToBeDisabled() {
        return true;
    }

    private boolean considerThisEnrolmentGeneralRule(Enrolment enrolment, ExecutionSemester executionSemester, Predicate<Enrolment> alreadyHasSpecialSeasonEnrolment) {
        return enrolment.canBeSpecialSeasonEnroled(executionSemester) && !alreadyHasSpecialSeasonEnrolment.test(enrolment);
    }

    private boolean considerThisEnrolmentNormalEnrolments(Enrolment enrolment) {
        if (enrolment.isBolonhaDegree() && !enrolment.isExtraCurricular() && !enrolment.isPropaedeutic() && !enrolment.isStandalone() && enrolment.getParentCycleCurriculumGroup().isConclusionProcessed()) {
            return false;
        }
        return !enrolment.parentCurriculumGroupIsNoCourseGroupCurriculumGroup() || enrolment.isPropaedeutic();
    }

    private boolean considerThisEnrolmentPropaedeuticEnrolments(Enrolment enrolment, boolean isServices) {
        return enrolment.isPropaedeutic() && isServices;
    }

    private boolean considerThisEnrolmentExtraCurricularEnrolments(Enrolment enrolment, boolean isServices) {
        return enrolment.isExtraCurricular() && isServices;
    }

    private boolean considerThisEnrolmentStandaloneEnrolments(Enrolment enrolment, boolean isServices) {
        return enrolment.isStandalone() && isServices;
    }
}

