/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.phd.student;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.enrolment.DegreeModuleToEnrol;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumGroupBean;

public class PhdStudentCurriculumGroupBean
extends StudentCurriculumGroupBean {
    private static final long serialVersionUID = 1L;

    public PhdStudentCurriculumGroupBean(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester, int[] curricularYears) {
        super(curriculumGroup, executionSemester, curricularYears);
    }

    @Override
    protected List<IDegreeModuleToEvaluate> buildCurricularCoursesToEnrol(CurriculumGroup group, ExecutionSemester semester) {
        Collection<CompetenceCourse> collection = this.getCompetenceCoursesAvailableToEnrol();
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>();
        for (Context context : group.getCurricularCourseContextsToEnrol(semester)) {
            if (!this.canBeUsed(collection, context)) continue;
            result.add(new DegreeModuleToEnrol(group, context, semester));
        }
        return result;
    }

    private boolean canBeUsed(Collection<CompetenceCourse> collection, Context context) {
        CurricularCourse course = (CurricularCourse)((Object)context.getChildDegreeModule());
        return course.isOptionalCurricularCourse() || course.getCompetenceCourse() != null && collection.contains((Object)course.getCompetenceCourse());
    }

    private Collection<CompetenceCourse> getCompetenceCoursesAvailableToEnrol() {
        return this.getRegistration().getPhdIndividualProgramProcess().getCompetenceCoursesAvailableToEnrol();
    }

    @Override
    protected List<IDegreeModuleToEvaluate> buildCurricularCoursesToEnrol(CurriculumGroup group, ExecutionSemester executionSemester, int[] curricularYears) {
        throw new DomainException("error.PhdStudentCurriculumGroupBean.unexpected.invocation", new String[0]);
    }

    @Override
    protected StudentCurriculumGroupBean createEnroledCurriculumGroupBean(ExecutionSemester executionSemester, int[] curricularYears, CurriculumGroup curriculumGroup) {
        return new PhdStudentCurriculumGroupBean(curriculumGroup, executionSemester, curricularYears);
    }
}

