/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.BranchCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.BranchCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.ExternalCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup;

public class CurriculumGroupFactory {
    public static RootCurriculumGroup createRoot(StudentCurricularPlan studentCurricularPlan, RootCourseGroup rootCourseGroup, CycleType cycleType) {
        return CurriculumGroupFactory.createRoot(studentCurricularPlan, rootCourseGroup, null, cycleType);
    }

    public static RootCurriculumGroup createRoot(StudentCurricularPlan studentCurricularPlan, RootCourseGroup rootCourseGroup, ExecutionSemester executionSemester, CycleType cycleType) {
        return executionSemester != null ? new RootCurriculumGroup(studentCurricularPlan, rootCourseGroup, executionSemester, cycleType) : new RootCurriculumGroup(studentCurricularPlan, rootCourseGroup, cycleType);
    }

    public static CurriculumGroup createGroup(CurriculumGroup parentGroup, CourseGroup courseGroup) {
        return CurriculumGroupFactory.createGroup(parentGroup, courseGroup, null);
    }

    public static CurriculumGroup createGroup(CurriculumGroup parentGroup, CourseGroup courseGroup, ExecutionSemester executionSemester) {
        if (courseGroup.isCycleCourseGroup()) {
            CycleCourseGroup cycleCourseGroup = (CycleCourseGroup)((Object)courseGroup);
            if (CurriculumGroupFactory.isExternalCycle(parentGroup, cycleCourseGroup)) {
                return executionSemester != null ? new ExternalCurriculumGroup((RootCurriculumGroup)((Object)parentGroup), cycleCourseGroup, executionSemester) : new ExternalCurriculumGroup((RootCurriculumGroup)((Object)parentGroup), cycleCourseGroup);
            }
            return executionSemester != null ? new CycleCurriculumGroup((RootCurriculumGroup)((Object)parentGroup), (CycleCourseGroup)((Object)courseGroup), executionSemester) : new CycleCurriculumGroup((RootCurriculumGroup)((Object)parentGroup), (CycleCourseGroup)((Object)courseGroup));
        }
        if (courseGroup.isBranchCourseGroup()) {
            return executionSemester != null ? new BranchCurriculumGroup(parentGroup, (BranchCourseGroup)((Object)courseGroup), executionSemester) : new BranchCurriculumGroup(parentGroup, (BranchCourseGroup)((Object)courseGroup));
        }
        if (courseGroup.isRoot()) {
            throw new DomainException("error.CurriculumGroupFactory.use.create.root.method", new String[0]);
        }
        return executionSemester != null ? new CurriculumGroup(parentGroup, courseGroup, executionSemester) : new CurriculumGroup(parentGroup, courseGroup);
    }

    private static boolean isExternalCycle(CurriculumGroup parentGroup, CycleCourseGroup courseGroup) {
        return !parentGroup.getRootCurriculumGroup().getDegreeModule().hasDegreeModule((DegreeModule)((Object)courseGroup));
    }
}

