/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Equivalence;
import org.fenixedu.academic.domain.studentCurriculum.InternalSubstitution;
import org.fenixedu.academic.domain.studentCurriculum.Substitution;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.DismissalBean;

public class CreditsManager {
    public static Equivalence createEquivalence(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, CurriculumGroup curriculumGroup, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, Double givenCredits, Grade givenGrade, ExecutionSemester executionSemester) {
        if (courseGroup != null) {
            return new Equivalence(studentCurricularPlan, courseGroup, enrolments, CreditsManager.buildNoEnrolCurricularCourses(dismissals), givenCredits, givenGrade, executionSemester);
        }
        if (curriculumGroup != null) {
            return new Equivalence(studentCurricularPlan, curriculumGroup, enrolments, givenCredits, givenGrade, executionSemester);
        }
        return new Equivalence(studentCurricularPlan, dismissals, enrolments, givenGrade, executionSemester);
    }

    public static Substitution createSubstitution(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, CurriculumGroup curriculumGroup, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, Double givenCredits, ExecutionSemester executionSemester) {
        if (courseGroup != null) {
            return new Substitution(studentCurricularPlan, courseGroup, enrolments, CreditsManager.buildNoEnrolCurricularCourses(dismissals), givenCredits, executionSemester);
        }
        if (curriculumGroup != null) {
            return new Substitution(studentCurricularPlan, curriculumGroup, enrolments, givenCredits, executionSemester);
        }
        return new Substitution(studentCurricularPlan, dismissals, enrolments, executionSemester);
    }

    public static InternalSubstitution createInternalSubstitution(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, CurriculumGroup curriculumGroup, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, Double givenCredits, ExecutionSemester executionSemester) {
        if (courseGroup != null) {
            return new InternalSubstitution(studentCurricularPlan, courseGroup, enrolments, CreditsManager.buildNoEnrolCurricularCourses(dismissals), givenCredits, executionSemester);
        }
        if (curriculumGroup != null) {
            return new InternalSubstitution(studentCurricularPlan, curriculumGroup, enrolments, givenCredits, executionSemester);
        }
        return new InternalSubstitution(studentCurricularPlan, dismissals, enrolments, executionSemester);
    }

    private static Collection<CurricularCourse> buildNoEnrolCurricularCourses(Collection<DismissalBean.SelectedCurricularCourse> dismissals) {
        if (dismissals == null || dismissals.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CurricularCourse> noEnrolCurricularCourse = new ArrayList<CurricularCourse>(dismissals.size());
        for (DismissalBean.SelectedCurricularCourse selectedCurricularCourse : dismissals) {
            noEnrolCurricularCourse.add(selectedCurricularCourse.getCurricularCourse());
        }
        return noEnrolCurricularCourse;
    }
}

