/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.bennu.core.domain.User;

public class SubmitThesis
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (!process2.isJuryValidated()) {
            throw new PreConditionNotValidException();
        }
        if (!process2.hasState(PhdThesisProcessStateType.THESIS_DISCUSSION_DATE_SCHECULED)) {
            throw new PreConditionNotValidException();
        }
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        for (PhdProgramDocumentUploadBean each : bean.getDocuments()) {
            if (!each.hasAnyInformation()) continue;
            process2.addDocument(each, userView.getPerson());
            PhdProgram phdProgram = process2.getIndividualProgramProcess().getPhdProgram();
            if (phdProgram.getDegree() == null) continue;
            if (!this.isThesisFinalDocument(each)) {
                throw new DomainException("error.SubmitThesis.unexpected.document", new String[0]);
            }
            if (!bean.isToNotify()) continue;
            this.notifyAllElements(process2, bean);
        }
        if (!process2.hasState(PhdThesisProcessStateType.WAITING_FOR_THESIS_RATIFICATION)) {
            process2.createState(PhdThesisProcessStateType.WAITING_FOR_THESIS_RATIFICATION, userView.getPerson(), bean.getRemarks());
        }
        return process2;
    }

    private boolean isThesisFinalDocument(PhdProgramDocumentUploadBean each) {
        return each.getType() == PhdIndividualProgramDocumentType.FINAL_THESIS;
    }

    private void notifyAllElements(PhdThesisProcess process2, PhdThesisProcessBean bean) {
        AlertService.AlertMessage subject = AlertService.AlertMessage.create("message.phd.thesis.submit.subject", new Object[0]);
        AlertService.AlertMessage body = AlertService.AlertMessage.create("message.phd.thesis.submit.body", new Object[0]);
        AlertService.alertResponsibleCoordinators(process2.getIndividualProgramProcess(), subject, body);
        AlertService.alertGuiders(process2.getIndividualProgramProcess(), subject, body);
        AlertService.alertStudent(process2.getIndividualProgramProcess(), subject, body);
    }
}

