/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdThesisReportFeedbackDocument;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.User;

public class JuryReporterFeedbackUpload
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (!process2.isJuryValidated()) {
            throw new PreConditionNotValidException();
        }
        if (!process2.hasState(PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK)) {
            throw new PreConditionNotValidException();
        }
        if (process2.isAllowedToManageProcess(userView)) {
            return;
        }
        if (!process2.isParticipant(userView.getPerson())) {
            throw new PreConditionNotValidException();
        }
        ThesisJuryElement element = process2.getThesisJuryElement(userView.getPerson());
        if (element == null || !element.getReporter().booleanValue()) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        for (PhdProgramDocumentUploadBean documentBean : bean.getDocuments()) {
            if (!documentBean.hasAnyInformation()) continue;
            new PhdThesisReportFeedbackDocument(bean.getJuryElement(), documentBean.getRemarks(), documentBean.getFileContent(), documentBean.getFilename(), AccessControl.getPerson());
        }
        return process2;
    }
}

