/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.individualProcess.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.alert.PhdAlert;
import org.fenixedu.academic.domain.phd.alert.PhdPublicPresentationSeminarAlert;
import org.fenixedu.academic.domain.phd.individualProcess.activities.PhdIndividualProgramProcessActivity;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcess;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcessBean;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcessStateType;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.LocalDate;

public class ExemptPublicPresentationSeminarComission
extends PhdIndividualProgramProcessActivity {
    @Override
    protected void activityPreConditions(PhdIndividualProgramProcess process2, User userView) {
        if (process2.getSeminarProcess() != null || process2.getActiveState() != PhdIndividualProgramProcessState.WORK_DEVELOPMENT) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdIndividualProgramProcess executeActivity(PhdIndividualProgramProcess process2, User userView, Object object) {
        PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
        bean.setPresentationRequestDate(new LocalDate());
        bean.setPhdIndividualProgramProcess(process2);
        PublicPresentationSeminarProcess seminarProcess = (PublicPresentationSeminarProcess)((Object)Process.createNewProcess(userView, PublicPresentationSeminarProcess.class, object));
        seminarProcess.createState(PublicPresentationSeminarProcessStateType.EXEMPTED, userView.getPerson(), "");
        this.discardPublicSeminarAlerts(process2);
        return process2;
    }

    private void discardPublicSeminarAlerts(PhdIndividualProgramProcess process2) {
        for (PhdAlert alert : process2.getActiveAlerts()) {
            if (!(alert instanceof PhdPublicPresentationSeminarAlert)) continue;
            alert.discard();
        }
    }
}

