/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.debts;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityPaymentPeriod_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;

public class PhdGratuityPaymentPeriod
extends PhdGratuityPaymentPeriod_Base {
    public PhdGratuityPaymentPeriod(int dayStart, int monthStart, int dayEnd, int monthEnd, int dayLastPayment, int monthLastPayment) {
        this.init(new Partial().with(DateTimeFieldType.monthOfYear(), monthStart).with(DateTimeFieldType.dayOfYear(), dayStart), new Partial().with(DateTimeFieldType.monthOfYear(), monthEnd).with(DateTimeFieldType.dayOfYear(), dayEnd), new Partial().with(DateTimeFieldType.monthOfYear(), monthLastPayment).with(DateTimeFieldType.dayOfYear(), dayLastPayment));
    }

    protected void init(Partial start, Partial end, Partial lastPaymentDay) {
        this.setStart(start);
        this.setEnd(end);
        this.setLastPayment(lastPaymentDay);
    }

    public PhdGratuityPaymentPeriod(Partial start, Partial end, Partial lastPaymentDay) {
        this.init(start, end, lastPaymentDay);
    }

    public int getMonthStart() {
        return this.getStart().get(DateTimeFieldType.monthOfYear());
    }

    public int getDayStart() {
        return this.getStart().get(DateTimeFieldType.dayOfMonth());
    }

    public int getMonthEnd() {
        return this.getEnd().get(DateTimeFieldType.monthOfYear());
    }

    public int getDayEnd() {
        return this.getEnd().get(DateTimeFieldType.dayOfMonth());
    }

    public int getMonthLastPayment() {
        return this.getLastPayment().get(DateTimeFieldType.monthOfYear());
    }

    public int getDayLastPayment() {
        return this.getLastPayment().get(DateTimeFieldType.dayOfMonth());
    }

    public boolean contains(LocalDate date) {
        LocalDate start = new LocalDate(date.getYear(), this.getMonthStart(), this.getDayStart());
        LocalDate end = new LocalDate(date.getYear(), this.getMonthEnd(), this.getDayEnd());
        return !(!date.equals((Object)start) && !date.isAfter((ReadablePartial)start) || !date.equals((Object)end) && !date.isBefore((ReadablePartial)end));
    }

    public Money fine(double fineRate, Money amount, DateTime when) {
        LocalDate lastPaymentDay;
        LocalDate whenPaying = new LocalDate(when.getYear(), when.monthOfYear().get(), when.dayOfMonth().get());
        if (whenPaying.isAfter((ReadablePartial)(lastPaymentDay = new LocalDate(when.getYear(), this.getMonthLastPayment(), this.getDayLastPayment())))) {
            int monthsOut = when.getMonthOfYear() - lastPaymentDay.getMonthOfYear();
            if (monthsOut == 0) {
                monthsOut = 1;
            }
            return new Money(amount.getAmount().multiply(new BigDecimal(fineRate * (double)monthsOut)));
        }
        return new Money(0L);
    }

    public void delete() {
        this.setRootDomainObject(null);
        this.setPostingRule(null);
        super.deleteDomainObject();
    }
}

