/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.debts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventState;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemption;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.debts.PhdEventExemption;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityEvent;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityFineExemption;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityPR_Base;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityPaymentPeriod;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityPriceQuirk;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class PhdGratuityPR
extends PhdGratuityPR_Base {
    public PhdGratuityPR() {
    }

    public PhdGratuityPR(DateTime start, DateTime end, ServiceAgreementTemplate serviceAgreementTemplate, Money gratuity, double fineRate) {
        this.init(EventType.PHD_GRATUITY, start, end, serviceAgreementTemplate, gratuity, fineRate);
    }

    protected void init(EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money gratuity, double fineRate) {
        super.init(eventType, startDate, endDate, serviceAgreementTemplate);
        this.setGratuity(gratuity);
        this.setFineRate(fineRate);
    }

    public void setGratuity(Money gratuity) {
        if (gratuity.lessThan(new Money(0L))) {
            throw new RuntimeException("error.negative.gratuity");
        }
        super.setGratuity(gratuity);
    }

    public void setFineRate(Double fineRate) {
        if (fineRate <= 0.0 || fineRate > 1.0) {
            throw new RuntimeException("error.invalid.fine.rate");
        }
        super.setFineRate(fineRate);
    }

    public Money getGratuityByProcess(PhdIndividualProgramProcess process2) {
        ArrayList states = new ArrayList(process2.getStates());
        if (states.size() > 0 && this.getPhdGratuityPriceQuirksSet().size() > 0) {
            int years = 0;
            for (PhdGratuityEvent event : process2.getPhdGratuityEventsSet()) {
                if (event.isInState(EventState.CANCELLED)) continue;
                ++years;
            }
            for (PhdGratuityPriceQuirk quirk : this.getPhdGratuityPriceQuirksSet()) {
                if (quirk.getYear() != years) continue;
                return quirk.getGratuity();
            }
            return this.getGratuity();
        }
        return this.getGratuity();
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        PhdGratuityEvent phdGratuityEvent = (PhdGratuityEvent)((Object)event);
        Money gratuity = this.getGratuityByProcess(phdGratuityEvent.getPhdIndividualProgramProcess());
        return gratuity;
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        PhdGratuityEvent phdGratuityEvent = (PhdGratuityEvent)((Object)event);
        amountToPay = this.adjustGratuityWithExmptions(phdGratuityEvent, amountToPay);
        BigDecimal percentage = new BigDecimal(0);
        for (Exemption exemption : phdGratuityEvent.getExemptionsSet()) {
            if (!exemption.isGratuityExemption()) continue;
            percentage = percentage.add(((GratuityExemption)((Object)exemption)).calculateDiscountPercentage(amountToPay));
        }
        if ((amountToPay = amountToPay.subtract(amountToPay.multiply(percentage))).lessOrEqualThan(Money.ZERO)) {
            return Money.ZERO;
        }
        return amountToPay;
    }

    private boolean hasFineExemption(PhdGratuityEvent phdGratuityEvent) {
        for (Exemption exemption : phdGratuityEvent.getExemptionsSet()) {
            if (!(exemption instanceof PhdGratuityFineExemption)) continue;
            return true;
        }
        return false;
    }

    private Money adjustGratuityWithExmptions(PhdGratuityEvent phdGratuityEvent, Money gratuity) {
        if (phdGratuityEvent.getExemptionsSet().size() > 0) {
            for (Exemption exemption : phdGratuityEvent.getExemptionsSet()) {
                if (!(exemption instanceof PhdEventExemption) || exemption instanceof PhdGratuityFineExemption) continue;
                gratuity = gratuity.subtract(((PhdEventExemption)((Object)exemption)).getValue());
            }
        }
        return gratuity;
    }

    public PhdGratuityPaymentPeriod getPhdGratuityPeriod(LocalDate programStartDate) {
        for (PhdGratuityPaymentPeriod period : this.getPhdGratuityPaymentPeriodsSet()) {
            if (!period.contains(programStartDate)) continue;
            return period;
        }
        throw new DomainException("error.phd.debts.PhdGratuityPR.cannot.find.period", new String[0]);
    }

    private Money getFine(LocalDate programStartDate, DateTime when, Money value) {
        PhdGratuityPaymentPeriod phdGratuityPeriod = this.getPhdGratuityPeriod(programStartDate);
        return phdGratuityPeriod.fine(this.getFineRate(), this.getGratuity(), when);
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        return Collections.singletonList(new EntryDTO(EntryType.PHD_GRATUITY_FEE, event, this.calculateTotalAmountToPay(event, when), event.getPayedAmount(), event.calculateAmountToPay(when), event.getDescriptionForEntryType(EntryType.PHD_GRATUITY_FEE), event.calculateAmountToPay(when)));
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.gratuity.PhdGratuityPR.invalid.number.of.entryDTOs", new String[0]);
        }
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, EntryType.PHD_GRATUITY_FEE, entryDTOs.iterator().next().getAmountToPay(), transactionDetail));
    }

    public void removeOtherRelations() {
        for (PhdGratuityPaymentPeriod period : this.getPhdGratuityPaymentPeriodsSet()) {
            period.delete();
        }
        this.getPhdGratuityPaymentPeriodsSet().clear();
    }
}

