/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramFocusArea;
import org.fenixedu.academic.domain.phd.ThesisSubject$callable$createThesisSubject;
import org.fenixedu.academic.domain.phd.ThesisSubject$callable$delete;
import org.fenixedu.academic.domain.phd.ThesisSubject$callable$edit;
import org.fenixedu.academic.domain.phd.ThesisSubjectOrder;
import org.fenixedu.academic.domain.phd.ThesisSubject_Base;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ThesisSubject
extends ThesisSubject_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createThesisSubject = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected ThesisSubject() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected ThesisSubject(PhdProgramFocusArea focusArea, MultiLanguageString name, MultiLanguageString description, Teacher teacher, String externalAdvisor) {
        this();
        this.checkParameters(focusArea, name, description, teacher);
        this.setPhdProgramFocusArea(focusArea);
        this.setName(name);
        this.setDescription(description);
        this.setTeacher(teacher);
        this.setExternalAdvisorName(externalAdvisor);
        for (PhdIndividualProgramProcess process2 : focusArea.getIndividualProgramProcessesSet()) {
            if (!this.isCandidacyPeriodOpen(process2)) continue;
            new ThesisSubjectOrder(this, process2, process2.getHighestThesisSubjectOrder() + 1);
        }
    }

    private void checkParameters(PhdProgramFocusArea focusArea, MultiLanguageString name, MultiLanguageString description, Teacher teacher) {
        String[] args = new String[]{};
        if (focusArea == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.ThesisSubject.focusArea.required", args);
        }
        if (name == null) {
            String[] args1 = new String[]{};
            if (name == null) {
                throw new DomainException("error.org.fenixedu.academic.domain.phd.ThesisSubject.name.required", args1);
            }
        }
        if (!name.hasContent(MultiLanguageString.en)) {
            throw new PhdDomainOperationException("error.org.fenixedu.academic.domain.phd.ThesisSubject.name.in.english.required", new String[0]);
        }
        if (teacher == null) {
            throw new PhdDomainOperationException("error.org.fenixedu.academic.domain.phd.ThesisSubject.teacher.required", new String[0]);
        }
    }

    public void edit(MultiLanguageString multiLanguageString, MultiLanguageString multiLanguageString2, Teacher teacher, String string) {
        Object object = advice$edit.perform((Callable)new ThesisSubject$callable$edit(this, multiLanguageString, multiLanguageString2, teacher, string));
    }

    static /* synthetic */ void advised$edit(ThesisSubject this_, MultiLanguageString name, MultiLanguageString description, Teacher teacher, String externalAdvisor) {
        this_.checkParameters(this_.getPhdProgramFocusArea(), name, description, teacher);
        this_.setName(name);
        this_.setDescription(description);
        this_.setTeacher(teacher);
        this_.setExternalAdvisorName(externalAdvisor);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ThesisSubject$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ThesisSubject this_) {
        for (ThesisSubjectOrder order : this_.getThesisSubjectOrdersSet()) {
            if (!this_.isCandidacyPeriodOpen(order.getPhdIndividualProgramProcess())) continue;
            order.delete();
        }
        this_.setPhdProgramFocusArea(null);
        if (this_.getThesisSubjectOrdersSet().isEmpty()) {
            this_.setTeacher(null);
            this_.setRootDomainObject(null);
            this_.deleteDomainObject();
        }
    }

    public static ThesisSubject createThesisSubject(PhdProgramFocusArea phdProgramFocusArea, MultiLanguageString multiLanguageString, MultiLanguageString multiLanguageString2, Teacher teacher, String string) {
        return (ThesisSubject)((Object)advice$createThesisSubject.perform((Callable)new ThesisSubject$callable$createThesisSubject(phdProgramFocusArea, multiLanguageString, multiLanguageString2, teacher, string)));
    }

    static /* synthetic */ ThesisSubject advised$createThesisSubject(PhdProgramFocusArea focusArea, MultiLanguageString name, MultiLanguageString description, Teacher teacher, String externalAdvisor) {
        return new ThesisSubject(focusArea, name, description, teacher, externalAdvisor);
    }

    private boolean isCandidacyPeriodOpen(PhdIndividualProgramProcess process2) {
        return process2.getCandidacyProcess().getPublicPhdCandidacyPeriod() != null && process2.getCandidacyProcess().getPublicPhdCandidacyPeriod().isOpen();
    }
}

