/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.PhdThesisReportFeedbackDocument_Base;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;

public class PhdThesisReportFeedbackDocument
extends PhdThesisReportFeedbackDocument_Base {
    private PhdThesisReportFeedbackDocument() {
    }

    public PhdThesisReportFeedbackDocument(ThesisJuryElement element, String remarks, byte[] content, String filename, Person uploader) {
        this();
        String[] args = new String[]{};
        if (element == null) {
            throw new DomainException("error.PhdThesisReportFeedbackDocument.invalid.element", args);
        }
        this.setJuryElement(element);
        this.init((PhdProgramProcess)((Object)element.getProcess()), PhdIndividualProgramDocumentType.JURY_REPORT_FEEDBACK, remarks, content, filename, uploader);
    }

    protected void checkParameters(PhdProgramProcess process2, PhdIndividualProgramDocumentType documentType, byte[] content, String filename, Person uploader) {
        if (documentType == null || content == null || content.length == 0 || StringUtils.isEmpty((String)filename)) {
            throw new DomainException("error.phd.PhdProgramProcessDocument.documentType.and.file.cannot.be.null", new String[0]);
        }
    }

    protected void setDocumentVersion(PhdProgramProcess process2, PhdIndividualProgramDocumentType documentType) {
        if (documentType.isVersioned()) {
            if (process2 != null) {
                super.setDocumentVersion(Integer.valueOf(process2.getLastVersionNumber(documentType) + 1));
            } else {
                super.setDocumentVersion(Integer.valueOf(this.getJuryElement().getFeedbackDocumentsSet().size() + 1));
            }
        } else {
            super.setDocumentVersion(Integer.valueOf(1));
        }
    }

    public void delete() {
        this.setJuryElement(null);
        super.delete();
    }

    public boolean isAssignedToProcess() {
        return this.getPhdProgramProcess() != null;
    }

    public boolean isLast() {
        return this.getJuryElement().getLastFeedbackDocument() == this;
    }

    public PhdProgramProcessDocument getLastVersion() {
        return this.getJuryElement().getLastFeedbackDocument();
    }
}

