/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum PhdProgramCandidacyProcessState implements PhdProcessStateType
{
    PRE_CANDIDATE,
    STAND_BY_WITH_MISSING_INFORMATION,
    STAND_BY_WITH_COMPLETE_INFORMATION,
    PENDING_FOR_COORDINATOR_OPINION,
    REJECTED,
    WAITING_FOR_SCIENTIFIC_COUNCIL_RATIFICATION,
    RATIFIED_BY_SCIENTIFIC_COUNCIL,
    CONCLUDED;


    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    @Override
    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    private String getQualifiedName() {
        return this.getClass().getSimpleName() + "." + this.name();
    }

    public static List<PhdProgramCandidacyProcessState> getPossibleNextStates(PhdProgramCandidacyProcess process2) {
        PhdProgramCandidacyProcessState type = process2.getActiveState();
        return PhdProgramCandidacyProcessState.getPossibleNextStates(type);
    }

    public static List<PhdProgramCandidacyProcessState> getPossibleNextStates(PhdProgramCandidacyProcessState type) {
        if (type == null) {
            return Arrays.asList(PRE_CANDIDATE, STAND_BY_WITH_MISSING_INFORMATION, STAND_BY_WITH_COMPLETE_INFORMATION);
        }
        switch (type) {
            case PRE_CANDIDATE: {
                return Arrays.asList(STAND_BY_WITH_COMPLETE_INFORMATION, PENDING_FOR_COORDINATOR_OPINION, REJECTED);
            }
            case STAND_BY_WITH_MISSING_INFORMATION: {
                return Arrays.asList(PENDING_FOR_COORDINATOR_OPINION, REJECTED);
            }
            case STAND_BY_WITH_COMPLETE_INFORMATION: {
                return Arrays.asList(PENDING_FOR_COORDINATOR_OPINION, REJECTED);
            }
            case PENDING_FOR_COORDINATOR_OPINION: {
                return Arrays.asList(WAITING_FOR_SCIENTIFIC_COUNCIL_RATIFICATION, REJECTED);
            }
            case WAITING_FOR_SCIENTIFIC_COUNCIL_RATIFICATION: {
                return Arrays.asList(PENDING_FOR_COORDINATOR_OPINION, REJECTED, RATIFIED_BY_SCIENTIFIC_COUNCIL);
            }
            case RATIFIED_BY_SCIENTIFIC_COUNCIL: {
                return Arrays.asList(CONCLUDED, REJECTED);
            }
            case CONCLUDED: {
                return Arrays.asList(RATIFIED_BY_SCIENTIFIC_COUNCIL, REJECTED);
            }
            case REJECTED: {
                return Arrays.asList(PENDING_FOR_COORDINATOR_OPINION);
            }
        }
        return Collections.emptyList();
    }
}

