/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessNumber_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class PhdIndividualProgramProcessNumber
extends PhdIndividualProgramProcessNumber_Base
implements Comparable<PhdIndividualProgramProcessNumber> {
    public static Comparator<PhdIndividualProgramProcessNumber> COMPARATOR_BY_NUMBER = new Comparator<PhdIndividualProgramProcessNumber>(){

        @Override
        public int compare(PhdIndividualProgramProcessNumber left, PhdIndividualProgramProcessNumber right) {
            int comparationResult = left.getNumber().compareTo(right.getNumber());
            return comparationResult == 0 ? left.getExternalId().compareTo(right.getExternalId()) : comparationResult;
        }
    };

    protected PhdIndividualProgramProcessNumber() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected PhdIndividualProgramProcessNumber(Integer number, Integer year, Integer phdStudentNumber) {
        this();
        this.init(number, year, phdStudentNumber);
    }

    private void init(Integer number, Integer year, Integer phdStudentNumber) {
        this.checkParameters(number, year, phdStudentNumber);
        super.setNumber(number);
        super.setYear(year);
        super.setPhdStudentNumber(phdStudentNumber);
    }

    public void setYear(Integer year) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessNumber.cannot.modify.year", new String[0]);
    }

    public void setNumber(Integer number) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessNumber.cannot.modify.number", new String[0]);
    }

    public void setPhdStudentNumber(Integer phdStudentNumber) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessNumber.cannot.modify.phdStudentNumber", new String[0]);
    }

    private void checkParameters(Integer number, Integer year, Integer phdStudentNumber) {
        String[] args = new String[]{};
        if (number == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessNumber.number.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (year == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessNumber.year.cannot.be.null", args1);
        }
        if (phdStudentNumber != null && PhdIndividualProgramProcessNumber.hasProcessWithPhdStudentNumber(phdStudentNumber)) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessNumber.phdStudentNumber.exists", new String[0]);
        }
    }

    public void edit(PhdIndividualProgramProcessBean bean) {
        if (bean.getPhdStudentNumber() == this.getPhdStudentNumber()) {
            return;
        }
        if (bean.getPhdStudentNumber() == null) {
            super.setPhdStudentNumber(null);
            return;
        }
        PhdIndividualProgramProcessNumber number = PhdIndividualProgramProcessNumber.readByPhdStudentNumber(bean.getPhdStudentNumber());
        if (number == null || number == this) {
            super.setPhdStudentNumber(bean.getPhdStudentNumber());
            return;
        }
        throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessNumber.phdStudentNumber.exists", new String[0]);
    }

    public static PhdIndividualProgramProcessNumber generateNextForYear(Integer year, Integer phdStudentNumber) {
        PhdIndividualProgramProcessNumber maxByYear = PhdIndividualProgramProcessNumber.readMaxByYear(year);
        Integer number = maxByYear != null ? maxByYear.getNumber() + 1 : 1;
        return new PhdIndividualProgramProcessNumber(number, year, phdStudentNumber);
    }

    public static PhdIndividualProgramProcessNumber readMaxByYear(Integer year) {
        Set<PhdIndividualProgramProcessNumber> processes = PhdIndividualProgramProcessNumber.readByYear(year);
        return processes.isEmpty() ? null : Collections.max(processes, COMPARATOR_BY_NUMBER);
    }

    public static Set<PhdIndividualProgramProcessNumber> readByYear(Integer year) {
        HashSet<PhdIndividualProgramProcessNumber> result = new HashSet<PhdIndividualProgramProcessNumber>();
        for (PhdIndividualProgramProcessNumber each : Bennu.getInstance().getPhdIndividualProcessNumbersSet()) {
            if (each.getYear().intValue() != year.intValue()) continue;
            result.add(each);
        }
        return result;
    }

    public static PhdIndividualProgramProcessNumber readByPhdStudentNumber(Integer number) {
        for (PhdIndividualProgramProcessNumber each : Bennu.getInstance().getPhdIndividualProcessNumbersSet()) {
            if (!number.equals(each.getPhdStudentNumber())) continue;
            return each;
        }
        return null;
    }

    public static boolean hasProcessWithPhdStudentNumber(Integer number) {
        return PhdIndividualProgramProcessNumber.readByPhdStudentNumber(number) != null;
    }

    public String getFullProcessNumber() {
        return this.getNumber() + "/" + this.getYear();
    }

    @Override
    public int compareTo(PhdIndividualProgramProcessNumber other) {
        int res = -1 * this.getYear().compareTo(other.getYear());
        return res != 0 ? res : -1 * this.getNumber().compareTo(other.getNumber());
    }

    public boolean belongsTo(ExecutionYear year) {
        return year.belongsToCivilYear(this.getYear());
    }
}

