/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.DegreeUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.SchoolUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;

public class DegreeUnit
extends DegreeUnit_Base {
    private DegreeUnit() {
        super.setType(PartyTypeEnum.DEGREE_UNIT);
    }

    public static DegreeUnit createNewInternalDegreeUnit(MultiLanguageString unitName, String unitNameCard, Integer costCenterCode, String acronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, AccountabilityType accountabilityType, String webAddress, Degree degree, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        DegreeUnit degreeUnit = new DegreeUnit();
        degreeUnit.init(unitName, unitNameCard, costCenterCode, acronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        degreeUnit.setDegree(degree);
        degreeUnit.addParentUnit(parentUnit, accountabilityType);
        DegreeUnit.checkIfAlreadyExistsOneDegreeWithSameAcronym(degreeUnit);
        return degreeUnit;
    }

    public void edit(MultiLanguageString unitName, String unitNameCard, Integer unitCostCenter, String acronym, YearMonthDay beginDate, YearMonthDay endDate, String webAddress, UnitClassification classification, Department department, Degree degree, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        super.edit(unitName, unitNameCard, unitCostCenter, acronym, beginDate, endDate, webAddress, classification, department, degree, administrativeOffice, canBeResponsibleOfSpaces, campus);
        this.setDegree(degree);
        DegreeUnit.checkIfAlreadyExistsOneDegreeWithSameAcronym(this);
    }

    public Accountability addParentUnit(Unit parentUnit, AccountabilityType accountabilityType) {
        if (parentUnit != null && !parentUnit.isInternal()) {
            throw new DomainException("error.unit.invalid.parentUnit", new String[0]);
        }
        return super.addParentUnit(parentUnit, accountabilityType);
    }

    public void setAcronym(String acronym) {
        if (StringUtils.isEmpty((String)acronym)) {
            throw new DomainException("error.unit.empty.acronym", new String[0]);
        }
        super.setAcronym(acronym);
    }

    public void setType(PartyTypeEnum partyTypeEnum) {
        throw new DomainException("unit.impossible.set.type", new String[0]);
    }

    public boolean isDegreeUnit() {
        return true;
    }

    public void setDegree(Degree degree) {
        if (degree == null) {
            throw new DomainException("error.DegreeUnit.empty.degree", new String[0]);
        }
        super.setDegree(degree);
    }

    public void delete() {
        super.setDegree(null);
        super.delete();
    }

    private static void checkIfAlreadyExistsOneDegreeWithSameAcronym(DegreeUnit degreeUnit) {
        for (Unit unit : UnitUtils.readInstitutionUnit().getAllSubUnits()) {
            if (unit.equals((Object)degreeUnit) || !unit.isDegreeUnit() || !degreeUnit.getAcronym().equalsIgnoreCase(unit.getAcronym())) continue;
            throw new DomainException("error.unit.already.exists.unit.with.same.name.or.acronym", new String[0]);
        }
    }

    public SchoolUnit getSchoolUnit() {
        DegreeUnit current = this;
        while (current != null) {
            if (current.getType().equals((Object)PartyTypeEnum.SCHOOL)) {
                return (SchoolUnit)((Object)current);
            }
            Collection<Unit> parentUnits = ((Unit)((Object)current)).getParentUnits(AccountabilityTypeEnum.ACADEMIC_STRUCTURE);
            current = parentUnits.size() > 0 ? parentUnits.iterator().next() : null;
        }
        return null;
    }
}

