/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.List;
import org.fenixedu.academic.domain.curricularRules.DegreeModulesSelectionLimit;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;

public class DegreeModulesSelectionLimitExecutor
extends CurricularRuleExecutor {
    private int countTotalDegreeModules(EnrolmentContext enrolmentContext, CourseGroup courseGroup, CurriculumGroup curriculumGroup) {
        int numberOfDegreeModulesToEnrol = this.countNumberOfDegreeModulesToEnrol(enrolmentContext, courseGroup);
        int numberOfApprovedEnrolments = curriculumGroup.getNumberOfApprovedChildCurriculumLines();
        int numberOfEnrolments = this.countNumberOfChildEnrolments(enrolmentContext, curriculumGroup);
        int numberOfChildCurriculumGroups = curriculumGroup.getNumberOfChildCurriculumGroupsWithCourseGroup();
        return numberOfApprovedEnrolments + numberOfEnrolments + numberOfDegreeModulesToEnrol + numberOfChildCurriculumGroups;
    }

    private int countNumberOfChildEnrolments(EnrolmentContext enrolmentContext, CurriculumGroup curriculumGroup) {
        return enrolmentContext.isToEvaluateRulesByYear() ? curriculumGroup.getNumberOfChildEnrolments(enrolmentContext.getExecutionYear()) : curriculumGroup.getNumberOfChildEnrolments(enrolmentContext.getExecutionPeriod());
    }

    private int countPreviousPeriodNumberOfChildEnrolments(EnrolmentContext enrolmentContext, CurriculumGroup curriculumGroup) {
        return enrolmentContext.isToEvaluateRulesByYear() ? curriculumGroup.getNumberOfChildEnrolments(enrolmentContext.getExecutionYear().getPreviousExecutionYear()) : curriculumGroup.getNumberOfChildEnrolments(enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod());
    }

    private RuleResult createFalseRuleResult(DegreeModulesSelectionLimit rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        if (rule.getMinimumLimit().equals(rule.getMaximumLimit())) {
            return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.DegreeModulesSelectionLimitExecutor.limit.exceded", rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumLimit().toString());
        }
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.DegreeModulesSelectionLimitExecutor.limits.exceded", rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumLimit().toString(), rule.getMaximumLimit().toString());
    }

    private RuleResult createImpossibleRuleResult(DegreeModulesSelectionLimit rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        if (rule.getMinimumLimit().equals(rule.getMaximumLimit())) {
            return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.DegreeModulesSelectionLimitExecutor.limit.exceded", rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumLimit().toString());
        }
        return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.DegreeModulesSelectionLimitExecutor.limits.exceded", rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumLimit().toString(), rule.getMaximumLimit().toString());
    }

    private int countNumberOfDegreeModulesToEnrol(EnrolmentContext enrolmentContext, CourseGroup courseGroup) {
        int result = 0;
        for (Context context : this.getValidChildContexts(enrolmentContext, courseGroup)) {
            if (!this.isEnrolling(enrolmentContext, context.getChildDegreeModule())) continue;
            ++result;
        }
        return result;
    }

    private List<Context> getValidChildContexts(EnrolmentContext enrolmentContext, CourseGroup courseGroup) {
        return enrolmentContext.isToEvaluateRulesByYear() ? courseGroup.getValidChildContexts(enrolmentContext.getExecutionYear()) : courseGroup.getValidChildContexts(enrolmentContext.getExecutionPeriod());
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        DegreeModulesSelectionLimit rule = (DegreeModulesSelectionLimit)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.searchDegreeModuleToEvaluate(enrolmentContext, (ICurricularRule)((Object)rule));
        if (degreeModuleToEvaluate.isEnroled()) {
            EnroledCurriculumModuleWrapper moduleEnroledWrapper;
            CurriculumGroup curriculumGroup;
            CourseGroup courseGroup = rule.getDegreeModuleToApplyRule();
            int total = this.countTotalDegreeModules(enrolmentContext, courseGroup, curriculumGroup = (CurriculumGroup)((Object)(moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate).getCurriculumModule()));
            if (rule.numberOfDegreeModulesExceedMaximum(total)) {
                if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
                    return this.createImpossibleRuleResult(rule, sourceDegreeModuleToEvaluate);
                }
                return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate);
            }
            return rule.numberOfDegreeModulesExceedMaximum(total += this.countPreviousPeriodNumberOfChildEnrolments(enrolmentContext, curriculumGroup)) ? RuleResult.createTrue(EnrolmentResultType.TEMPORARY, sourceDegreeModuleToEvaluate.getDegreeModule()) : RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        DegreeModulesSelectionLimit rule = (DegreeModulesSelectionLimit)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.searchDegreeModuleToEvaluate(enrolmentContext, (ICurricularRule)((Object)rule));
        if (degreeModuleToEvaluate.isEnroled()) {
            CurriculumGroup curriculumGroup;
            EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
            CourseGroup courseGroup = rule.getDegreeModuleToApplyRule();
            int total = this.countTotalDegreeModules(enrolmentContext, courseGroup, curriculumGroup = (CurriculumGroup)((Object)moduleEnroledWrapper.getCurriculumModule()));
            if (rule.numberOfDegreeModulesExceedMaximum(total)) {
                if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
                    return this.createImpossibleRuleResult(rule, sourceDegreeModuleToEvaluate);
                }
                return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate);
            }
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }
}

