/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.erasmus;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.TypeOfProgramme;

public class TypeOfProgrammeList
implements Serializable {
    private static EmptyTypeOfProgrammeList EMPTY = new EmptyTypeOfProgrammeList();
    private final Set<TypeOfProgramme> types = new HashSet<TypeOfProgramme>();

    private TypeOfProgrammeList() {
    }

    private TypeOfProgrammeList(String types) {
        this.types.addAll(this.convertToSet(types));
    }

    public TypeOfProgrammeList(Collection<TypeOfProgramme> types) {
        this.types.addAll(types);
    }

    public Set<TypeOfProgramme> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public String toString() {
        return this.convertToString(this.types);
    }

    private String convertToString(Set<TypeOfProgramme> types) {
        StringBuilder result = new StringBuilder();
        for (TypeOfProgramme each : types) {
            result.append(each.name()).append(",");
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) == ',') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private Set<TypeOfProgramme> convertToSet(String types) {
        HashSet<TypeOfProgramme> result = new HashSet<TypeOfProgramme>();
        for (String each : types.split(",")) {
            String valueToParse = each.trim();
            if (StringUtils.isEmpty((String)valueToParse)) continue;
            result.add(TypeOfProgramme.valueOf(valueToParse));
        }
        return result;
    }

    public static TypeOfProgrammeList importFromString(String value) {
        return StringUtils.isEmpty((String)value) ? EMPTY : new TypeOfProgrammeList(value);
    }

    public static class EmptyTypeOfProgrammeList
    extends TypeOfProgrammeList {
        private static final long serialVersionUID = 1L;

        @Override
        public Set<TypeOfProgramme> getTypes() {
            return Collections.emptySet();
        }

        @Override
        public String toString() {
            return "";
        }
    }
}

