/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.alumni;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.AlumniIdentityCheckRequest;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Formation;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.QueueJobResult;
import org.fenixedu.academic.domain.alumni.AlumniReportFile_Base;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.DomainObject;

public class AlumniReportFile
extends AlumniReportFile_Base {
    private static final Logger logger = LoggerFactory.getLogger(AlumniReportFile.class);
    private static final String NOT_AVAILABLE = "n/a";
    private static final String DATE_FORMAT = "dd/MM/yyyy";
    private static final Locale PT = new Locale("pt", "PT");

    private AlumniReportFile() {
        this.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
    }

    private AlumniReportFile(boolean fullReport, boolean onlyRegisteredAlumni) {
        this();
        this.setFullReport(fullReport);
        this.setOnlyRegisteredAlumni(onlyRegisteredAlumni);
        if ("fullReport" == null || "fullReport".isEmpty()) {
            throw new DomainException("error.domain.alumni.alumni.report.file.full.report.is.null", null);
        }
        if ("onlyRegisteredAlumni" == null || "onlyRegisteredAlumni".isEmpty()) {
            throw new DomainException("error.domain.alumni.alumni.report.file.only.alumni.is.null", null);
        }
    }

    public QueueJobResult execute() throws Exception {
        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
        Spreadsheet.exportToXLSSheets((OutputStream)byteArrayOS, this.buildReport());
        QueueJobResult queueJobResult = new QueueJobResult();
        queueJobResult.setContentType("application/vnd.ms-excel");
        queueJobResult.setContent(byteArrayOS.toByteArray());
        logger.info("Job " + this.getFilename() + " completed");
        return queueJobResult;
    }

    public String getFilename() {
        return this.getFullReport() ? BundleUtil.getString((String)"resources.GEPResources", (String)"alumni.full.reports.name", (String[])new String[]{this.getRequestDate().toString()}) : BundleUtil.getString((String)"resources.GEPResources", (String)"alumni.partial.reports.name", (String[])new String[]{this.getRequestDate().toString()});
    }

    private List<Spreadsheet> buildReport() {
        Spreadsheet curriculumData = new Spreadsheet("ALUMNI_CURRICULUM_DATA");
        curriculumData.setHeaders(new String[]{"NOME", "NUMERO_ALUNO", "CURSO", "INICIO", "CONCLUSAO", "DESCRICAO", "EMPREGADO ACTUALMENTE"});
        Spreadsheet personalData = new Spreadsheet("ALUMNI_PERSONAL_DATA");
        personalData.setHeaders(new String[]{"NOME", "NUMERO_ALUNO", "DATA_NASCIMENTO", "MORADA", "COD_POSTAL", "LOCALIDADE", "PAIS", "EMAIL_PESSOAL", "EMAIL_ENVIAR", "TELEFONE", "REGISTADO EM"});
        Spreadsheet jobData = new Spreadsheet("ALUMNI_JOB_DATA");
        jobData.setHeaders(new String[]{"IDENTIFICADOR", "NOME", "NUMERO_ALUNO", "EMPREGADOR", "CIDADE", "PAIS", "COD_AREA_NEGOCIO", "AREA_NEGOCIO", "POSICAO", "DATA_INICIO", "DATA_FIM", "TIPO_CONTRATO", "FORMA_COLOCACAO", "REMUN_MENSAL_BRUTA", "TIPO_SALARIO", "DATA_ALTERACAO", "DATA_REGISTO"});
        Spreadsheet formationData = new Spreadsheet("ALUMNI_FORMATION_DATA");
        formationData.setHeaders(new String[]{"IDENTIFICADOR", "NOME", "NUMERO_ALUNO", "TIPO", "GRAU", "INSTITUICAO", "COD_AREA_EDUCATIVA", "AREA_EDUCATIVA", "INICIO", "CONCLUSAO", "CREDITOS_ECTS", "NUMERO_HORAS", "DATA_ALTERACAO", "DATA_REGISTO"});
        int count = 0;
        for (User user : RoleType.ALUMNI.actualGroup().getMembers()) {
            Person person = user.getPerson();
            if (++count % 100 == 0) {
                logger.info(String.format("Count %s persons", count));
            }
            if (person.getStudent() == null || this.getOnlyRegisteredAlumni() && person.getStudent().getAlumni() == null || !this.getFullReport() && (person.getStudent().getAlumni() == null || person.getStudent().getAlumni().getUrlRequestToken() == null)) continue;
            String alumniName = person.getStudent().getName();
            Integer studentNumber = person.getStudent().getNumber();
            this.addCurriculumDataRow(curriculumData, alumniName, studentNumber, person.getStudent());
            this.addPersonalDataRow(personalData, alumniName, studentNumber, person, person.getStudent().getAlumni());
            if (person.getStudent().getAlumni() == null) continue;
            for (Job job : person.getStudent().getAlumni().getJobs()) {
                this.addJobDataRow(jobData, alumniName, studentNumber, job);
            }
            for (Formation formation : person.getStudent().getAlumni().getFormations()) {
                this.addFormationDataRow(formationData, alumniName, studentNumber, formation);
            }
        }
        ArrayList<Spreadsheet> sheets = new ArrayList<Spreadsheet>(4);
        sheets.add(curriculumData);
        sheets.add(personalData);
        sheets.add(jobData);
        sheets.add(formationData);
        return sheets;
    }

    private void addCurriculumDataRow(Spreadsheet sheet, String alumniName, Integer studentNumber, Student student) {
        Alumni alumni = student.getAlumni();
        for (Registration registration : student.getRegistrationsSet()) {
            if (registration.isBolonha()) {
                if (!registration.hasConcluded()) continue;
                TreeSet<CycleCurriculumGroup> concludeCycles = new TreeSet<CycleCurriculumGroup>(CycleCurriculumGroup.COMPARATOR_BY_CYCLE_TYPE_AND_ID);
                concludeCycles.addAll(registration.getLastStudentCurricularPlan().getInternalCycleCurriculumGrops());
                Spreadsheet.Row row = sheet.addRow();
                row.setCell(alumniName);
                row.setCell(studentNumber);
                row.setCell(registration.getDegreeName());
                row.setCell(registration.getStartDate().toString(DATE_FORMAT));
                CycleCurriculumGroup lastConcludedCycle = (CycleCurriculumGroup)((Object)concludeCycles.last());
                try {
                    row.setCell(lastConcludedCycle.isConclusionProcessed() ? lastConcludedCycle.getConclusionDate().toString(DATE_FORMAT) : lastConcludedCycle.calculateConclusionDate().toString(DATE_FORMAT));
                }
                catch (Exception ex) {
                    row.setCell(NOT_AVAILABLE);
                }
                row.setCell("Bolonha");
                row.setCell(alumni != null && alumni.getIsEmployed() != null ? this.getApp("label." + alumni.getIsEmployed()) : NOT_AVAILABLE);
                continue;
            }
            if (!registration.isRegistrationConclusionProcessed()) continue;
            Spreadsheet.Row row = sheet.addRow();
            row.setCell(alumniName);
            row.setCell(studentNumber);
            row.setCell(registration.getDegreeName());
            row.setCell(registration.getStartDate().toString(DATE_FORMAT));
            row.setCell(registration.getConclusionDate() != null ? registration.getConclusionDate().toString(DATE_FORMAT) : NOT_AVAILABLE);
            row.setCell("Pre-Bolonha");
            row.setCell(alumni != null && alumni.getIsEmployed() != null ? this.getApp("label." + alumni.getIsEmployed()) : NOT_AVAILABLE);
        }
    }

    private void addPersonalDataRow(Spreadsheet sheet, String alumniName, Integer studentNumber, Person person, Alumni alumni) {
        Spreadsheet.Row row = sheet.addRow();
        row.setCell(alumniName);
        row.setCell(studentNumber);
        YearMonthDay dateOfBirth = person.getDateOfBirthYearMonthDay();
        row.setCell(dateOfBirth == null ? NOT_AVAILABLE : dateOfBirth.toString(DATE_FORMAT));
        row.setCell(this.hasLastPersonalAddress(person) ? this.getLastPersonalAddress(person).getAddress() : NOT_AVAILABLE);
        row.setCell(this.hasLastPersonalAddress(person) ? this.getLastPersonalAddress(person).getAreaCode() : NOT_AVAILABLE);
        row.setCell(this.hasLastPersonalAddress(person) ? this.getLastPersonalAddress(person).getArea() : NOT_AVAILABLE);
        row.setCell(this.hasLastPersonalAddress(person) ? this.getLastPersonalAddress(person).getCountryOfResidenceName() : NOT_AVAILABLE);
        row.setCell(this.hasPersonalEmail(person) != false ? this.getPersonalEmail(person).getValue() : NOT_AVAILABLE);
        row.setCell(this.hasSendingEmail(person) != false ? this.getSendingEmail(person) : NOT_AVAILABLE);
        row.setCell(this.hasPersonalPhone(person) != false ? this.getPersonalPhone(person).getNumber() : NOT_AVAILABLE);
        row.setCell(this.hasRegisteredWhen(alumni) ? alumni.getRegisteredWhen().toString("yyyy-MM-dd") : NOT_AVAILABLE);
    }

    private boolean hasRegisteredWhen(Alumni alumni) {
        return alumni != null && alumni.getRegisteredWhen() != null;
    }

    public boolean hasLastPersonalAddress(Person person) {
        return this.getLastPersonalAddress(person) != null;
    }

    public PhysicalAddress getLastPersonalAddress(Person person) {
        if (person.getStudent().getAlumni() != null) {
            return person.getStudent().getAlumni().getLastPersonalAddress();
        }
        TreeSet<DomainObject> addressSet = new TreeSet<DomainObject>(DomainObjectUtil.COMPARATOR_BY_ID);
        addressSet.addAll(person.getPhysicalAddresses());
        return !addressSet.isEmpty() && addressSet.last() != null ? (PhysicalAddress)((Object)addressSet.last()) : null;
    }

    public EmailAddress getPersonalEmail(Person person) {
        if (person.getStudent().getAlumni() != null) {
            return person.getStudent().getAlumni().getPersonalEmail();
        }
        for (EmailAddress email : person.getEmailAddresses()) {
            if (!email.isPersonalType()) continue;
            return email;
        }
        return null;
    }

    public Boolean hasPersonalEmail(Person person) {
        return this.getPersonalEmail(person) != null;
    }

    public Phone getPersonalPhone(Person person) {
        if (person.getStudent() != null && person.getStudent().getAlumni() != null) {
            return person.getStudent().getAlumni().getPersonalPhone();
        }
        for (Phone phone : person.getPhones()) {
            if (!phone.isPersonalType()) continue;
            return phone;
        }
        return null;
    }

    public Boolean hasPersonalPhone(Person person) {
        return this.getPersonalPhone(person) != null;
    }

    public Boolean hasSendingEmail(Person person) {
        return this.getSendingEmail(person) != null;
    }

    public String getSendingEmail(Person person) {
        return person.getEmailForSendingEmails();
    }

    private String getEnum(String key) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (Locale)PT, (String)key, (String[])new String[0]);
    }

    private String getApp(String key) {
        return BundleUtil.getString((String)"resources.ApplicationResources", (Locale)PT, (String)key, (String[])new String[0]);
    }

    private void addJobDataRow(Spreadsheet sheet, String alumniName, Integer studentNumber, Job job) {
        Spreadsheet.Row row = sheet.addRow();
        row.setCell(job.getExternalId());
        row.setCell(alumniName);
        row.setCell(studentNumber);
        row.setCell(job.getEmployerName());
        row.setCell(job.getCity());
        row.setCell(job.getCountry() != null ? job.getCountry().getName() : NOT_AVAILABLE);
        row.setCell(job.getBusinessArea() != null ? job.getBusinessArea().getCode() : NOT_AVAILABLE);
        row.setCell(job.getBusinessArea() != null ? job.getBusinessArea().getDescription().replace(';', '|') : NOT_AVAILABLE);
        row.setCell(job.getPosition());
        row.setCell(job.getBeginDate() != null ? job.getBeginDate().toString(DATE_FORMAT) : NOT_AVAILABLE);
        row.setCell(job.getEndDate() != null ? job.getEndDate().toString(DATE_FORMAT) : NOT_AVAILABLE);
        row.setCell(job.getContractType() != null ? this.getEnum(job.getContractType().getQualifiedName()) : NOT_AVAILABLE);
        row.setCell(job.getJobApplicationType() != null ? this.getEnum(job.getJobApplicationType().getQualifiedName()) : NOT_AVAILABLE);
        row.setCell(job.getSalary() != null ? job.getSalary().toString() : NOT_AVAILABLE);
        row.setCell(job.getSalaryType() != null ? this.getEnum(job.getSalaryType().getQualifiedName()) : NOT_AVAILABLE);
        row.setCell(job.getLastModifiedDate() != null ? job.getLastModifiedDate().toString(DATE_FORMAT) : NOT_AVAILABLE);
        AlumniIdentityCheckRequest lastIdentityRequest = job.getPerson().getStudent().getAlumni().getLastIdentityRequest();
        row.setCell(lastIdentityRequest != null ? lastIdentityRequest.getCreationDateTime().toString(DATE_FORMAT) : NOT_AVAILABLE);
    }

    private void addFormationDataRow(Spreadsheet sheet, String alumniName, Integer studentNumber, Formation formation) {
        Spreadsheet.Row row = sheet.addRow();
        row.setCell(formation.getExternalId());
        row.setCell(alumniName);
        row.setCell(studentNumber);
        row.setCell(formation.getFormationType() != null ? this.getEnum(formation.getFormationType().getQualifiedName()) : NOT_AVAILABLE);
        row.setCell(formation.getType() != null ? this.getEnum(formation.getType().getQualifiedName()) : NOT_AVAILABLE);
        row.setCell(formation.getInstitution() != null ? formation.getInstitution().getUnitName().getName() : NOT_AVAILABLE);
        row.setCell(formation.getEducationArea() != null ? formation.getEducationArea().getCode() : NOT_AVAILABLE);
        row.setCell(formation.getEducationArea() != null ? formation.getEducationArea().getDescription().replace(';', '|') : NOT_AVAILABLE);
        row.setCell(formation.getBeginYear());
        row.setCell(formation.getYear());
        row.setCell(formation.getEctsCredits() != null ? formation.getEctsCredits().toString() : NOT_AVAILABLE);
        row.setCell(formation.getFormationHours() != null ? formation.getFormationHours().toString() : NOT_AVAILABLE);
        row.setCell(formation.getLastModificationDateDateTime() != null ? formation.getLastModificationDateDateTime().toString(DATE_FORMAT) : NOT_AVAILABLE);
        AlumniIdentityCheckRequest lastIdentityRequest = formation.getPerson().getStudent().getAlumni().getLastIdentityRequest();
        row.setCell(lastIdentityRequest != null ? lastIdentityRequest.getCreationDateTime().toString(DATE_FORMAT) : NOT_AVAILABLE);
    }

    public static AlumniReportFile launchJob(boolean fullReport, boolean onlyRegisteredAlumni) {
        return new AlumniReportFile(fullReport, onlyRegisteredAlumni);
    }

    public static List<AlumniReportFile> readDoneJobs() {
        ArrayList<AlumniReportFile> reportFileList = new ArrayList<AlumniReportFile>();
        CollectionUtils.select((Collection)ExecutionYear.readCurrentExecutionYear().getAlumniReportFilesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((AlumniReportFile)((Object)arg0)).getDone();
            }
        }, reportFileList);
        return reportFileList;
    }

    public static List<AlumniReportFile> readUndoneJobs() {
        return new ArrayList<AlumniReportFile>(CollectionUtils.subtract((Collection)ExecutionYear.readCurrentExecutionYear().getAlumniReportFilesSet(), AlumniReportFile.readDoneJobs()));
    }

    public static List<AlumniReportFile> readPendingJobs() {
        ArrayList<AlumniReportFile> reportFileList = new ArrayList<AlumniReportFile>();
        CollectionUtils.select((Collection)ExecutionYear.readCurrentExecutionYear().getAlumniReportFilesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((AlumniReportFile)((Object)arg0)).getIsNotDoneAndNotCancelled();
            }
        }, reportFileList);
        return reportFileList;
    }

    public static Boolean canRequestReport() {
        return AlumniReportFile.readPendingJobs().isEmpty();
    }
}

